/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.builder.impl.SetBlockCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.event.KeyHandler;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonPiano;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;

public class ContentNoteEditor
extends Content {
    private static final ResourceLocation NOTE = new ResourceLocation("worldhandler", "textures/misc/note.png");
    private final SetBlockCommandBuilder builderNoteEditor = new SetBlockCommandBuilder();
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderNoteEditor, (Object)SetBlockCommandBuilder.Label.REPLACE);
    private boolean isActive;

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.isActive ? this.preview : null;
    }

    @Override
    public void init(Container container) {
        this.isActive = BlockHelper.getFocusedBlock() instanceof NoteBlock;
        this.builderNoteEditor.pos().set(BlockHelper.getFocusedBlockPos());
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.isActive) {
            BlockPos pos = this.builderNoteEditor.pos().getBlockPos();
            SoundEvent sound = (SoundEvent)ContentNoteEditor.getSoundEvent(pos).m_263188_().get();
            container.m_142416_(new GuiButtonPiano(x - 3 + 15, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.g"), sound, 0.53f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 1)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 30, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.a"), sound, 0.6f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 3)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 45, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.b"), sound, 0.67f, GuiButtonPiano.Type.RIGHT, () -> this.setNote(container.getPlayer(), 5)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 60, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.c"), sound, 0.7f, GuiButtonPiano.Type.LEFT, () -> this.setNote(container.getPlayer(), 6)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 75, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.d"), sound, 0.8f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 8)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 90, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.e"), sound, 0.9f, GuiButtonPiano.Type.RIGHT, () -> this.setNote(container.getPlayer(), 10)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 105, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.f"), sound, 0.95f, GuiButtonPiano.Type.LEFT, () -> this.setNote(container.getPlayer(), 11)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 120, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.g"), sound, 1.05f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 13)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 135, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.a"), sound, 1.2f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 15)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 150, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.b"), sound, 1.32f, GuiButtonPiano.Type.RIGHT, () -> this.setNote(container.getPlayer(), 17)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 165, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.c"), sound, 1.4f, GuiButtonPiano.Type.LEFT, () -> this.setNote(container.getPlayer(), 18)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 180, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.d"), sound, 1.6f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 20)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 195, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.e"), sound, 1.8f, GuiButtonPiano.Type.RIGHT, () -> this.setNote(container.getPlayer(), 22)));
            container.m_142416_(new GuiButtonPiano(x - 3 + 210, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.f"), sound, 1.9f, GuiButtonPiano.Type.LEFT, () -> this.setNote(container.getPlayer(), 23)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 15, y, 9, 58, (Component)Component.m_237113_((String)"F#"), sound, 0.5f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 0)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 30, y, 9, 58, (Component)Component.m_237113_((String)"G#"), sound, 0.56f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 2)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 45, y, 9, 58, (Component)Component.m_237113_((String)"A#"), sound, 0.63f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 4)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 75, y, 9, 58, (Component)Component.m_237113_((String)"C#"), sound, 0.75f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 7)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 90, y, 9, 58, (Component)Component.m_237113_((String)"D#"), sound, 0.85f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 9)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 120, y, 9, 58, (Component)Component.m_237113_((String)"F#"), sound, 1.0f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 12)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 135, y, 9, 58, (Component)Component.m_237113_((String)"G#"), sound, 1.1f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 14)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 150, y, 9, 58, (Component)Component.m_237113_((String)"A#"), sound, 1.25f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 16)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 180, y, 9, 58, (Component)Component.m_237113_((String)"C#"), sound, 1.5f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 19)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 195, y, 9, 58, (Component)Component.m_237113_((String)"D#"), sound, 1.7f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 21)));
            container.m_142416_(new GuiButtonPiano(x - 3 - 5 + 225, y, 9, 58, (Component)Component.m_237113_((String)"F#"), sound, 2.0f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 24)));
        }
    }

    private void setNote(String player, int note) {
        SetBlockCommandBuilder builder = new SetBlockCommandBuilder();
        BlockPos pos = this.builderNoteEditor.pos().getBlockPos();
        builder.pos().set(pos);
        NoteBlockInstrument instrument = ContentNoteEditor.getSoundEvent(pos);
        BlockState state = (BlockState)((BlockState)Blocks.f_50065_.m_49966_().m_61124_((Property)BlockStateProperties.f_61395_, (Comparable)instrument)).m_61124_((Property)BlockStateProperties.f_61424_, (Comparable)Integer.valueOf(note));
        builder.block().set(state);
        CommandHelper.sendCommand(player, builder, (Object)SetBlockCommandBuilder.Label.REPLACE);
    }

    @Override
    public void drawScreen(GuiGraphics guiGraphics, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280218_(NOTE, x - 1, y - 1, 0, 0, 8, 59);
            guiGraphics.m_280218_(NOTE, x - 1, y - 1 + 59, 0, 59, 13, 35);
            guiGraphics.m_280218_(NOTE, x - 1 + 232 - 5, y - 1, 18, 0, 7, 59);
            guiGraphics.m_280218_(NOTE, x - 1 + 232 - 10, y - 1 + 59, 13, 59, 12, 35);
            guiGraphics.m_280218_(NOTE, x - 1 + 8, y - 1, 0, 94, 219, 1);
            guiGraphics.m_280218_(NOTE, x - 1 + 13, y - 1 + 93, 0, 94, 209, 1);
        } else {
            float scale = 4.0f;
            PoseStack posestack = guiGraphics.m_280168_();
            posestack.m_85836_();
            posestack.m_252880_((float)(container.f_96543_ / 2) - 8.5f * scale, (float)(container.f_96544_ / 2 - 15) - 8.5f * scale, 0.0f);
            posestack.m_85841_(scale, scale, scale);
            guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_41859_), 0, 0);
            posestack.m_85849_();
            MutableComponent text = Component.m_237110_((String)"gui.worldhandler.blocks.note_block_editor.look_at_note_block", (Object[])new Object[]{KeyHandler.KEY_WORLD_HANDLER.m_90863_()});
            Font font = Minecraft.m_91087_().f_91062_;
            guiGraphics.m_280614_(font, (Component)text, x + 116 - font.m_92852_((FormattedText)text) / 2, y + 70, Config.getSkin().getLabelColor(), false);
        }
    }

    private static NoteBlockInstrument getSoundEvent(BlockPos blockPos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            NoteBlockInstrument noteblockinstrument = level.m_8055_(blockPos.m_7494_()).m_280603_();
            if (noteblockinstrument.m_280504_()) {
                return noteblockinstrument;
            }
            NoteBlockInstrument noteblockinstrument1 = level.m_8055_(blockPos.m_7495_()).m_280603_();
            NoteBlockInstrument noteblockinstrument2 = noteblockinstrument1.m_280504_() ? NoteBlockInstrument.HARP : noteblockinstrument1;
            return noteblockinstrument2;
        }
        return null;
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.blocks.note_block_editor");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.blocks.note_block_editor");
    }

    @Override
    public Content getActiveContent() {
        return Contents.NOTE_EDITOR;
    }
}

