/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.impl.ScoreboardCommandBuilder;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.content.impl.ContentScoreboard;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiHintTextField;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicButtonList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuButtonList;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.TranslationHelper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ContentScoreboardObjectives
extends ContentScoreboard {
    private GuiHintTextField objectField;
    private Page page = Page.CREATE;

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return new IContent.CommandPreview(BUILDER, (Object)this.page.getLabel());
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.objectField = new GuiHintTextField(x + 118, y + this.page.getShift(), 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.objectives.objective"));
        this.objectField.m_94153_((Predicate)Predicates.notNull());
        this.objectField.m_94151_(text -> {
            BUILDER.objective().set((String)text);
            BUILDER.displayName().deserialize((String)text);
            container.initButtons();
        });
        this.objectField.m_94144_(BUILDER.objective().get());
        if (Page.CREATE.equals((Object)this.page)) {
            MenuButtonList objectives = new MenuButtonList(x + 118, y + 24, HELPER.getObjectives(), 2, new ILogicButtonList(){

                @Override
                public MutableComponent translate(String key, int depth) {
                    String translation;
                    ResourceLocation resource = this.makeResourceLocation(key);
                    if (resource != null) {
                        StatType type = (StatType)ForgeRegistries.STAT_TYPES.getValue(resource);
                        if (type != null) {
                            if (type.equals(Stats.f_12988_)) {
                                return Component.m_237115_((String)"gui.worldhandler.scoreboard.objectives.stat.custom");
                            }
                            if (type.equals(Stats.f_12986_)) {
                                return Component.m_237115_((String)"gui.worldhandler.scoreboard.objectives.stat.killed");
                            }
                            if (type.equals(Stats.f_12987_)) {
                                return Component.m_237115_((String)"gui.worldhandler.scoreboard.objectives.stat.killed_by");
                            }
                            return Component.m_237115_((String)type.m_12904_());
                        }
                        String translation2 = TranslationHelper.translate(resource);
                        if (translation2 != null) {
                            return Component.m_237115_((String)translation2);
                        }
                    }
                    if (!(translation = "stat." + key).equals(I18n.m_118938_((String)translation, (Object[])new Object[0]))) {
                        return Component.m_237115_((String)translation);
                    }
                    if (Arrays.stream(ChatFormatting.values()).map(ChatFormatting::m_126666_).anyMatch((Predicate<String>)Predicates.equalTo((Object)key))) {
                        return Component.m_237115_((String)("gui.worldhandler.color." + key));
                    }
                    return Component.m_237115_((String)("gui.worldhandler.scoreboard.objectives.stat." + key));
                }

                @Override
                public void onClick(String key, int depth) {
                    ContentScoreboard.BUILDER.criteria().set(key);
                }

                @Override
                public String buildEventKey(List<String> keys, int depth) {
                    if (this.isRegistryItem(keys.get(keys.size() - 1))) {
                        return String.join((CharSequence)":", keys);
                    }
                    return ILogicButtonList.super.buildEventKey(keys, depth);
                }

                @Override
                public String getId() {
                    return "objectives";
                }

                @Nullable
                private ResourceLocation makeResourceLocation(String key) {
                    return ResourceLocation.m_135820_((String)key.replace(".", ":"));
                }

                @Nullable
                private boolean isRegistryItem(String key) {
                    return this.isRegistryItem(this.makeResourceLocation(key));
                }

                @Nullable
                private boolean isRegistryItem(ResourceLocation resource) {
                    IForgeRegistry[] registries;
                    for (IForgeRegistry registry : registries = new IForgeRegistry[]{ForgeRegistries.BLOCKS, ForgeRegistries.ITEMS, ForgeRegistries.ENTITY_TYPES}) {
                        if (!registry.containsKey(resource)) continue;
                        return true;
                    }
                    return ForgeRegistries.STAT_TYPES.containsKey(resource);
                }
            });
            container.addMenu(objectives);
        } else if (Page.DISPLAY.equals((Object)this.page) || Page.UNDISPLAY.equals((Object)this.page)) {
            MenuButtonList slots = new MenuButtonList(x + 118, y + 24 - this.page.getShift(), HELPER.getSlots(), 2, new ILogicButtonList(){

                @Override
                public MutableComponent translate(String key, int depth) {
                    if (depth == 0) {
                        return Component.m_237115_((String)("gui.worldhandler.scoreboard.slot." + key));
                    }
                    if (depth == 1) {
                        return Component.m_237115_((String)("gui.worldhandler.color." + key));
                    }
                    return Component.m_237113_((String)key);
                }

                @Override
                public void onClick(String key, int depth) {
                    ContentScoreboard.BUILDER.slot().set(key);
                }

                @Override
                public String getId() {
                    return "slots";
                }
            });
            container.addMenu(slots);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.objectives.create"), () -> {
            this.page = Page.CREATE;
            container.m_7856_();
        });
        container.m_142416_(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.objectives.display"), () -> {
            this.page = Page.DISPLAY;
            container.m_7856_();
        });
        container.m_142416_(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.objectives.undisplay"), () -> {
            this.page = Page.UNDISPLAY;
            container.m_7856_();
        });
        container.m_142416_(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.objectives.remove"), () -> {
            this.page = Page.REMOVE;
            container.m_7856_();
        });
        container.m_142416_(button4);
        button1.f_93623_ = !Page.CREATE.equals((Object)this.page);
        button2.f_93623_ = !Page.DISPLAY.equals((Object)this.page);
        button3.f_93623_ = !Page.UNDISPLAY.equals((Object)this.page);
        boolean bl = button4.f_93623_ = !Page.REMOVE.equals((Object)this.page);
        if (!Page.UNDISPLAY.equals((Object)this.page)) {
            container.m_142416_(this.objectField);
        }
        button1 = new GuiButtonBase(x + 118, y + 72 - this.page.getShift(), 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.perform"), () -> {
            CommandHelper.sendCommand(container.getPlayer(), BUILDER, (Object)this.page.getLabel());
            container.m_7856_();
        });
        container.m_142416_(button1);
        button1.f_93623_ = Page.UNDISPLAY.equals((Object)this.page) || BUILDER.objective().get() != null && !BUILDER.objective().get().isEmpty();
    }

    @Override
    public void tick(Container container) {
        if (!Page.UNDISPLAY.equals((Object)this.page)) {
            this.objectField.m_94120_();
        }
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.scoreboard.objectives");
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_OBJECTIVES;
    }

    public static enum Page {
        CREATE(0, ScoreboardCommandBuilder.Label.OBJECTIVES_ADD_DISPLAYNAME),
        DISPLAY(0, ScoreboardCommandBuilder.Label.OBJECTIVES_SETDISPLAY_SLOT_OBJECTIVE),
        UNDISPLAY(12, ScoreboardCommandBuilder.Label.OBJECTIVES_SETDISPLAY_SLOT),
        REMOVE(24, ScoreboardCommandBuilder.Label.OBJECTIVES_REMOVE);

        private final int shift;
        private final ScoreboardCommandBuilder.Label label;

        private Page(int shift, ScoreboardCommandBuilder.Label label) {
            this.shift = shift;
            this.label = label;
        }

        public int getShift() {
            return this.shift;
        }

        public ScoreboardCommandBuilder.Label getLabel() {
            return this.label;
        }
    }
}

