/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.widget.IContainerWidget;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.RenderUtils;
import exopandora.worldhandler.util.ResourceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class WidgetTabRenderer
implements IContainerWidget {
    private static final int SPACING = 2;
    private static final int WEDGE_HEIGHT = 10;

    @Override
    public void initButtons(Container container, int x, int y) {
        Content content = container.getContent();
        Category category = content.getCategory();
        int xPos = container.getBackgroundX();
        int yPos = container.getBackgroundY() - 20;
        int size = category.getSize();
        for (int index = 0; index < size; ++index) {
            Content tab = category.getContent(index);
            if (tab.equals(content.getActiveContent())) continue;
            int width = WidgetTabRenderer.width(container, index, size);
            int offset = WidgetTabRenderer.offset(container, index, size);
            container.m_7787_(new GuiButtonBase(xPos + offset, yPos, width, 21, (Component)tab.getTabTitle(), () -> ActionHelper.open(tab)));
        }
    }

    @Override
    public void drawScreen(GuiGraphics guiGraphics, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        Content content = container.getContent();
        Category category = content.getCategory();
        ResourceLocation texture = ResourceHelper.backgroundTexture();
        int xPos = container.getBackgroundX();
        int yPos = container.getBackgroundY();
        int size = category.getSize();
        for (int index = 0; index < size; ++index) {
            int width = WidgetTabRenderer.width(container, index, size);
            int offset = WidgetTabRenderer.offset(container, index, size);
            Content tab = category.getContent(index);
            MutableComponent title = tab.getTabTitle().m_130940_(ChatFormatting.UNDERLINE);
            if (content.getActiveContent().equals(tab)) {
                int height = Config.getSkin().getBackgroundAlphaInt() == 255 ? 25 : 22;
                this.drawActiveTab(guiGraphics, container, texture, index, size, xPos + offset, yPos - 22, width, height, (Component)title);
                continue;
            }
            this.drawInactiveTab(guiGraphics, container, texture, index, size, xPos + offset, yPos - 20, width, 20, (Component)title);
        }
        RenderUtils.colorDefaultBackground();
    }

    private void drawActiveTab(GuiGraphics guiGraphics, Container container, ResourceLocation texture, int index, int size, int x, int y, int width, int height, Component title) {
        RenderUtils.colorDefaultBackground();
        this.drawTabBackground(guiGraphics, container, texture, x, y, width, height);
        if (!Config.getSkin().sharpEdges()) {
            RenderSystem.enableBlend();
            if (Config.getSkin().getBackgroundAlphaInt() == 255) {
                if (index > 0) {
                    RenderUtils.drawTexturedTriangleBL(guiGraphics, texture, x, y + height - 2, x - container.getBackgroundX(), 1, 2);
                }
                if (index < size - 1 || size == 1) {
                    RenderUtils.drawTexturedTriangleBR(guiGraphics, texture, x + width - 2, y + height - 2, x - container.getBackgroundX() + width, 1, 2);
                }
                if (index == 0) {
                    RenderUtils.drawTexturedWedgeGradientTL(guiGraphics, texture, x, y + height, 0, height, width, 10);
                }
                if (index == size - 1 && size > 1) {
                    RenderUtils.drawTexturedWedgeGradientTR(guiGraphics, texture, x, y + height, x - container.getBackgroundX(), height, width, 10);
                }
            } else {
                this.drawTabBackgroundMerge(guiGraphics, container, texture, index, size, x, y, width, height);
            }
            RenderSystem.disableBlend();
        }
        this.drawTabTitle(guiGraphics, title, true, x, y, width, y + height, 0xFFFFFF);
    }

    private void drawInactiveTab(GuiGraphics guiGraphics, Container container, ResourceLocation texture, int index, int size, int x, int y, int width, int height, Component title) {
        RenderUtils.colorDarkBackground();
        this.drawTabBackground(guiGraphics, container, texture, x, y, width, 20);
        if (!Config.getSkin().sharpEdges()) {
            RenderSystem.enableBlend();
            this.drawTabBackgroundMerge(guiGraphics, container, texture, index, size, x, y, width, height);
            RenderSystem.disableBlend();
        }
        this.drawTabTitle(guiGraphics, title, false, x, y + 2, width, y + height, 0xE0E0E0);
    }

    private void drawTabBackgroundMerge(GuiGraphics guiGraphics, Container container, ResourceLocation texture, int index, int size, int x, int y, int width, int height) {
        if (index == 0) {
            RenderUtils.drawTexturedTriangleTL(guiGraphics, texture, x, y + height, 0, height, 2);
        }
        if (index == size - 1) {
            RenderUtils.drawTexturedTriangleTR(guiGraphics, texture, x + width - 3, y + height, container.getBackgroundWidth() - 3, height, 3);
        }
    }

    private void drawTabBackground(GuiGraphics guiGraphics, Container container, ResourceLocation texture, int x, int y, int width, int height) {
        int left = Mth.m_14165_((double)((double)width / 2.0));
        int right = Mth.m_14107_((double)((double)width / 2.0));
        RenderSystem.enableBlend();
        guiGraphics.m_280218_(texture, x, y, 0, 0, left, height);
        guiGraphics.m_280218_(texture, x + left, y, container.getBackgroundWidth() - right, 0, right, height);
        RenderSystem.disableBlend();
    }

    private void drawTabTitle(GuiGraphics guiGraphics, Component title, boolean isActive, int x, int y, int width, int height, int color) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        AbstractWidget.m_280138_((GuiGraphics)guiGraphics, (Font)font, (Component)title, (int)(x + 5), (int)y, (int)(x + width - 5), (int)height, (int)color);
    }

    @Override
    public IContainerWidget.EnumLayer getLayer() {
        return IContainerWidget.EnumLayer.BACKGROUND;
    }

    private static int width(Container container, int index, int size) {
        int width = Math.round((container.getBackgroundWidth() - Math.max(size - 1, 1) * 2) / Math.max(size, 2));
        if (index == 1 && size == 3) {
            return width + 1;
        }
        return width;
    }

    private static int offset(Container container, int index, int size) {
        return (int)Math.round((double)index * (double)(container.getBackgroundWidth() + 2) / (double)size);
    }

    public void m_93692_(boolean focused) {
    }

    public boolean m_93696_() {
        return false;
    }
}

