/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.widget.button;

import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicMapped;
import exopandora.worldhandler.util.TextUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class GuiButtonList<T>
extends GuiButtonTooltip {
    private final ILogicMapped<T> logic;
    private final Persistence persistence;
    private final List<T> items;

    public GuiButtonList(int x, int y, List<T> items, int widthIn, int heightIn, Container container, ILogicMapped<T> logic) {
        super(x, y, widthIn, heightIn, (Component)Component.m_237119_(), null, null);
        this.items = items;
        this.logic = logic;
        this.persistence = container.getContent().getPersistence(this.logic.getId(), Persistence::new);
        this.init();
    }

    private void init() {
        this.logic.onInit(this.items.get(this.persistence.getIndex()));
        this.updateMessage();
    }

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.updateMessage();
        Font font = Minecraft.m_91087_().f_91062_;
        if (this.m_6035_() != null && !this.m_6035_().getString().isEmpty()) {
            MutableComponent leftArrow = this.isHoveringLeft(mouseX, mouseY) ? TextUtils.ARROW_LEFT_BOLD : TextUtils.ARROW_LEFT;
            MutableComponent rightArrow = this.isHoveringRight(mouseX, mouseY) ? TextUtils.ARROW_RIGHT_BOLD : TextUtils.ARROW_RIGHT;
            int combinedArrowWidth = font.m_92895_("<   >");
            int maxWidth = Math.max(0, this.f_93618_ - combinedArrowWidth);
            int spaceWidth = font.m_92895_(" ");
            int yPos = this.m_252907_() + (this.f_93619_ - 8) / 2;
            this.m_280372_(guiGraphics, font, combinedArrowWidth / 2 + 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            guiGraphics.m_280653_(font, (Component)leftArrow, this.m_252754_() + this.f_93618_ / 2 - maxWidth / 2 - spaceWidth, yPos, this.getFGColor());
            guiGraphics.m_280653_(font, (Component)rightArrow, this.m_252754_() + this.f_93618_ / 2 + maxWidth / 2 + spaceWidth, yPos, this.getFGColor());
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY) {
        this.tooltip = this.logic.formatTooltip(this.items.get(this.persistence.getIndex()), this.persistence.getIndex() + 1, this.items.size());
        super.renderTooltip(guiGraphics, font, mouseX, mouseY);
    }

    public void m_5716_(double mouseX, double mouseY) {
        int max = this.items.size() - 1;
        int index = this.persistence.getIndex();
        if (this.isHoveringLeft(mouseX, mouseY)) {
            if (Screen.m_96638_()) {
                if (index < 10) {
                    this.persistence.setIndex((index - 9 + max) % max);
                } else {
                    this.persistence.decrementIndex(10);
                }
            } else if (index > 0) {
                this.persistence.decrementIndex();
            } else {
                this.persistence.setIndex(max);
            }
        } else if (this.isHoveringRight(mouseX, mouseY)) {
            if (Screen.m_96638_()) {
                if (index > max - 10) {
                    this.persistence.setIndex((index + 9 - max) % max);
                } else {
                    this.persistence.incrementIndex(10);
                }
            } else if (index < max) {
                this.persistence.incrementIndex();
            } else {
                this.persistence.setIndex(0);
            }
        }
        this.logic.onClick(this.items.get(this.persistence.getIndex()));
    }

    private void updateMessage() {
        this.m_93666_((Component)this.logic.translate(this.items.get(this.persistence.getIndex())));
    }

    private boolean isHoveringLeft(double mouseX, double mouseY) {
        return this.isHoveringVertical(mouseY) && mouseX >= (double)this.m_252754_() && mouseX < (double)this.m_252754_() + Math.ceil(this.f_93618_ / 2);
    }

    private boolean isHoveringRight(double mouseX, double mouseY) {
        return this.isHoveringVertical(mouseY) && mouseX >= (double)this.m_252754_() + Math.ceil(this.f_93618_ / 2) && mouseX < (double)(this.m_252754_() + this.f_93618_);
    }

    private boolean isHoveringVertical(double mouseY) {
        return mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public static class Persistence {
        private int index;

        public Persistence() {
            this(0);
        }

        public Persistence(int index) {
            this.index = index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void incrementIndex() {
            ++this.index;
        }

        public void incrementIndex(int amount) {
            this.index += amount;
        }

        public void decrementIndex() {
            --this.index;
        }

        public void decrementIndex(int amount) {
            this.index -= amount;
        }
    }
}

