/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TranslationHelper {
    private static final Map<IForgeRegistry<?>, Function<?, String>> FORGE = new HashMap();

    private static <T> void registerRegistry(IForgeRegistry<T> registry, Function<T, String> mapper) {
        FORGE.put(registry, mapper);
    }

    @Nullable
    public static <T> String translate(ResourceLocation resource) {
        for (IForgeRegistry<?> registry : FORGE.keySet()) {
            if (!registry.containsKey(resource)) continue;
            return FORGE.get(registry).apply(registry.getValue(resource));
        }
        return null;
    }

    static {
        TranslationHelper.registerRegistry(ForgeRegistries.BLOCKS, Block::m_7705_);
        TranslationHelper.registerRegistry(ForgeRegistries.ITEMS, Item::m_5524_);
        TranslationHelper.registerRegistry(ForgeRegistries.MOB_EFFECTS, MobEffect::m_19481_);
        TranslationHelper.registerRegistry(ForgeRegistries.BIOMES, biome -> ForgeRegistries.BIOMES.getKey(biome).m_214296_("biome"));
        TranslationHelper.registerRegistry(ForgeRegistries.ENCHANTMENTS, Enchantment::m_44704_);
        TranslationHelper.registerRegistry(ForgeRegistries.ENTITY_TYPES, EntityType::m_20675_);
        TranslationHelper.registerRegistry(ForgeRegistries.STAT_TYPES, stat -> "stat." + stat.toString().replace(':', '.'));
        TranslationHelper.registerRegistry(ForgeRegistries.VILLAGER_PROFESSIONS, profession -> {
            ResourceLocation profName = ForgeRegistries.VILLAGER_PROFESSIONS.getKey(profession);
            return EntityType.f_20492_.m_20675_() + "." + (String)(!"minecraft".equals(profName.m_135827_()) ? profName.m_135827_() + "." : "") + profName.m_135815_();
        });
    }
}

