/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument.tag;

import exopandora.worldhandler.builder.argument.tag.EffectInstance;
import exopandora.worldhandler.builder.argument.tag.ITagProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractEffectTag
implements ITagProvider {
    private final Map<MobEffect, EffectInstance> effects = new HashMap<MobEffect, EffectInstance>();

    @Override
    @Nullable
    public Tag value() {
        ListTag list = new ListTag();
        for (Map.Entry<MobEffect, EffectInstance> entry : this.effects.entrySet()) {
            EffectInstance instance = entry.getValue();
            if (instance.getAmplifier() <= 0) continue;
            CompoundTag compound = new CompoundTag();
            int ticks = instance.toTicks();
            compound.m_128359_("id", ForgeRegistries.MOB_EFFECTS.getKey((Object)entry.getKey()).toString());
            compound.m_128344_("amplifier", (byte)(instance.getAmplifier() - 1));
            compound.m_128405_("duration", ticks > 0 ? ticks : 1000000);
            compound.m_128379_("ambient", instance.isAmbient());
            compound.m_128379_("show_particles", instance.doShowParticles());
            list.add((Object)compound);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public EffectInstance getOrCreate(MobEffect effect) {
        return this.effects.computeIfAbsent(effect, key -> new EffectInstance());
    }

    public Set<MobEffect> getMobEffects() {
        return this.effects.keySet();
    }

    public void remove(MobEffect potion) {
        this.effects.remove(potion);
    }

    public Map<MobEffect, EffectInstance> getEffects() {
        return Collections.unmodifiableMap(this.effects);
    }

    public void clear() {
        this.effects.clear();
    }
}

