/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.impl.CloneCommandBuilder;
import exopandora.worldhandler.builder.impl.FillCommandBuilder;
import exopandora.worldhandler.builder.impl.WHCommandBuilder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonList;
import exopandora.worldhandler.gui.widget.button.GuiHintTextField;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicMapped;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ContentEditBlocks
extends Content {
    private GuiHintTextField x1Field;
    private GuiHintTextField y1Field;
    private GuiHintTextField z1Field;
    private GuiHintTextField x2Field;
    private GuiHintTextField y2Field;
    private GuiHintTextField z2Field;
    private GuiHintTextField block1Field;
    private GuiHintTextField block2Field;
    private GuiHintTextField filterField;
    private final FillCommandBuilder builderFill = new FillCommandBuilder();
    private final CloneCommandBuilder builderClone = new CloneCommandBuilder();
    private final WHCommandBuilder builderWH = new WHCommandBuilder();
    private String block1;
    private String block2;
    private String filter;
    private Page page = Page.COORDINATES;
    private Mask mask = Mask.FILTERED;

    @Override
    public IContent.CommandPreview getCommandPreview() {
        if (Page.COORDINATES.equals((Object)this.page)) {
            return new IContent.CommandPreview(this.builderWH, null);
        }
        if (Page.FILL.equals((Object)this.page) || Page.REPLACE.equals((Object)this.page)) {
            return new IContent.CommandPreview(this.builderFill, (Object)FillCommandBuilder.Label.FILL);
        }
        if (Page.CLONE.equals((Object)this.page)) {
            return new IContent.CommandPreview(this.builderClone, (Object)this.mask.getLabel());
        }
        return null;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.updatePositions();
        this.x1Field = new GuiHintTextField(x + 118, y, 55, 20);
        this.x1Field.m_94153_((Predicate)this.coordinatePredicate("X1"));
        this.x1Field.m_94144_("X1: " + BlockHelper.pos1().m_123341_());
        this.x1Field.m_94151_(text -> BlockHelper.pos1().m_142451_(this.parseCoordinate((String)text)));
        this.y1Field = new GuiHintTextField(x + 118, y + 24, 55, 20);
        this.y1Field.m_94153_((Predicate)this.coordinatePredicate("Y1"));
        this.y1Field.m_94144_("Y1: " + BlockHelper.pos1().m_123342_());
        this.y1Field.m_94151_(text -> BlockHelper.pos1().m_142448_(this.parseCoordinate((String)text)));
        this.z1Field = new GuiHintTextField(x + 118, y + 48, 55, 20);
        this.z1Field.m_94153_((Predicate)this.coordinatePredicate("Z1"));
        this.z1Field.m_94144_("Z1: " + BlockHelper.pos1().m_123343_());
        this.z1Field.m_94151_(text -> BlockHelper.pos1().m_142443_(this.parseCoordinate((String)text)));
        this.x2Field = new GuiHintTextField(x + 118 + 59, y, 55, 20);
        this.x2Field.m_94153_((Predicate)this.coordinatePredicate("X2"));
        this.x2Field.m_94144_("X2: " + BlockHelper.pos2().m_123341_());
        this.x2Field.m_94151_(text -> BlockHelper.pos2().m_142451_(this.parseCoordinate((String)text)));
        this.y2Field = new GuiHintTextField(x + 118 + 59, y + 24, 55, 20);
        this.y2Field.m_94153_((Predicate)this.coordinatePredicate("Y2"));
        this.y2Field.m_94144_("Y2: " + BlockHelper.pos2().m_123342_());
        this.y2Field.m_94151_(text -> BlockHelper.pos2().m_142448_(this.parseCoordinate((String)text)));
        this.z2Field = new GuiHintTextField(x + 118 + 59, y + 48, 55, 20);
        this.z2Field.m_94153_((Predicate)this.coordinatePredicate("Z2"));
        this.z2Field.m_94144_("Z2: " + BlockHelper.pos2().m_123343_());
        this.z2Field.m_94151_(text -> BlockHelper.pos2().m_142443_(this.parseCoordinate((String)text)));
        this.block1Field = new GuiHintTextField(x + 118, y, 114, 20, (Component)(Page.FILL.equals((Object)this.page) ? Component.m_237115_((String)"gui.worldhandler.edit_blocks.fill.block_id_to_fill") : Component.m_237115_((String)"gui.worldhandler.edit_blocks.replace.block_id_replace")));
        this.block1Field.m_94153_((Predicate)Predicates.notNull());
        this.block1Field.m_94144_(this.block1);
        this.block1Field.m_94151_(text -> {
            this.block1 = text;
            this.builderFill.block().deserialize(this.block1.replace(' ', '_'));
            container.initButtons();
        });
        this.block2Field = new GuiHintTextField(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.replace.block_id_place"));
        this.block2Field.m_94153_((Predicate)Predicates.notNull());
        this.block2Field.m_94144_(this.block2);
        this.block2Field.m_94151_(text -> {
            this.block2 = text;
            this.builderFill.filter().deserialize(this.block2.replace(' ', '_'));
            container.initButtons();
        });
        this.filterField = new GuiHintTextField(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.clone.filter"));
        this.filterField.m_94153_((Predicate)Predicates.notNull());
        this.filterField.m_94144_(this.filter);
        this.filterField.m_94151_(text -> {
            this.filter = text;
            this.builderClone.filter().deserialize(this.filter.replace(' ', '_'));
            container.initButtons();
        });
    }

    @Override
    public void initButtons(final Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.coordinates"), () -> {
            this.page = Page.COORDINATES;
            container.m_7856_();
        });
        container.m_142416_(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.fill"), () -> {
            this.page = Page.FILL;
            container.m_7856_();
        });
        container.m_142416_(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.replace"), () -> {
            this.page = Page.REPLACE;
            container.m_7856_();
        });
        container.m_142416_(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.clone"), () -> {
            this.page = Page.CLONE;
            container.m_7856_();
        });
        container.m_142416_(button4);
        int yOffset1 = 0;
        int yOffset2 = 0;
        int xOffset2 = 0;
        int width1 = 0;
        int width2 = 0;
        if (Page.COORDINATES.equals((Object)this.page)) {
            button1.f_93623_ = false;
            yOffset1 = 72;
            yOffset2 = 72;
            width1 = 56;
            width2 = 56;
            xOffset2 = 58;
            container.m_142416_(this.x1Field);
            container.m_142416_(this.y1Field);
            container.m_142416_(this.z1Field);
            container.m_142416_(this.x2Field);
            container.m_142416_(this.y2Field);
            container.m_142416_(this.z2Field);
        } else if (Page.FILL.equals((Object)this.page)) {
            button2.f_93623_ = false;
            yOffset1 = 24;
            yOffset2 = 48;
            width1 = 114;
            width2 = 114;
            xOffset2 = 0;
            container.m_142416_(this.block1Field);
            button1 = new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.fill"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderFill, (Object)FillCommandBuilder.Label.FILL));
            container.m_142416_(button1);
            button1.f_93623_ = this.builderFill.block().hasValue();
        } else if (Page.REPLACE.equals((Object)this.page)) {
            button3.f_93623_ = false;
            yOffset1 = 48;
            yOffset2 = 48;
            width1 = 56;
            width2 = 56;
            xOffset2 = 58;
            container.m_142416_(this.block1Field);
            container.m_142416_(this.block2Field);
            button1 = new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.replace"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderFill, (Object)FillCommandBuilder.Label.REPLACE));
            container.m_142416_(button1);
            button1.f_93623_ = this.builderFill.block().hasValue() && this.builderFill.filter().hasValue();
        } else if (Page.CLONE.equals((Object)this.page)) {
            button4.f_93623_ = false;
            yOffset1 = 48;
            yOffset2 = 48;
            width1 = 56;
            width2 = 56;
            xOffset2 = 58;
            if (Mask.FILTERED.equals((Object)this.mask)) {
                container.m_142416_(this.filterField);
            } else {
                button1 = new GuiButtonBase(x + 118, y + 24, 114, 20, (Component)Component.m_237119_(), null);
                container.m_142416_(button1);
                button1.f_93623_ = false;
            }
            container.m_142416_(new GuiButtonList<Mask>(x + 118, y, Arrays.asList(Mask.values()), 114, 20, container, new ILogicMapped<Mask>(){

                @Override
                public MutableComponent translate(Mask mask) {
                    return Component.m_237115_((String)("gui.worldhandler.edit_blocks.clone.mode." + mask.toString()));
                }

                @Override
                public MutableComponent toTooltip(Mask mask) {
                    return Component.m_237113_((String)mask.toString());
                }

                @Override
                public void onClick(Mask mask) {
                    ContentEditBlocks.this.mask = mask;
                    container.m_7856_();
                }

                @Override
                public String getId() {
                    return "mask";
                }
            }));
            button2 = new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.clone"), () -> {
                System.out.println(this.builderClone.toCommand((Object)this.mask.getLabel(), false));
                CommandHelper.sendCommand(container.getPlayer(), this.builderClone, (Object)this.mask.getLabel());
            });
            container.m_142416_(button2);
            if (Mask.FILTERED.equals((Object)this.mask)) {
                button2.f_93623_ = this.builderClone.filter().hasValue();
            }
        }
        container.m_142416_(new GuiButtonBase(x + 118, y + yOffset1, width1, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.pos.set_pos_1"), () -> {
            BlockHelper.pos1().m_122190_((Vec3i)BlockHelper.getFocusedBlockPos());
            this.updatePositions();
            container.m_7856_();
        }));
        container.m_142416_(new GuiButtonBase(x + 118 + xOffset2, y + yOffset2, width2, 20, (Component)Component.m_237115_((String)"gui.worldhandler.edit_blocks.pos.set_pos_2"), () -> {
            BlockHelper.pos2().m_122190_((Vec3i)BlockHelper.getFocusedBlockPos());
            this.updatePositions();
            container.m_7856_();
        }));
    }

    private void updatePositions() {
        this.builderFill.from().set((BlockPos)BlockHelper.pos1());
        this.builderFill.to().set((BlockPos)BlockHelper.pos2());
        this.builderClone.begin().set((BlockPos)BlockHelper.pos1());
        this.builderClone.end().set((BlockPos)BlockHelper.pos2());
    }

    @Override
    public void tick(Container container) {
        if (Page.CLONE.equals((Object)this.page)) {
            this.builderClone.destination().set(Minecraft.m_91087_().f_91074_.m_20183_());
        }
    }

    private com.google.common.base.Predicate<String> coordinatePredicate(String coordinate) {
        return string -> string.matches(coordinate + ": [-]?[0-9]*");
    }

    private int parseCoordinate(String input) {
        String[] split;
        if (input != null && (split = input.split(": ", 2))[1].matches("[-]?[0-9]+")) {
            return Integer.parseInt(split[1]);
        }
        return 0;
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.blocks.edit_blocks");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.blocks.edit_blocks");
    }

    @Override
    public Content getActiveContent() {
        return Contents.EDIT_BLOCKS;
    }

    private static enum Page {
        COORDINATES,
        FILL,
        REPLACE,
        CLONE;

    }

    private static enum Mask {
        FILTERED(CloneCommandBuilder.Label.FILTERED),
        MASKED(CloneCommandBuilder.Label.MASKED),
        REPLACE(CloneCommandBuilder.Label.REPLACE);

        private final CloneCommandBuilder.Label label;

        private Mask(CloneCommandBuilder.Label label) {
            this.label = label;
        }

        public CloneCommandBuilder.Label getLabel() {
            return this.label;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

