/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.brigadier.arguments.BoolArgumentType;
import exopandora.worldhandler.builder.impl.GameRuleCommandBuilder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiHintTextField;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.GameRules;

public class ContentGamerules
extends Content {
    private GuiHintTextField valueField;
    private boolean booleanValue;
    private String value;
    private final GameRuleCommandBuilder builderGamerule = new GameRuleCommandBuilder();
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderGamerule, (Object)GameRuleCommandBuilder.Label.GAMERULE_VALUE);

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.preview;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        this.valueField = new GuiHintTextField(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.value"));
        this.valueField.m_94153_((Predicate)Predicates.notNull());
        this.valueField.m_94144_(this.value);
        this.valueField.m_94201_(false);
        this.valueField.m_94151_(text -> {
            this.value = text;
            this.builderGamerule.value().set((String)text);
        });
        final HashMap map = new HashMap();
        GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void m_6889_(GameRules.Key<T> rule, GameRules.Type<T> type) {
                map.put(rule.m_46328_(), type.m_46358_(null).getType());
            }
        });
        MenuPageList<String> rules = new MenuPageList<String>(x, y, new ArrayList(map.keySet()), 114, 20, 3, container, new ILogicPageList<String>(){

            @Override
            public MutableComponent translate(String rule) {
                return Component.m_237115_((String)("gamerule." + rule));
            }

            @Override
            public MutableComponent toTooltip(String rule) {
                return Component.m_237113_((String)rule);
            }

            @Override
            public void onClick(String rule) {
                ContentGamerules.this.builderGamerule.rule().set(rule);
                ContentGamerules.this.booleanValue = map.get(rule) instanceof BoolArgumentType;
                if (ContentGamerules.this.booleanValue) {
                    ContentGamerules.this.builderGamerule.value().set(null);
                } else {
                    ContentGamerules.this.builderGamerule.value().set(ContentGamerules.this.value);
                }
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, String item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, (Component)text, (Component)this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "gamerules";
            }
        });
        container.addMenu(rules);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.booleanValue) {
            container.m_142416_(new GuiButtonBase(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.enable"), () -> this.setGameRule(container.getPlayer(), String.valueOf(true))));
            container.m_142416_(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.disable"), () -> this.setGameRule(container.getPlayer(), String.valueOf(false))));
        } else {
            container.m_142416_(this.valueField);
            container.m_142416_(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.perform"), () -> this.setGameRule(container.getPlayer(), this.value)));
        }
    }

    private void setGameRule(String player, String value) {
        GameRuleCommandBuilder builder = new GameRuleCommandBuilder();
        builder.rule().set(this.builderGamerule.rule().get());
        builder.value().set(value);
        CommandHelper.sendCommand(player, builder, (Object)GameRuleCommandBuilder.Label.GAMERULE_VALUE);
    }

    @Override
    public Category getCategory() {
        return Categories.WORLD;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.world.gamerules");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.world.gamerules");
    }

    @Override
    public Content getActiveContent() {
        return Contents.GAMERULES;
    }
}

