/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.builder.argument.PrimitiveArgument;
import exopandora.worldhandler.builder.argument.tag.SidedSignTextTag;
import exopandora.worldhandler.builder.impl.DataCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.event.KeyHandler;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiHintTextField;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicColorMenu;
import exopandora.worldhandler.gui.widget.menu.impl.MenuColorField;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class ContentSignEditor
extends Content {
    private final DataCommandBuilder builderSignEditor = new DataCommandBuilder();
    private final SidedSignTextTag texts = new SidedSignTextTag();
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderSignEditor, (Object)DataCommandBuilder.Label.MERGE_BLOCK);
    private GuiHintTextField commandField;
    private int selectedLine;
    private boolean editColor;
    private boolean isActive;

    public ContentSignEditor() {
        this.builderSignEditor.linkage().set(PrimitiveArgument.Linkage.MERGE);
        this.builderSignEditor.nbt().addTagProvider(this.texts);
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.isActive ? this.preview : null;
    }

    @Override
    public void init(Container container) {
        BlockEntity entity;
        Minecraft minecraft = Minecraft.m_91087_();
        BlockPos pos = BlockHelper.getFocusedBlockPos();
        this.isActive = BlockHelper.getFocusedBlock() instanceof SignBlock;
        this.builderSignEditor.targetPos().set(pos);
        if (this.isActive && minecraft.f_91073_ != null && (entity = minecraft.f_91073_.m_7702_(pos)) instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)entity;
            this.texts.setIsFront(sign.m_277202_((Player)minecraft.f_91074_));
        }
    }

    @Override
    public void initGui(Container container, int x, int y) {
        if (this.isActive) {
            this.commandField = new GuiHintTextField(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.sign_editor.commmand"));
            this.commandField.m_94153_((Predicate)Predicates.notNull());
            this.commandField.m_94144_(this.texts.getLine(this.selectedLine).getCommand());
            this.commandField.m_94201_(false);
            this.commandField.m_94151_(text -> {
                this.texts.getLine(this.selectedLine).setCommand((String)text);
                container.initButtons();
            });
            MenuColorField colors = new MenuColorField(x, y, "gui.worldhandler.blocks.sign_editor.text_line_" + (this.selectedLine + 1), this.texts.getLine(this.selectedLine), new ILogicColorMenu(){

                @Override
                public boolean validate(String text) {
                    return Minecraft.m_91087_().f_91062_.m_92895_(text) <= 90;
                }

                @Override
                public boolean doDrawButtons() {
                    return ContentSignEditor.this.editColor;
                }

                @Override
                public String getId() {
                    return "color" + ContentSignEditor.this.selectedLine;
                }
            });
            container.addMenu(colors);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.isActive) {
            GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.sign_editor.text_line_1"), () -> {
                this.selectedLine = 0;
                container.m_7856_();
            });
            container.m_142416_(button1);
            GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.sign_editor.text_line_2"), () -> {
                this.selectedLine = 1;
                container.m_7856_();
            });
            container.m_142416_(button2);
            GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.sign_editor.text_line_3"), () -> {
                this.selectedLine = 2;
                container.m_7856_();
            });
            container.m_142416_(button3);
            GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.sign_editor.text_line_4"), () -> {
                this.selectedLine = 3;
                container.m_7856_();
            });
            container.m_142416_(button4);
            if (this.editColor) {
                container.m_142416_(new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.done"), () -> this.toggleEditColor(container)));
            } else {
                container.m_142416_(this.commandField);
                container.m_142416_(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.sign_editor.format_text_line"), () -> this.toggleEditColor(container)));
                container.m_142416_(new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.place_command_block"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderSignEditor, (Object)DataCommandBuilder.Label.MERGE_BLOCK, this.texts.isStyled())));
            }
            button1.f_93623_ = this.selectedLine != 0;
            button2.f_93623_ = this.selectedLine != 1;
            button3.f_93623_ = this.selectedLine != 2;
            button4.f_93623_ = this.selectedLine != 3;
        }
    }

    private void toggleEditColor(Container container) {
        this.editColor = !this.editColor;
        container.m_7856_();
    }

    @Override
    public void drawScreen(GuiGraphics guiGraphics, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive) {
            if (!this.editColor) {
                this.commandField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            }
        } else {
            float scale = 4.0f;
            PoseStack posestack = guiGraphics.m_280168_();
            posestack.m_85836_();
            posestack.m_252880_((float)(container.f_96543_ / 2) - 8.5f * scale, (float)(container.f_96544_ / 2 - 15) - 8.5f * scale, 0.0f);
            posestack.m_85841_(scale, scale, scale);
            guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42438_), 0, 0);
            posestack.m_85849_();
            MutableComponent text = Component.m_237110_((String)"gui.worldhandler.blocks.sign_editor.look_at_sign", (Object[])new Object[]{KeyHandler.KEY_WORLD_HANDLER.m_90863_()});
            Font font = Minecraft.m_91087_().f_91062_;
            guiGraphics.m_280614_(font, (Component)text, x + 116 - font.m_92852_((FormattedText)text) / 2, y + 70, Config.getSkin().getLabelColor(), false);
        }
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.blocks.sign_editor");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.blocks.sign_editor");
    }

    @Override
    public Content getActiveContent() {
        return Contents.SIGN_EDITOR;
    }
}

