/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.util.ResourceHelper;
import exopandora.worldhandler.util.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class RenderUtils {
    public static final double EPS = (double)0.002f;

    public static void drawWatchIntoGui(GuiGraphics guiGraphics, int width, int height, long worldTicks, boolean smooth) {
        float hour = TextUtils.toHour(worldTicks);
        float minute = TextUtils.toMinute(worldTicks);
        if (smooth) {
            hour = (float)(worldTicks + 6000L) / 1000.0f;
            minute = (float)(((double)((float)worldTicks + 6000.0f) - Math.floor(hour) * 1000.0) * 6.0 / 100.0);
        }
        float rotationHour = 30.0f * (hour >= 12.0f ? hour - 12.0f : hour) - 180.0f;
        float rotationMinute = 6.0f * minute - 180.0f;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(width + 5), (float)(height + 5), 0.0f);
        poseStack.m_85841_(0.25f, 0.25f, 0.25f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotationHour));
        guiGraphics.m_280509_(-1, -1, 1, 11, -13092808);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(rotationHour));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotationMinute));
        guiGraphics.m_280509_(-1, -1, 1, 15, -9474193);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(rotationMinute));
        poseStack.m_85849_();
        RenderUtils.colorDefaultButton(guiGraphics);
        guiGraphics.m_280218_(ResourceHelper.iconTexture(), width + 0, height, 48, 0, 10, 10);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        guiGraphics.m_280509_((width + 5) * 2 - 1, (height + 4) * 2 + 1, (width + 6) * 2 - 1, (height + 5) * 2 + 1, -16777216);
        poseStack.m_85849_();
    }

    public static void colorDefaultButton(GuiGraphics guiGraphics) {
        float r = Config.getSkin().getButtonRed();
        float g = Config.getSkin().getButtonGreen();
        float b = Config.getSkin().getButtonBlue();
        float a = Config.getSkin().getButtonAlpha();
        guiGraphics.m_280246_(r, g, b, a);
    }

    public static void colorDefaultBackground(GuiGraphics guiGraphics) {
        RenderUtils.colorDefaultBackground(guiGraphics, 1.0);
    }

    public static void colorDefaultBackground(GuiGraphics guiGraphics, double alpha) {
        float r = Config.getSkin().getBackgroundRed();
        float g = Config.getSkin().getBackgroundGreen();
        float b = Config.getSkin().getBackgroundBlue();
        float a = (float)alpha * Config.getSkin().getBackgroundAlpha();
        guiGraphics.m_280246_(r, g, b, a);
    }

    public static void colorDarkBackground(GuiGraphics guiGraphics) {
        float r = Config.getSkin().getBackgroundRed();
        float g = Config.getSkin().getBackgroundGreen();
        float b = Config.getSkin().getBackgroundBlue();
        float a = Config.getSkin().getBackgroundAlpha();
        guiGraphics.m_280246_(Math.max(0.0f, r - 0.3f), Math.max(0.0f, g - 0.3f), Math.max(0.0f, b - 0.3f), a);
    }

    public static void resetColor(GuiGraphics guiGraphics) {
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawTexturedTriangleBL(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            guiGraphics.m_280218_(texture, x, y + i, textureX, textureY + i, i + 1, 1);
        }
    }

    public static void drawTexturedTriangleBR(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            guiGraphics.m_280218_(texture, x + size - i - 1, y + i, textureX + size - i - 1, textureY + i, i + 1, 1);
        }
    }

    public static void drawTexturedTriangleTL(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            guiGraphics.m_280218_(texture, x, y + i, textureX, textureY, size - i, 1);
        }
    }

    public static void drawTexturedTriangleTR(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            guiGraphics.m_280218_(texture, x + i, y + i, textureX + i, textureY, size - i, 1);
        }
    }

    public static void drawTexturedWedgeGradientTR(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int textureX, int textureY, int width, int height) {
        RenderSystem.enableBlend();
        for (int i = 0; i < height; ++i) {
            double w = (double)(height - i) / (double)(height + 1);
            int z = width - (int)(w * (double)width);
            RenderUtils.colorDefaultBackground(guiGraphics, w);
            guiGraphics.m_280218_(texture, x + z, y + i, textureX + z, textureY + i, width - z, 1);
        }
        RenderSystem.disableBlend();
    }

    public static void drawTexturedWedgeGradientTL(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int textureX, int textureY, int width, int height) {
        RenderSystem.enableBlend();
        for (int i = 0; i < height; ++i) {
            double w = (double)(height - i) / (double)(height + 1);
            int z = (int)(w * (double)width);
            RenderUtils.colorDefaultBackground(guiGraphics, w);
            guiGraphics.m_280218_(texture, x, y + i, textureX, textureY + i, z, 1);
        }
        RenderSystem.disableBlend();
    }
}

