/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor;

import com.google.common.collect.Lists;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="zillagersweararmor", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IWAConfig {
    public static final ModConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    public static float Wave1Chances;
    public static float Wave2Chances;
    public static float Wave3Chances;
    public static float Wave4Chances;
    public static float Wave5Chances;
    public static float Wave6Chances;
    public static float Wave7Chances;
    public static float Wave8Chances;
    public static float EnchanterHelmetHeight;
    public static List<String> ArmorBlackList;
    public static boolean IllagerArmor;
    public static boolean crossArms;

    public static void bakeCommonConfig() {
        Wave1Chances = ((Double)IWAConfig.COMMON.Wave1.get()).floatValue();
        Wave2Chances = ((Double)IWAConfig.COMMON.Wave2.get()).floatValue();
        Wave3Chances = ((Double)IWAConfig.COMMON.Wave3.get()).floatValue();
        Wave4Chances = ((Double)IWAConfig.COMMON.Wave4.get()).floatValue();
        Wave5Chances = ((Double)IWAConfig.COMMON.Wave5.get()).floatValue();
        Wave6Chances = ((Double)IWAConfig.COMMON.Wave6.get()).floatValue();
        Wave7Chances = ((Double)IWAConfig.COMMON.Wave7.get()).floatValue();
        Wave8Chances = ((Double)IWAConfig.COMMON.Wave8.get()).floatValue();
        ArmorBlackList = (List)IWAConfig.COMMON.ArmorBlackList.get();
        IllagerArmor = (Boolean)IWAConfig.COMMON.IllagerArmor.get();
    }

    public static void bakeClientConfig() {
        EnchanterHelmetHeight = ((Double)IWAConfig.CLIENT.EnchanterHelmetHeight.get()).floatValue();
        crossArms = (Boolean)IWAConfig.CLIENT.IllagerCrossArms.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            IWAConfig.bakeCommonConfig();
        }
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            IWAConfig.bakeClientConfig();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        specPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)specPair.getLeft();
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
    }

    public static class CommonConfig {
        public final ModConfigSpec.DoubleValue Wave1;
        public final ModConfigSpec.DoubleValue Wave2;
        public final ModConfigSpec.DoubleValue Wave3;
        public final ModConfigSpec.DoubleValue Wave4;
        public final ModConfigSpec.DoubleValue Wave5;
        public final ModConfigSpec.DoubleValue Wave6;
        public final ModConfigSpec.DoubleValue Wave7;
        public final ModConfigSpec.DoubleValue Wave8;
        public final ModConfigSpec.BooleanValue IllagerArmor;
        public final ModConfigSpec.ConfigValue<List<String>> ArmorBlackList;

        public CommonConfig(ModConfigSpec.Builder builder) {
            this.Wave1 = builder.translation("zillagersweararmor.config.wave1").defineInRange("Wave 1 Armor Chances", (double)0.3f, (double)1.0E-4f, 100.0);
            this.Wave2 = builder.translation("zillagersweararmor.config.wave2").defineInRange("Wave 2 Armor Chances", (double)0.32f, (double)1.0E-4f, 100.0);
            this.Wave3 = builder.translation("zillagersweararmor.config.wave3").defineInRange("Wave 3 Armor Chances", (double)0.34f, (double)1.0E-4f, 100.0);
            this.Wave4 = builder.translation("zillagersweararmor.config.wave4").defineInRange("Wave 4 Armor Chances", (double)0.36f, (double)1.0E-4f, 100.0);
            this.Wave5 = builder.translation("zillagersweararmor.config.wave5").defineInRange("Wave 5 Armor Chances", (double)0.38f, (double)1.0E-4f, 100.0);
            this.Wave6 = builder.translation("zillagersweararmor.config.wave6").defineInRange("Wave 6 Armor Chances", (double)0.4f, (double)1.0E-4f, 100.0);
            this.Wave7 = builder.translation("zillagersweararmor.config.wave7").defineInRange("Wave 7 Armor Chances", (double)0.42f, (double)1.0E-4f, 100.0);
            this.Wave8 = builder.translation("zillagersweararmor.config.wave8").defineInRange("Wave 8 Armor Chances", (double)0.48f, (double)1.0E-4f, 100.0);
            this.ArmorBlackList = builder.translation("zillagersweararmor.config.blacklist").comment("This will make sure any entity id in this list wont spawn with armor. Example outputs would be \"minecraft:vex\" and \"minecraft:vex\",\"minecraft:witch\"").define("Illager Armor BlackList", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:vex"}));
            this.IllagerArmor = builder.translation("zillagersweararmor.config.illagerArmor").define("Have Illagers spawn with armor at all?", true);
        }
    }

    public static class ClientConfig {
        public final ModConfigSpec.BooleanValue IllagerCrossArms;
        public final ModConfigSpec.DoubleValue EnchanterHelmetHeight;
        public final ModConfigSpec.BooleanValue pillagerRenderer;

        public ClientConfig(ModConfigSpec.Builder builder) {
            this.IllagerCrossArms = builder.translation("zillagersweararmor.config.illagerCrossArms").define("Have Illagers cross their arms when neutral?", true);
            this.EnchanterHelmetHeight = builder.translation("zillagersweararmor.config.height").defineInRange("Height of the Enchanters helmet", -15.0, -500.0, 100.0);
            this.pillagerRenderer = builder.define("Allow new pillager renderer", true);
        }
    }
}

