/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import tallestegg.illagersweararmor.IWAConfig;
import tallestegg.illagersweararmor.IWAHelper;
import tallestegg.illagersweararmor.loot_tables.IWALootTables;

public class IWASpawnEvents {
    private static final Map<EquipmentSlot, ResourceLocation> VEX_NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS = (Map)Util.make((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlot.HEAD, IWALootTables.VEX_HELMET);
        slotItems.put(EquipmentSlot.CHEST, IWALootTables.VEX_CHEST);
        slotItems.put(EquipmentSlot.LEGS, IWALootTables.VEX_LEGGINGS);
        slotItems.put(EquipmentSlot.FEET, IWALootTables.VEX_FEET);
    });
    private static final Map<EquipmentSlot, ResourceLocation> EQUIPMENT_SLOT_ITEMS = (Map)Util.make((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlot.HEAD, IWALootTables.ILLAGER_HELMET);
        slotItems.put(EquipmentSlot.CHEST, IWALootTables.ILLAGER_CHEST);
        slotItems.put(EquipmentSlot.LEGS, IWALootTables.ILLAGER_LEGGINGS);
        slotItems.put(EquipmentSlot.FEET, IWALootTables.ILLAGER_FEET);
    });
    private static final Map<EquipmentSlot, ResourceLocation> NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS = (Map)Util.make((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlot.HEAD, IWALootTables.NATURAL_SPAWN_ILLAGER_HELMET);
        slotItems.put(EquipmentSlot.CHEST, IWALootTables.NATURAL_SPAWN_ILLAGER_CHEST);
        slotItems.put(EquipmentSlot.LEGS, IWALootTables.NATURAL_SPAWN_ILLAGER_LEGGINGS);
        slotItems.put(EquipmentSlot.FEET, IWALootTables.NATURAL_SPAWN_ILLAGER_FEET);
    });

    @SubscribeEvent
    public static void finalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        MobSpawnType spawnType = event.getSpawnType();
        Mob entity = event.getEntity();
        if (!IWAConfig.ArmorBlackList.contains(entity.getEncodeId())) {
            Mob mob;
            if (entity instanceof Raider) {
                Raider raider = (Raider)entity;
                if ((entity instanceof AbstractIllager || entity instanceof Witch) && IWAConfig.IllagerArmor) {
                    if (raider.getCurrentRaid() != null && spawnType == MobSpawnType.EVENT) {
                        raider.getTags().add("raidArmorSpawn");
                    } else {
                        raider.getTags().add("naturalArmorSpawn");
                    }
                }
            }
            if ((mob = event.getEntity()) instanceof Vex) {
                Vex vex = (Vex)mob;
                vex.getTags().add("naturalArmorSpawn");
            }
        }
    }

    @SubscribeEvent
    public static void tickEntity(LivingEvent.LivingTickEvent event) {
        Vex vex;
        RandomSource rSource = event.getEntity().level().getRandom();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Raider) {
            Raider raider = (Raider)livingEntity;
            if (raider.getTags().contains("raidArmorSpawn")) {
                IWASpawnEvents.giveArmorOnRaids(raider, raider.getRandom());
                raider.getTags().remove("raidArmorSpawn");
            } else if (raider.getTags().contains("naturalArmorSpawn")) {
                IWASpawnEvents.giveArmorNaturally(raider, rSource);
                raider.getTags().remove("naturalArmorSpawn");
            }
        }
        if ((livingEntity = event.getEntity()) instanceof Vex && (vex = (Vex)livingEntity).getTags().contains("naturalArmorSpawn")) {
            IWASpawnEvents.giveArmorNaturally(vex, rSource, vex.level().getCurrentDifficultyAt(vex.blockPosition()));
            vex.getTags().remove("naturalArmorSpawn");
        }
    }

    public static void giveArmorOnRaids(Raider raider, RandomSource pRandom) {
        float difficultyChance = raider.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f;
        int illagerWaves = raider.getCurrentRaid().getGroupsSpawned();
        float waveChances = IWAHelper.getWaveArmorChances(illagerWaves);
        if (pRandom.nextFloat() < waveChances) {
            boolean flag = true;
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                if (!flag && pRandom.nextFloat() < difficultyChance) break;
                flag = false;
                if (IWASpawnEvents.getItemsFromLootTable(raider, equipmentslottype) == null) continue;
                for (ItemStack stack : IWASpawnEvents.getItemsFromLootTable(raider, equipmentslottype)) {
                    raider.setItemSlot(equipmentslottype, stack);
                }
            }
        }
    }

    public static List<ItemStack> getItemsFromLootTable(Raider raider, EquipmentSlot slot) {
        if (EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            LootTable loot = raider.level().getServer().getLootData().getLootTable(EQUIPMENT_SLOT_ITEMS.get(slot));
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)raider.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)raider);
            return loot.getRandomItems(lootcontext$builder.create(IWALootTables.SLOT));
        }
        return null;
    }

    public static List<ItemStack> getNaturalSpawnItemsFromLootTable(Raider raider, EquipmentSlot slot) {
        if (NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            LootTable loot = raider.level().getServer().getLootData().getLootTable(NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.get(slot));
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)raider.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)raider);
            return loot.getRandomItems(lootcontext$builder.create(IWALootTables.SLOT));
        }
        return null;
    }

    public static List<ItemStack> getVexNaturalSpawnItemsFromLootTable(Vex vex, EquipmentSlot slot) {
        if (NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            LootTable loot = vex.level().getServer().getLootData().getLootTable(VEX_NATURAL_SPAWN_EQUIPMENT_SLOT_ITEMS.get(slot));
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)vex.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)vex);
            return loot.getRandomItems(lootcontext$builder.create(IWALootTables.SLOT));
        }
        return null;
    }

    public static void giveArmorNaturally(Raider raider, RandomSource random) {
        float difficultyChance = raider.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f;
        boolean flag = true;
        for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
            if (equipmentslottype.getType() != EquipmentSlot.Type.ARMOR) continue;
            if (!flag && random.nextFloat() < difficultyChance) break;
            flag = false;
            for (ItemStack stack : IWASpawnEvents.getNaturalSpawnItemsFromLootTable(raider, equipmentslottype)) {
                raider.setItemSlot(equipmentslottype, stack);
            }
        }
    }

    public static void giveArmorNaturally(Vex vex, RandomSource random, DifficultyInstance instance) {
        float difficultyChance = vex.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f;
        boolean flag = true;
        for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
            if (equipmentslottype.getType() != EquipmentSlot.Type.ARMOR) continue;
            if (!flag && random.nextFloat() < difficultyChance) break;
            flag = false;
            for (ItemStack stack : IWASpawnEvents.getVexNaturalSpawnItemsFromLootTable(vex, equipmentslottype)) {
                vex.setItemSlot(equipmentslottype, stack);
            }
        }
    }
}

