/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ArmorItem;
import tallestegg.illagersweararmor.IWAConfig;

public class IllagerBipedModel<T extends AbstractIllager>
extends HumanoidModel<T> {
    public ModelPart nose;
    public ModelPart jacket;
    public ModelPart arms;

    public IllagerBipedModel(ModelPart part) {
        super(part);
        this.nose = this.head.getChild("nose");
        this.jacket = this.body.getChild("jacket");
        this.arms = part.getChild("arms");
        this.hat.visible = false;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition1.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.45f)), PartPose.ZERO);
        partdefinition1.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat((Iterable)super.bodyParts(), (Iterable)ImmutableList.of((Object)this.arms, (Object)this.jacket));
    }

    public void setupAnim(T p_102928_, float p_102929_, float p_102930_, float p_102931_, float p_102932_, float p_102933_) {
        boolean flag;
        super.setupAnim(p_102928_, p_102929_, p_102930_, p_102931_, p_102932_, p_102933_);
        AbstractIllager.IllagerArmPose armpose = p_102928_.getArmPose();
        this.jacket.copyFrom(this.body);
        boolean isWearingChestplateOrLeggings = p_102928_.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ArmorItem || p_102928_.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ArmorItem;
        this.jacket.visible = !isWearingChestplateOrLeggings;
        this.arms.y = 3.0f;
        this.arms.z = -1.0f;
        this.arms.xRot = -0.75f;
        this.arms.visible = flag = armpose == AbstractIllager.IllagerArmPose.CROSSED && IWAConfig.crossArms && !p_102928_.getType().equals(Registries.ENTITY_TYPE.registry().equals((Object)new ResourceLocation("hunterillager:hunterillager")));
        if (flag) {
            this.leftArm.y = 3.0f;
            this.leftArm.z = -1.0f;
            this.leftArm.xRot = -0.75f;
            this.rightArm.y = 3.0f;
            this.rightArm.z = -1.0f;
            this.rightArm.xRot = -0.75f;
        }
        this.leftArm.visible = !flag;
        boolean bl = this.rightArm.visible = !flag;
        if (armpose != null) {
            switch (armpose) {
                case ATTACKING: {
                    if (p_102928_.getMainHandItem().isEmpty()) {
                        AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.attackTime, (float)p_102931_);
                        break;
                    }
                    this.holdWeaponHigh(p_102928_);
                    break;
                }
                case SPELLCASTING: {
                    this.rightArm.z = 0.0f;
                    this.rightArm.x = -5.0f;
                    this.leftArm.z = 0.0f;
                    this.leftArm.x = 5.0f;
                    this.rightArm.xRot = Mth.cos((float)(p_102931_ * 0.6662f)) * 0.25f;
                    this.leftArm.xRot = Mth.cos((float)(p_102931_ * 0.6662f)) * 0.25f;
                    this.rightArm.zRot = 2.3561945f;
                    this.leftArm.zRot = -2.3561945f;
                    this.rightArm.yRot = 0.0f;
                    this.leftArm.yRot = 0.0f;
                    break;
                }
                case CELEBRATING: {
                    this.rightArm.z = 0.0f;
                    this.rightArm.x = -5.0f;
                    this.rightArm.xRot = Mth.cos((float)(p_102931_ * 0.6662f)) * 0.05f;
                    this.rightArm.zRot = 2.670354f;
                    this.rightArm.yRot = 0.0f;
                    this.leftArm.z = 0.0f;
                    this.leftArm.x = 5.0f;
                    this.leftArm.xRot = Mth.cos((float)(p_102931_ * 0.6662f)) * 0.05f;
                    this.leftArm.zRot = -2.3561945f;
                    this.leftArm.yRot = 0.0f;
                    break;
                }
            }
            this.setupAttackAnimation(p_102928_, p_102931_);
        }
    }

    private void holdWeaponHigh(T pMob) {
        if (pMob.isLeftHanded()) {
            this.leftArm.xRot = -1.8f;
        } else {
            this.rightArm.xRot = -1.8f;
        }
    }

    protected void setupAttackAnimation(T pLivingEntity, float pAgeInTicks) {
        if (this.attackTime > 0.0f && pLivingEntity.getArmPose() == AbstractIllager.IllagerArmPose.ATTACKING) {
            AnimationUtils.swingWeaponDown((ModelPart)this.rightArm, (ModelPart)this.leftArm, pLivingEntity, (float)this.attackTime, (float)pAgeInTicks);
        } else {
            super.setupAttackAnimation(pLivingEntity, pAgeInTicks);
        }
    }
}

