/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.item.ArmorItem;

public class WitchBipedModel<T extends Witch>
extends HumanoidModel<T> {
    public final ModelPart nose;
    public final ModelPart arms;
    public final ModelPart jacket;
    public final ModelPart witchHat;
    private boolean holdingItem;

    public WitchBipedModel(ModelPart pRoot) {
        super(pRoot);
        this.leftArm.visible = false;
        this.rightArm.visible = false;
        this.nose = this.head.getChild("nose");
        this.arms = pRoot.getChild("arms");
        this.jacket = this.body.getChild("jacket");
        this.witchHat = this.head.getChild("witchHat");
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.ZERO);
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("witchHat", CubeListBuilder.create().texOffs(0, 64).addBox(0.0f, 0.0f, 0.0f, 10.0f, 2.0f, 10.0f), PartPose.offset((float)-5.0f, (float)-10.03125f, (float)-5.0f));
        PartDefinition partdefinition3 = partdefinition2.addOrReplaceChild("hat2", CubeListBuilder.create().texOffs(0, 76).addBox(0.0f, 0.0f, 0.0f, 7.0f, 4.0f, 7.0f), PartPose.offsetAndRotation((float)1.75f, (float)-4.0f, (float)2.0f, (float)-0.05235988f, (float)0.0f, (float)0.02617994f));
        PartDefinition partdefinition4 = partdefinition3.addOrReplaceChild("hat3", CubeListBuilder.create().texOffs(0, 87).addBox(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)1.75f, (float)-4.0f, (float)2.0f, (float)-0.10471976f, (float)0.0f, (float)0.05235988f));
        partdefinition4.addOrReplaceChild("hat4", CubeListBuilder.create().texOffs(0, 95).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)1.75f, (float)-2.0f, (float)2.0f, (float)-0.20943952f, (float)0.0f, (float)0.10471976f));
        partdefinition2.addOrReplaceChild("hat_rim", CubeListBuilder.create().texOffs(30, 47).addBox(-8.0f, -8.0f, -6.0f, 16.0f, 16.0f, 1.0f), PartPose.rotation((float)-1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition1.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f), PartPose.ZERO);
        body.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).texOffs(44, 22).addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, true).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition partdefinition5 = partdefinition1.getChild("nose");
        partdefinition5.addOrReplaceChild("mole", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 3.0f, -6.75f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat((Iterable)super.bodyParts(), (Iterable)ImmutableList.of((Object)this.arms, (Object)this.body));
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.nose.setPos(0.0f, -2.0f, 0.0f);
        float f = 0.01f * (float)(pEntity.getId() % 10);
        this.nose.xRot = Mth.sin((float)((float)((Witch)pEntity).tickCount * f)) * 4.5f * ((float)Math.PI / 180);
        this.nose.yRot = 0.0f;
        this.nose.zRot = Mth.cos((float)((float)((Witch)pEntity).tickCount * f)) * 2.5f * ((float)Math.PI / 180);
        if (this.holdingItem) {
            this.nose.setPos(0.0f, 1.0f, -1.5f);
            this.nose.xRot = -0.9f;
        }
        super.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        this.leftArm.y = 3.0f;
        this.leftArm.z = -1.0f;
        this.leftArm.xRot = -0.75f;
        this.rightArm.y = 3.0f;
        this.rightArm.z = -1.0f;
        this.rightArm.xRot = -0.75f;
        boolean isWearingChestplateOrLeggings = pEntity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ArmorItem || pEntity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ArmorItem;
        boolean bl = this.jacket.visible = !isWearingChestplateOrLeggings;
        if (pEntity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem) {
            this.witchHat.y = -13.0f;
        } else {
            this.witchHat.resetPose();
        }
    }

    public void setHoldingItem(boolean pHoldingItem) {
        this.holdingItem = pHoldingItem;
    }
}

