/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import tallestegg.illagersweararmor.IWAClientEvents;
import tallestegg.illagersweararmor.client.model.IllagerArmorModel;
import tallestegg.illagersweararmor.client.model.IllagerBipedModel;

public abstract class IllagerBipedRenderer<T extends AbstractIllager>
extends MobRenderer<T, IllagerBipedModel<T>> {
    public IllagerBipedRenderer(EntityRendererProvider.Context builder) {
        super(builder, new IllagerBipedModel(builder.bakeLayer(IWAClientEvents.BIPEDILLAGER)), 0.5f);
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, builder.getModelSet(), builder.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, builder.getModelSet()));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new IllagerArmorModel(builder.bakeLayer(IWAClientEvents.BIPEDILLAGER_ARMOR_INNER_LAYER)), new IllagerArmorModel(builder.bakeLayer(IWAClientEvents.BIPEDILLAGER_ARMOR_OUTER_LAYER)), builder.getModelManager()));
    }

    protected void scale(T p_114919_, PoseStack p_114920_, float p_114921_) {
        p_114920_.scale(0.9375f, 0.9375f, 0.9375f);
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.setModelVisibilities(entityIn);
        super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void setModelVisibilities(T entityIn) {
        IllagerBipedModel illagerModel = (IllagerBipedModel)this.getModel();
        ItemStack itemstack = entityIn.getMainHandItem();
        ItemStack itemstack1 = entityIn.getOffhandItem();
        HumanoidModel.ArmPose bipedmodel$armpose = this.getArmPose(entityIn, itemstack, itemstack1, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose bipedmodel$armpose1 = this.getArmPose(entityIn, itemstack, itemstack1, InteractionHand.OFF_HAND);
        if (entityIn.getArmPose() != AbstractIllager.IllagerArmPose.CROSSED) {
            if (entityIn.getMainArm() == HumanoidArm.RIGHT) {
                illagerModel.rightArmPose = bipedmodel$armpose;
                illagerModel.leftArmPose = bipedmodel$armpose1;
            } else {
                illagerModel.rightArmPose = bipedmodel$armpose1;
                illagerModel.leftArmPose = bipedmodel$armpose;
            }
        }
    }

    protected HumanoidModel.ArmPose getArmPose(T entityIn, ItemStack itemStackMain, ItemStack itemStackOff, InteractionHand handIn) {
        ItemStack itemstack;
        HumanoidModel.ArmPose bipedmodel$armpose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemStack = itemstack = handIn == InteractionHand.MAIN_HAND ? itemStackMain : itemStackOff;
        if (!itemstack.isEmpty()) {
            bipedmodel$armpose = HumanoidModel.ArmPose.ITEM;
            UseAnim useaction = itemstack.getUseAnimation();
            switch (useaction) {
                case BLOCK: {
                    bipedmodel$armpose = HumanoidModel.ArmPose.BLOCK;
                    break;
                }
                case BOW: {
                    bipedmodel$armpose = HumanoidModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case SPEAR: {
                    bipedmodel$armpose = HumanoidModel.ArmPose.THROW_SPEAR;
                    break;
                }
                case CROSSBOW: {
                    if (handIn != entityIn.getUsedItemHand() || entityIn.getUseItemRemainingTicks() <= 0) break;
                    bipedmodel$armpose = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    break;
                }
                case SPYGLASS: {
                    if (entityIn.getUseItemRemainingTicks() <= 0) break;
                    bipedmodel$armpose = HumanoidModel.ArmPose.SPYGLASS;
                    break;
                }
                default: {
                    bipedmodel$armpose = HumanoidModel.ArmPose.EMPTY;
                }
            }
        }
        if (!((AbstractIllager)entityIn).swinging && itemstack.getItem() instanceof CrossbowItem && !entityIn.isUsingItem()) {
            bipedmodel$armpose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return bipedmodel$armpose;
    }
}

