/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.client.renderer.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.VexModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ClientHooks;

public class VexArmorLayer
extends RenderLayer<Vex, VexModel> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final HumanoidModel innerModel;
    private final HumanoidModel outerModel;

    public VexArmorLayer(RenderLayerParent<Vex, VexModel> pRenderer, EntityModelSet modelSets) {
        super(pRenderer);
        this.innerModel = new HumanoidModel(modelSets.bakeLayer(ModelLayers.ARMOR_STAND_INNER_ARMOR));
        this.outerModel = new HumanoidModel(modelSets.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
    }

    public void copyPropertiesTo(HumanoidModel pModel) {
        pModel.head.copyFrom(((VexModel)this.getParentModel()).root().getChild("head"));
        pModel.body.copyFrom(((VexModel)this.getParentModel()).root().getChild("body"));
        pModel.rightArm.copyFrom(((VexModel)this.getParentModel()).root().getChild("body").getChild("right_arm"));
        pModel.leftArm.copyFrom(((VexModel)this.getParentModel()).root().getChild("body").getChild("left_arm"));
        pModel.rightLeg.copyFrom(((VexModel)this.getParentModel()).root().getChild("body"));
        pModel.leftLeg.copyFrom(((VexModel)this.getParentModel()).root().getChild("body"));
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, Vex pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.copyPropertiesTo(this.innerModel);
        this.copyPropertiesTo(this.outerModel);
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.CHEST, pPackedLight, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.LEGS, pPackedLight, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.FEET, pPackedLight, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.HEAD, pPackedLight, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack pPoseStack, MultiBufferSource pBuffer, Vex pLivingEntity, EquipmentSlot pSlot, int p_117123_, HumanoidModel pModel) {
        ItemStack itemstack = pLivingEntity.getItemBySlot(pSlot);
        if (itemstack.getItem() instanceof ArmorItem) {
            ArmorItem armoritem = (ArmorItem)itemstack.getItem();
            if (armoritem.getEquipmentSlot() == pSlot) {
                this.setPartVisibility(pModel, pSlot);
                Model model = this.getArmorModelHook(pLivingEntity, itemstack, pSlot, pModel);
                boolean flag = this.usesInnerModel(pSlot);
                boolean flag1 = itemstack.hasFoil();
                if (armoritem instanceof DyeableLeatherItem) {
                    int i = ((DyeableLeatherItem)armoritem).getColor(itemstack);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderModel(pPoseStack, pBuffer, p_117123_, flag1, model, f, f1, f2, this.getArmorResource((Entity)pLivingEntity, itemstack, pSlot, null));
                    this.renderModel(pPoseStack, pBuffer, p_117123_, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)pLivingEntity, itemstack, pSlot, "overlay"));
                } else {
                    this.renderModel(pPoseStack, pBuffer, p_117123_, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)pLivingEntity, itemstack, pSlot, null));
                }
            }
            if (armoritem.getEquipmentSlot() == EquipmentSlot.CHEST) {
                pPoseStack.pushPose();
                pPoseStack.popPose();
            }
        }
    }

    protected void setPartVisibility(HumanoidModel pModel, EquipmentSlot pSlot) {
        pModel.setAllVisible(false);
        switch (pSlot) {
            case HEAD: {
                pModel.head.visible = true;
                pModel.hat.visible = true;
                pModel.head.xScale = 0.8f;
                pModel.head.yScale = 0.8f;
                pModel.head.zScale = 0.8f;
                pModel.head.y -= 13.0f;
                break;
            }
            case CHEST: {
                pModel.body.visible = true;
                pModel.rightArm.visible = true;
                pModel.leftArm.visible = true;
                pModel.rightArm.y -= -11.5f;
                pModel.rightArm.z += 0.25f;
                pModel.rightArm.x -= 3.0f;
                pModel.rightArm.xScale = 0.8f;
                pModel.rightArm.yScale = 0.8f;
                pModel.rightArm.zScale = 0.8f;
                pModel.leftArm.xScale = 0.8f;
                pModel.leftArm.yScale = 0.8f;
                pModel.leftArm.zScale = 0.8f;
                pModel.leftArm.y -= -11.5f;
                pModel.leftArm.z += 0.25f;
                pModel.leftArm.x -= -3.0f;
                pModel.body.xScale = 0.8f;
                pModel.body.yScale = 0.8f;
                pModel.body.zScale = 0.8f;
                pModel.body.y -= 9.0f;
                break;
            }
            case LEGS: {
                pModel.body.visible = true;
                pModel.rightLeg.visible = true;
                pModel.leftLeg.visible = true;
                pModel.body.y -= 6.0f;
                pModel.body.z -= -0.6f;
                pModel.body.xScale = 0.6f;
                pModel.body.yScale = 0.6f;
                pModel.body.zScale = 0.75f;
                pModel.rightLeg.xScale = 0.6f;
                pModel.rightLeg.yScale = 0.6f;
                pModel.rightLeg.zScale = 0.7f;
                pModel.rightLeg.y = 20.0f;
                pModel.rightLeg.x = -1.5f;
                pModel.rightLeg.z = 1.5f;
                pModel.leftLeg.xScale = 0.6f;
                pModel.leftLeg.yScale = 0.6f;
                pModel.leftLeg.zScale = 0.7f;
                pModel.leftLeg.y = 20.0f;
                pModel.leftLeg.x = 1.5f;
                pModel.leftLeg.z = 1.5f;
                break;
            }
            case FEET: {
                pModel.rightLeg.visible = true;
                pModel.leftLeg.visible = true;
                pModel.rightLeg.y = 20.0f;
                pModel.rightLeg.xScale = 0.6f;
                pModel.rightLeg.yScale = 0.6f;
                pModel.rightLeg.zScale = 0.7f;
                pModel.rightLeg.x = -1.5f;
                pModel.rightLeg.z = 1.5f;
                pModel.leftLeg.xScale = 0.6f;
                pModel.leftLeg.yScale = 0.6f;
                pModel.leftLeg.zScale = 0.7f;
                pModel.leftLeg.y = 20.0f;
                pModel.leftLeg.x = 1.5f;
                pModel.leftLeg.z = 1.5f;
            }
        }
    }

    private void renderModel(PoseStack pPoseStack, MultiBufferSource pBuffer, int p_117109_, ArmorItem p_117110_, boolean p_117111_, HumanoidModel pModel, boolean p_117113_, float p_117114_, float p_117115_, float p_117116_, @Nullable String p_117117_) {
        this.renderModel(pPoseStack, pBuffer, p_117109_, p_117111_, (Model)pModel, p_117114_, p_117115_, p_117116_, this.getArmorLocation(p_117110_, p_117113_, p_117117_));
    }

    private void renderModel(PoseStack pPoseStack, MultiBufferSource pBuffer, int p_117109_, boolean p_117111_, Model pModel, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)pBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)armorResource), (boolean)false, (boolean)p_117111_);
        pModel.renderToBuffer(pPoseStack, vertexconsumer, p_117109_, OverlayTexture.NO_OVERLAY, p_117114_, p_117115_, p_117116_, 1.0f);
    }

    private HumanoidModel getArmorModel(EquipmentSlot pSlot) {
        return this.usesInnerModel(pSlot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot pSlot) {
        return pSlot == EquipmentSlot.LEGS;
    }

    @Deprecated
    private ResourceLocation getArmorLocation(ArmorItem p_117081_, boolean p_117082_, @Nullable String p_117083_) {
        String s = "textures/models/armor/" + p_117081_.getMaterial().getName() + "_layer_" + (p_117082_ ? 2 : 1) + (String)(p_117083_ == null ? "" : "_" + p_117083_) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent(s, ResourceLocation::new);
    }

    protected Model getArmorModelHook(Vex entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
        return ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.getItem();
        String texture = item.getMaterial().getName();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

