/*
 * Decompiled with CFR 0.152.
 */
package dlovin.smalls.campchair.common.network;

import dlovin.smalls.campchair.CampChair;
import dlovin.smalls.campchair.common.network.StartRestingPacket;
import dlovin.smalls.campchair.common.network.StopRestingClientPacket;
import dlovin.smalls.campchair.common.network.StopRestingServerPacket;
import dlovin.smalls.campchair.common.network.helper.ISimplePacket;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;

public class CampChairNetwork {
    private static CampChairNetwork instance = null;
    private static final String PROTOCOL_VERSION = "1";
    public final SimpleChannel network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(CampChair.modid, "main"), () -> "1", "1"::equals, "1"::equals);
    int id = 0;

    public static CampChairNetwork getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Attempt to call network getInstance before network is setup");
        }
        return instance;
    }

    public static void setup() {
        if (instance != null) {
            return;
        }
        instance = new CampChairNetwork();
        instance.registerPacket(StopRestingServerPacket.class, StopRestingServerPacket::new, NetworkDirection.PLAY_TO_SERVER);
        instance.registerPacket(StopRestingClientPacket.class, StopRestingClientPacket::new, NetworkDirection.PLAY_TO_CLIENT);
        instance.registerPacket(StartRestingPacket.class, StartRestingPacket::new, NetworkDirection.PLAY_TO_CLIENT);
        CampChair.logger.info("Register Packet Done");
    }

    public <MSG extends ISimplePacket> void registerPacket(Class<MSG> clazz, Function<FriendlyByteBuf, MSG> decoder, @Nullable NetworkDirection direction) {
        this.registerPacket(clazz, ISimplePacket::encode, decoder, ISimplePacket::handle, direction);
    }

    public <MSG> void registerPacket(Class<MSG> clazz, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer, @Nullable NetworkDirection direction) {
        this.network.registerMessage(this.id++, clazz, encoder, decoder, consumer, Optional.ofNullable(direction));
    }

    public void sendToServer(Object msg) {
        this.network.sendToServer(msg);
    }

    public void sendTo(Object msg, Player player) {
        if (player instanceof ServerPlayer) {
            this.sendTo(msg, (ServerPlayer)player);
        }
    }

    public void sendTo(Object msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            this.network.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

