/*
 * Decompiled with CFR 0.152.
 */
package com.stebars.canals;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CanalBlock
extends Block {
    public static final int WATER_MAX_LEVEL = 8;
    public static final int CANAL_LEVEL_MULTIPLIER = 10;
    public static final int CANAL_MAX_LEVEL = 80;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    public static final IntegerProperty LEVEL = BlockStateProperties.field_208132_ag;
    public static final IntegerProperty CANAL_LEVEL = IntegerProperty.func_177719_a((String)"canal_level", (int)0, (int)80);
    private final FlowingFluid FLUID_SOURCE = Fluids.field_204546_a;
    private final FlowingFluid FLUID_FLOWING = Fluids.field_207212_b;
    protected static final VoxelShape X_AXIS_AABB = VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)1.0, (double)1.0), (VoxelShape[])new VoxelShape[]{VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), VoxelShapes.func_197873_a((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.125)});
    protected static final VoxelShape Z_AXIS_AABB = VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197873_a((double)0.875, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (VoxelShape[])new VoxelShape[]{VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), VoxelShapes.func_197873_a((double)0.0, (double)0.125, (double)0.0, (double)0.125, (double)1.0, (double)1.0)});

    public CanalBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(2.0f, 6.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X)).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)CANAL_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{AXIS, LEVEL, CANAL_LEVEL});
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean startWaterlogged = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a(AXIS, (Comparable)this.directionToAxis(context.func_195992_f()))).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(startWaterlogged ? 8 : 0))).func_206870_a((Property)CANAL_LEVEL, (Comparable)Integer.valueOf(startWaterlogged ? 80 : 0));
    }

    public Direction.Axis directionToAxis(Direction dir) {
        switch (dir) {
            case EAST: 
            case WEST: {
                return Direction.Axis.X;
            }
        }
        return Direction.Axis.Z;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        switch ((Direction.Axis)p_220053_1_.func_177229_b(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public FluidState func_204507_t(BlockState state) {
        int level = (Integer)state.func_177229_b((Property)LEVEL);
        if (level == 0) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return this.FLUID_SOURCE.func_207207_a(level, false);
    }

    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return true;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos1, Block block, BlockPos pos2, boolean flag) {
        Direction dir = this.getPositiveDirection(state);
        BlockPos posA = pos1.func_177972_a(dir);
        BlockPos posB = pos1.func_177967_a(dir, -1);
        BlockPos posAbove = pos1.func_177984_a();
        if (!(pos2.equals((Object)posA) || pos2.equals((Object)posB) || pos2.equals((Object)posAbove))) {
            return;
        }
        this.updateState(state, world, pos1, posA, posB, posAbove);
    }

    public boolean updateState(BlockState state, World world, BlockPos pos) {
        Direction dir = this.getPositiveDirection(state);
        return this.updateState(state, world, pos, pos.func_177972_a(dir), pos.func_177967_a(dir, -1), pos.func_177984_a());
    }

    public boolean updateState(BlockState state, World world, BlockPos pos1, BlockPos posA, BlockPos posB, BlockPos posAbove) {
        int newCLevel;
        int newLevel;
        BlockState stateA = world.func_180495_p(posA);
        FluidState fluidA = world.func_204610_c(posA);
        Block blockA = stateA.func_177230_c();
        BlockState stateB = world.func_180495_p(posB);
        FluidState fluidB = world.func_204610_c(posB);
        Block blockB = stateB.func_177230_c();
        FluidState fluidAbove = world.func_204610_c(posAbove);
        Fluid fluidTypeAbove = fluidAbove.func_206886_c();
        if (!(fluidAbove.func_206888_e() || fluidTypeAbove != this.FLUID_SOURCE && fluidTypeAbove != this.FLUID_FLOWING)) {
            newLevel = 8;
            newCLevel = 80;
        } else {
            int cLevelB;
            int cLevelA = this.getCanalLevel(blockA, stateA, fluidA);
            int higherCLevel = cLevelA > (cLevelB = this.getCanalLevel(blockB, stateB, fluidB)) ? cLevelA : cLevelB;
            newCLevel = higherCLevel == 0 ? 0 : higherCLevel - 1;
            newLevel = newCLevel / 10;
        }
        int level = (Integer)state.func_177229_b((Property)LEVEL);
        int canalLevel = (Integer)state.func_177229_b((Property)CANAL_LEVEL);
        if (canalLevel != newCLevel || newLevel != level) {
            state = (BlockState)((BlockState)state.func_206870_a((Property)CANAL_LEVEL, (Comparable)Integer.valueOf(newCLevel))).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(newLevel));
            world.func_180501_a(pos1, state, 3);
            if (blockA.isAir(stateA, (IBlockReader)world, posA)) {
                world.func_205219_F_().func_205360_a(posA, (Object)fluidA.func_206886_c(), this.FLUID_SOURCE.func_205569_a((IWorldReader)world));
            }
            if (blockB.isAir(stateB, (IBlockReader)world, posA)) {
                world.func_205219_F_().func_205360_a(posA, (Object)fluidB.func_206886_c(), this.FLUID_SOURCE.func_205569_a((IWorldReader)world));
            }
            return true;
        }
        return false;
    }

    public int getCanalLevel(Block block, BlockState state, FluidState fluid) {
        if (block instanceof CanalBlock) {
            return (Integer)state.func_177229_b((Property)CANAL_LEVEL);
        }
        if (fluid.func_206888_e()) {
            return 0;
        }
        return fluid.func_206882_g() * 10;
    }

    public boolean isConnectedTo(BlockState state, BlockPos pos1, BlockPos pos2) {
        Direction dir = this.getPositiveDirection((Direction.Axis)state.func_177229_b(AXIS));
        return pos1.func_177972_a(dir) == pos2 || pos1.func_177967_a(dir, -1) == pos2;
    }

    public Direction getPositiveDirection(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return Direction.EAST;
            }
            case Z: {
                return Direction.SOUTH;
            }
        }
        return Direction.UP;
    }

    public Direction getPositiveDirection(BlockState state) {
        return this.getPositiveDirection((Direction.Axis)state.func_177229_b(AXIS));
    }

    public BlockPos otherDirectionTo(BlockPos pos1, BlockPos pos2) {
        BlockPos diff = pos1.func_177973_b((Vector3i)pos2);
        return pos1.func_177982_a(-diff.func_177958_n(), -diff.func_177956_o(), -diff.func_177952_p());
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        this.updateState(state, world, pos);
    }
}

