/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.blamejared.controlling.client.gui.GuiCustomList;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.controls.ControlList;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmlclient.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiFreeKeysList
extends GuiCustomList {
    private final ControlsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;
    List<KeyMapping> keyBindings;

    public GuiFreeKeysList(ControlsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.f_93388_ = controls.f_96543_ + 45;
        this.f_93389_ = controls.f_96544_;
        this.f_93390_ = 43;
        this.f_93391_ = controls.f_96544_ - 80;
        this.f_93392_ = controls.f_96543_ + 45;
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.m_6702_().clear();
        this.allEntries = new ArrayList();
        this.keyBindings = Arrays.stream(this.mc.f_91066_.f_92059_).collect(Collectors.toList());
        this.recalculate();
    }

    public void recalculate() {
        this.m_6702_().clear();
        this.allEntries.clear();
        this.addEntry(new HeaderEntry("Available Keys"));
        InputConstants.Key.f_84857_.values().stream().filter(input -> !input.toString().startsWith("key.keyboard.world")).sorted(Comparator.comparing(o -> o.m_84875_().getString())).forEach(input -> {
            if (this.keyBindings.stream().noneMatch(keyBinding -> keyBinding.getKey().equals(input))) {
                int i = this.mc.f_91062_.m_92895_(input.m_84875_().getString());
                if (i > this.maxListLabelWidth) {
                    this.maxListLabelWidth = i;
                }
                this.addEntry(new InputEntry((InputConstants.Key)input));
            }
        });
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class HeaderEntry
    extends ControlList.Entry {
        private final String text;

        public HeaderEntry(String text) {
            this.text = text;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        public void m_6311_(PoseStack stack, int slotIndex, int y, int x, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
            GuiComponent.m_93215_((PoseStack)stack, (Font)GuiFreeKeysList.this.mc.f_91062_, (Component)new TranslatableComponent("options.availableKeys"), (int)(GuiFreeKeysList.this.mc.f_91080_.f_96543_ / 2 - this.text.length() / 2), (int)(y + p_render_5_ - 9 - 1), (int)0xFFFFFF);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class InputEntry
    extends ControlList.Entry {
        private final InputConstants.Key input;

        public InputEntry(InputConstants.Key input) {
            this.input = input;
        }

        public InputConstants.Key getInput() {
            return this.input;
        }

        public void m_6311_(PoseStack stack, int slotIndex, int y, int x, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
            String str = this.input.toString() + " - " + this.input.m_84873_();
            int length = GuiFreeKeysList.this.mc.f_91062_.m_92895_(this.input.m_84875_().getString());
            GuiFreeKeysList.this.mc.f_91062_.m_92883_(stack, str, (float)x, (float)(y + p_render_5_ / 2 - 4), 0xFFFFFF);
            GuiUtils.drawHoveringText((PoseStack)stack, Collections.singletonList(this.input.m_84875_()), (int)(x + p_render_4_ - length), (int)(y + p_render_5_), (int)GuiFreeKeysList.this.mc.f_91080_.f_96543_, (int)GuiFreeKeysList.this.mc.f_91080_.f_96544_, (int)-1, (Font)GuiFreeKeysList.this.mc.f_91062_);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }
    }
}

