/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.blamejared.controlling.Controlling;
import com.blamejared.controlling.client.gui.DisplayMode;
import com.blamejared.controlling.client.gui.GuiCheckBox;
import com.blamejared.controlling.client.gui.GuiCustomList;
import com.blamejared.controlling.client.gui.GuiFreeKeysList;
import com.blamejared.controlling.client.gui.GuiNewKeyBindingList;
import com.blamejared.controlling.client.gui.SearchType;
import com.blamejared.controlling.client.gui.SortOrder;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.MouseSettingsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.ControlList;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class GuiNewControls
extends ControlsScreen {
    private Button buttonReset;
    private final Screen parentScreen;
    private final Options options;
    private String lastSearch;
    private EditBox search;
    private DisplayMode displayMode;
    private SearchType searchType;
    private SortOrder sortOrder;
    private Button buttonNone;
    private Button buttonConflicting;
    private GuiCheckBox buttonKey;
    private GuiCheckBox buttonCat;
    private Button buttonFree;
    private Button patreonButton;
    private boolean confirmingReset = false;
    private boolean showFree = false;
    private String name;
    private ControlList customKeyList;
    private GuiFreeKeysList freeKeyList;

    public GuiNewControls(Screen screen, Options settings) {
        super(screen, settings);
        this.parentScreen = screen;
        this.options = settings;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, 18, 150, 20, (Component)new TranslatableComponent("options.mouse_settings"), p_213126_1_ -> this.f_96541_.m_91152_((Screen)new MouseSettingsScreen((Screen)this, this.options))));
        this.m_142416_((GuiEventListener)Option.f_91631_.m_7496_(this.f_96541_.f_91066_, this.f_96543_ / 2 - 155 + 160, 18, 150));
        this.customKeyList = new GuiNewKeyBindingList(this, this.f_96541_);
        this.freeKeyList = new GuiFreeKeysList(this, this.f_96541_);
        this.f_97516_ = this.customKeyList;
        this.m_7787_((GuiEventListener)this.f_97516_);
        this.m_7522_((GuiEventListener)this.f_97516_);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160, this.f_96544_ - 29, 150, 20, (Component)new TranslatableComponent("gui.done"), p_213126_1_ -> this.f_96541_.m_91152_(this.parentScreen)));
        this.buttonReset = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ - 29, 74, 20, (Component)new TranslatableComponent("controls.resetAll"), p_213126_1_ -> {
            if (!this.confirmingReset) {
                this.confirmingReset = true;
                p_213126_1_.m_93666_((Component)new TranslatableComponent("options.confirmReset"));
                return;
            }
            this.confirmingReset = false;
            p_213126_1_.m_93666_((Component)new TranslatableComponent("controls.resetAll"));
            for (KeyMapping keybinding : this.f_96541_.f_91066_.f_92059_) {
                keybinding.setToDefault();
            }
            KeyMapping.m_90847_();
        }));
        this.buttonNone = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160 + 76, this.f_96544_ - 29 - 24, 75, 20, (Component)new TranslatableComponent("options.showNone"), p_213126_1_ -> {
            if (this.displayMode == DisplayMode.NONE) {
                this.buttonNone.m_93666_((Component)new TranslatableComponent("options.showNone"));
                this.displayMode = DisplayMode.ALL;
            } else {
                this.displayMode = DisplayMode.NONE;
                this.buttonNone.m_93666_((Component)new TranslatableComponent("options.showAll"));
                this.buttonConflicting.m_93666_((Component)new TranslatableComponent("options.showConflicts"));
            }
            this.filterKeys();
        }));
        this.buttonConflicting = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160, this.f_96544_ - 29 - 24, 75, 20, (Component)new TranslatableComponent("options.showConflicts"), p_213126_1_ -> {
            if (this.displayMode == DisplayMode.CONFLICTING) {
                this.buttonConflicting.m_93666_((Component)new TranslatableComponent("options.showConflicts"));
                this.displayMode = DisplayMode.ALL;
            } else {
                this.displayMode = DisplayMode.CONFLICTING;
                this.buttonConflicting.m_93666_((Component)new TranslatableComponent("options.showAll"));
                this.buttonNone.m_93666_((Component)new TranslatableComponent("options.showNone"));
            }
            this.filterKeys();
        }));
        this.search = new EditBox(this.f_96547_, this.f_96543_ / 2 - 154, this.f_96544_ - 29 - 23, 148, 18, (Component)new TextComponent(""));
        this.m_7787_((GuiEventListener)this.search);
        this.buttonKey = (GuiCheckBox)this.m_142416_((GuiEventListener)new GuiCheckBox(this.f_96543_ / 2 - 77, this.f_96544_ - 29 - 37, new TranslatableComponent("options.key").getString(), false){

            @Override
            public void m_5691_() {
                super.m_5691_();
                GuiNewControls.this.buttonCat.setIsChecked(false);
                GuiNewControls.this.searchType = this.isChecked() ? SearchType.KEY : SearchType.NAME;
                GuiNewControls.this.filterKeys();
            }
        });
        this.buttonCat = (GuiCheckBox)this.m_142416_((GuiEventListener)new GuiCheckBox(this.f_96543_ / 2 - 77, this.f_96544_ - 29 - 50, new TranslatableComponent("options.category").getString(), false){

            @Override
            public void m_5691_() {
                super.m_5691_();
                GuiNewControls.this.buttonKey.setIsChecked(false);
                GuiNewControls.this.searchType = this.isChecked() ? SearchType.CATEGORY : SearchType.NAME;
                GuiNewControls.this.filterKeys();
            }
        });
        this.name = Controlling.PATRON_LIST.stream().skip(Controlling.PATRON_LIST.isEmpty() ? 0L : (long)new Random().nextInt(Controlling.PATRON_LIST.size())).findFirst().orElse("");
        this.patreonButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160, this.f_96544_ - 29 - 24 - 24, 75, 20, (Component)new TextComponent("Patreon"), p_onPress_1_ -> this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(function -> {
            if (function) {
                Util.m_137581_().m_137646_("https://patreon.com/jaredlll08?s=controllingmod");
            }
            this.f_96541_.m_91152_((Screen)this);
        }, "https://patreon.com/jaredlll08?s=controllingmod", true))));
        this.sortOrder = SortOrder.NONE;
        Button buttonSort = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160 + 76, this.f_96544_ - 29 - 24 - 24, 75, 20, (Component)new TranslatableComponent("options.sort").m_130946_(": " + this.sortOrder.getName()), p_213126_1_ -> {
            this.sortOrder = this.sortOrder.cycle();
            p_213126_1_.m_93666_((Component)new TranslatableComponent("options.sort").m_130946_(": " + this.sortOrder.getName()));
            this.filterKeys();
        }));
        this.buttonFree = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 76, this.f_96544_ - 29, 74, 20, (Component)new TranslatableComponent("options.toggleFree"), p_213126_1_ -> {
            this.m_169411_((GuiEventListener)this.f_97516_);
            if (this.showFree) {
                buttonSort.f_93623_ = true;
                this.buttonCat.f_93623_ = true;
                this.buttonKey.f_93623_ = true;
                this.buttonNone.f_93623_ = true;
                this.buttonConflicting.f_93623_ = true;
                this.buttonReset.f_93623_ = true;
                this.f_97516_ = this.customKeyList;
            } else {
                this.freeKeyList.recalculate();
                buttonSort.f_93623_ = false;
                this.buttonCat.f_93623_ = false;
                this.buttonKey.f_93623_ = false;
                this.buttonNone.f_93623_ = false;
                this.buttonConflicting.f_93623_ = false;
                this.buttonReset.f_93623_ = false;
                this.f_97516_ = this.freeKeyList;
            }
            this.m_7787_((GuiEventListener)this.f_97516_);
            this.m_7522_((GuiEventListener)this.f_97516_);
            this.showFree = !this.showFree;
        }));
        this.lastSearch = "";
        this.displayMode = DisplayMode.ALL;
        this.searchType = SearchType.NAME;
    }

    public boolean m_5534_(char var1, int var2) {
        return this.search.m_5534_(var1, var2);
    }

    public void m_96624_() {
        this.search.m_94120_();
        if (!this.lastSearch.equals(this.search.m_94155_())) {
            this.filterKeys();
        }
    }

    public void filterKeys() {
        this.lastSearch = this.search.m_94155_();
        this.f_97516_.m_6702_().clear();
        if (this.f_97516_ instanceof GuiNewKeyBindingList) {
            if (this.lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
                this.f_97516_.m_6702_().addAll(((GuiCustomList)this.f_97516_).getAllEntries());
                return;
            }
            this.f_97516_.m_93410_(0.0);
            Predicate<GuiNewKeyBindingList.KeyEntry> filters = this.displayMode.getPredicate();
            switch (this.searchType) {
                case NAME: {
                    filters = filters.and(keyEntry -> keyEntry.getKeyDesc().toLowerCase().contains(this.lastSearch.toLowerCase()));
                    break;
                }
                case CATEGORY: {
                    filters = filters.and(keyEntry -> new TranslatableComponent(keyEntry.getKeybinding().m_90858_()).getString().toLowerCase().contains(this.lastSearch.toLowerCase()));
                    break;
                }
                case KEY: {
                    filters = filters.and(keyEntry -> keyEntry.getKeybinding().m_90863_().getString().toLowerCase().contains(this.lastSearch.toLowerCase()));
                }
            }
            for (ControlList.Entry entry : ((GuiCustomList)this.f_97516_).getAllEntries()) {
                GuiNewKeyBindingList.KeyEntry keyEntry2;
                if (this.searchType == SearchType.CATEGORY && this.sortOrder == SortOrder.NONE && this.displayMode == DisplayMode.ALL) {
                    if (entry instanceof GuiNewKeyBindingList.KeyEntry) {
                        GuiNewKeyBindingList.KeyEntry keyEntry3 = (GuiNewKeyBindingList.KeyEntry)entry;
                        if (!filters.test(keyEntry3)) continue;
                        this.f_97516_.m_6702_().add(entry);
                        continue;
                    }
                    this.f_97516_.m_6702_().add(entry);
                    continue;
                }
                if (!(entry instanceof GuiNewKeyBindingList.KeyEntry) || !filters.test(keyEntry2 = (GuiNewKeyBindingList.KeyEntry)entry)) continue;
                this.f_97516_.m_6702_().add(entry);
            }
            if (this.searchType == SearchType.CATEGORY && this.sortOrder == SortOrder.NONE && this.displayMode == DisplayMode.ALL) {
                LinkedHashSet<GuiNewKeyBindingList.CategoryEntry> categories = new LinkedHashSet<GuiNewKeyBindingList.CategoryEntry>();
                for (ControlList.Entry entry : this.f_97516_.m_6702_()) {
                    if (!(entry instanceof GuiNewKeyBindingList.CategoryEntry)) continue;
                    GuiNewKeyBindingList.CategoryEntry centry = (GuiNewKeyBindingList.CategoryEntry)entry;
                    categories.add(centry);
                    for (ControlList.Entry child : this.f_97516_.m_6702_()) {
                        GuiNewKeyBindingList.KeyEntry childEntry;
                        if (!(child instanceof GuiNewKeyBindingList.KeyEntry) || !(childEntry = (GuiNewKeyBindingList.KeyEntry)child).getKeybinding().m_90858_().equals(centry.getName())) continue;
                        categories.remove((Object)centry);
                    }
                }
                this.f_97516_.m_6702_().removeAll(categories);
            }
            this.sortOrder.sort(this.f_97516_.m_6702_());
        } else if (this.f_97516_ instanceof GuiFreeKeysList) {
            if (this.lastSearch.isEmpty()) {
                this.f_97516_.m_6702_().addAll(((GuiCustomList)this.f_97516_).getAllEntries());
                return;
            }
            this.f_97516_.m_93410_(0.0);
            for (ControlList.Entry entry : ((GuiCustomList)this.f_97516_).getAllEntries()) {
                if (entry instanceof GuiFreeKeysList.InputEntry) {
                    GuiFreeKeysList.InputEntry inputEntry = (GuiFreeKeysList.InputEntry)entry;
                    if (!inputEntry.getInput().toString().toLowerCase().contains(this.lastSearch.toLowerCase())) continue;
                    this.f_97516_.m_6702_().add(entry);
                    continue;
                }
                this.f_97516_.m_6702_().add(entry);
            }
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        this.f_97516_.m_6305_(stack, mouseX, mouseY, partialTicks);
        GuiNewControls.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        boolean flag = false;
        if (!this.showFree) {
            for (KeyMapping keybinding : this.options.f_92059_) {
                if (keybinding.m_90864_()) continue;
                flag = true;
                break;
            }
        }
        this.search.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.buttonReset.f_93623_ = flag;
        if (!flag) {
            this.confirmingReset = false;
            this.buttonReset.m_93666_((Component)new TranslatableComponent("controls.resetAll"));
        }
        TranslatableComponent text = new TranslatableComponent("options.search");
        this.f_96547_.m_92889_(stack, (Component)text, (float)this.f_96543_ / 2.0f - 77.5f - (float)this.f_96547_.m_92895_(text.getString()) - 5.0f, (float)(this.f_96544_ - 29 - 42), 0xFFFFFF);
        if (this.patreonButton.m_5702_()) {
            String str = "Join " + this.name + " and other patrons!";
            int tempX = mouseX;
            int tempY = mouseY;
            boolean outOfBounds = tempX < this.patreonButton.f_93620_ || tempX > this.patreonButton.f_93620_ + this.patreonButton.m_5711_();
            if (outOfBounds |= tempY < this.patreonButton.f_93621_ || tempY > this.patreonButton.f_93621_ + this.patreonButton.m_93694_()) {
                tempX = this.patreonButton.f_93620_ + this.patreonButton.m_5711_();
                tempY = this.patreonButton.f_93621_ + this.patreonButton.m_93694_() / 2 + 7;
            }
            this.m_96602_(stack, (Component)new TextComponent(str), tempX, tempY);
        }
        for (Widget widget : this.f_169369_) {
            widget.m_6305_(stack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double mx, double my, int mb) {
        boolean valid;
        if (this.f_97514_ != null) {
            this.options.m_92159_(this.f_97514_, InputConstants.Type.MOUSE.m_84895_(mb));
            this.f_97514_ = null;
            KeyMapping.m_90854_();
            valid = true;
            this.search.m_94178_(false);
        } else if (mb == 0 && this.f_97516_.m_6375_(mx, my, mb)) {
            this.m_7897_(true);
            this.m_7522_((GuiEventListener)this.f_97516_);
            valid = true;
            this.search.m_94178_(false);
        } else {
            valid = this.search.m_6375_(mx, my, mb);
            if (!valid && this.search.m_93696_() && mb == 1) {
                this.search.m_94144_("");
                valid = true;
            }
        }
        if (!valid) {
            for (GuiEventListener iguieventlistener : this.m_6702_()) {
                if (!iguieventlistener.m_6375_(mx, my, mb)) continue;
                this.m_7522_(iguieventlistener);
                if (mb == 0) {
                    this.m_7897_(true);
                }
                return true;
            }
            valid = true;
        }
        return valid;
    }

    public boolean m_6348_(double mx, double my, int mb) {
        if (mb == 0 && this.f_97516_.m_6348_(mx, my, mb)) {
            this.m_7897_(false);
            return true;
        }
        if (this.search.m_93696_()) {
            return this.search.m_6348_(mx, my, mb);
        }
        this.m_7897_(false);
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (!this.search.m_93696_() && this.f_97514_ == null && GuiNewControls.m_96637_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)70)) {
            this.search.m_94178_(true);
            return true;
        }
        if (this.search.m_7933_(keyCode, scanCode, modifier)) {
            return true;
        }
        if (this.search.m_93696_() && keyCode == 256) {
            this.search.m_94178_(false);
            return true;
        }
        if (this.f_97514_ != null) {
            if (keyCode == 256) {
                this.f_97514_.setKeyModifierAndCode(KeyModifier.getActiveModifier(), InputConstants.f_84822_);
                this.options.m_92159_(this.f_97514_, InputConstants.f_84822_);
            } else {
                this.f_97514_.setKeyModifierAndCode(KeyModifier.getActiveModifier(), InputConstants.m_84827_((int)keyCode, (int)scanCode));
                this.options.m_92159_(this.f_97514_, InputConstants.m_84827_((int)keyCode, (int)scanCode));
            }
            if (!KeyModifier.isKeyCodeModifier((InputConstants.Key)this.f_97514_.getKey())) {
                this.f_97514_ = null;
            }
            this.f_97515_ = Util.m_137550_();
            KeyMapping.m_90854_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }
}

