/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.blamejared.controlling.api.events.KeyEntryListenersEvent;
import com.blamejared.controlling.api.events.KeyEntryMouseClickedEvent;
import com.blamejared.controlling.api.events.KeyEntryMouseReleasedEvent;
import com.blamejared.controlling.api.events.KeyEntryRenderEvent;
import com.blamejared.controlling.client.gui.GuiCustomList;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.controls.ControlList;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiNewKeyBindingList
extends GuiCustomList {
    private final ControlsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;

    public GuiNewKeyBindingList(ControlsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.f_93388_ = controls.f_96543_ + 45;
        this.f_93389_ = controls.f_96544_;
        this.f_93390_ = 43;
        this.f_93391_ = controls.f_96544_ - 80;
        this.f_93392_ = controls.f_96543_ + 45;
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.m_6702_().clear();
        this.allEntries = new ArrayList();
        Object[] akeybinding = (KeyMapping[])ArrayUtils.clone((Object[])mcIn.f_91066_.f_92059_);
        Arrays.sort(akeybinding);
        String s = null;
        for (Object keybinding : akeybinding) {
            int i;
            String s1 = keybinding.m_90858_();
            if (!s1.equals(s)) {
                s = s1;
                if (!s1.endsWith(".hidden")) {
                    this.addEntry(new CategoryEntry(s1));
                }
            }
            if ((i = mcIn.f_91062_.m_92895_(I18n.m_118938_((String)keybinding.m_90860_(), (Object[])new Object[0]))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = i;
            }
            if (s1.endsWith(".hidden")) continue;
            this.addEntry(new KeyEntry((KeyMapping)keybinding));
        }
    }

    protected void m_7415_(PoseStack matrixStack, int mouseX, int mouseY) {
        ControlList.Entry entry = this.getEntryAtPos(mouseY);
        if (!(entry instanceof KeyEntry)) {
            return;
        }
        KeyEntry keyEntry = (KeyEntry)entry;
        GuiUtils.drawHoveringText((PoseStack)matrixStack, Collections.singletonList(new TranslatableComponent(keyEntry.getKeybinding().m_90858_())), (int)mouseX, (int)mouseY, (int)this.mc.f_91080_.f_96543_, (int)this.mc.f_91080_.f_96544_, (int)0, (Font)this.mc.f_91062_);
    }

    public ControlList.Entry getEntryAtPos(double mouseY) {
        if (mouseY <= (double)this.getTop() || mouseY >= (double)this.getBottom()) {
            return null;
        }
        int i1 = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        int j1 = i1 / this.f_93387_;
        return i1 >= 0 && j1 < this.m_5773_() ? (ControlList.Entry)this.m_6702_().get(j1) : null;
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends ControlList.Entry {
        private final String labelText;
        private final int labelWidth;
        private final String name;

        public CategoryEntry(String name) {
            this.labelText = I18n.m_118938_((String)name, (Object[])new Object[0]);
            this.labelWidth = GuiNewKeyBindingList.this.mc.f_91062_.m_92895_(this.labelText);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void m_6311_(PoseStack stack, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).f_93386_.f_91062_.m_92883_(stack, this.labelText, (float)(((GuiNewKeyBindingList)GuiNewKeyBindingList.this).f_93386_.f_91080_.f_96543_ / 2 - this.labelWidth / 2), (float)(y + rowWidth - 9 - 1), 0xFFFFFF);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput neo) {
                    neo.m_169143_(NarratedElementType.TITLE, CategoryEntry.this.labelText);
                }
            });
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends ControlList.Entry {
        private final KeyMapping keybinding;
        private final String keyDesc;
        private final Button btnChangeKeyBinding;
        private final Button btnResetKeyBinding;

        private KeyEntry(final KeyMapping name) {
            this.keybinding = name;
            this.keyDesc = I18n.m_118938_((String)name.m_90860_(), (Object[])new Object[0]);
            this.btnChangeKeyBinding = new Button(0, 0, 95, 20, (Component)new TextComponent(this.keyDesc), p_214386_2_ -> {
                GuiNewKeyBindingList.this.controlsScreen.f_97514_ = name;
            }){

                protected MutableComponent m_5646_() {
                    return name.m_90862_() ? new TranslatableComponent("narrator.controls.unbound", new Object[]{KeyEntry.this.keyDesc}) : new TranslatableComponent("narrator.controls.bound", new Object[]{KeyEntry.this.keyDesc, super.m_5646_()});
                }
            };
            this.btnResetKeyBinding = new Button(0, 0, 50, 20, (Component)new TranslatableComponent("controls.reset"), p_214387_2_ -> {
                this.keybinding.setToDefault();
                ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).f_93386_.f_91066_.m_92159_(name, name.m_90861_());
                KeyMapping.m_90854_();
            }){

                protected MutableComponent m_5646_() {
                    return new TranslatableComponent("narrator.controls.reset", new Object[]{KeyEntry.this.keyDesc});
                }
            };
        }

        public void m_6311_(PoseStack stack, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            MinecraftForge.EVENT_BUS.post((Event)new KeyEntryRenderEvent(this, stack, slotIndex, y, x, rowLeft, rowWidth, mouseX, mouseY, hovered, partialTicks));
            int i = y;
            int j = x;
            boolean flag = GuiNewKeyBindingList.this.controlsScreen.f_97514_ == this.keybinding;
            int length = Math.max(0, j + 90 - GuiNewKeyBindingList.this.maxListLabelWidth);
            GuiNewKeyBindingList.this.mc.f_91062_.m_92883_(stack, this.keyDesc, (float)length, (float)(y + rowWidth / 2 - 4), 0xFFFFFF);
            this.btnResetKeyBinding.f_93620_ = x + 190 + 20;
            this.btnResetKeyBinding.f_93621_ = y;
            this.btnResetKeyBinding.f_93623_ = !this.keybinding.m_90864_();
            this.btnResetKeyBinding.m_6305_(stack, mouseX, mouseY, partialTicks);
            this.btnChangeKeyBinding.f_93620_ = j + 105;
            this.btnChangeKeyBinding.f_93621_ = i;
            this.btnChangeKeyBinding.m_93666_(this.keybinding.m_90863_());
            boolean flag1 = false;
            boolean keyCodeModifierConflict = true;
            if (!this.keybinding.m_90862_()) {
                for (KeyMapping keybinding : GuiNewKeyBindingList.this.mc.f_91066_.f_92059_) {
                    if (keybinding == this.keybinding || !this.keybinding.m_90850_(keybinding)) continue;
                    flag1 = true;
                    keyCodeModifierConflict &= keybinding.hasKeyCodeModifierConflict(this.keybinding);
                }
            }
            Component message = this.btnChangeKeyBinding.m_6035_();
            if (flag) {
                this.btnChangeKeyBinding.m_93666_((Component)new TextComponent(ChatFormatting.WHITE + "> " + ChatFormatting.YELLOW + message.getString() + ChatFormatting.WHITE + " <"));
            } else if (flag1) {
                MutableComponent modConflict = ComponentUtils.m_130750_((MutableComponent)message.m_6881_(), (Style)message.m_7383_().m_178520_(0xFFAA00));
                MutableComponent keyConflict = ComponentUtils.m_130750_((MutableComponent)message.m_6881_(), (Style)message.m_7383_().m_178520_(0xFFAA00));
                this.btnChangeKeyBinding.m_93666_((Component)(keyCodeModifierConflict ? modConflict : keyConflict));
            }
            this.btnChangeKeyBinding.m_6305_(stack, mouseX, mouseY, partialTicks);
        }

        public List<GuiEventListener> m_6702_() {
            KeyEntryListenersEvent event = new KeyEntryListenersEvent(this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getListeners();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.btnChangeKeyBinding, (Object)this.btnResetKeyBinding);
        }

        public boolean m_6375_(double mouseX, double mouseY, int buttonId) {
            KeyEntryMouseClickedEvent event = new KeyEntryMouseClickedEvent(this, mouseX, mouseY, buttonId);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isHandled()) {
                return true;
            }
            if (this.btnChangeKeyBinding.m_6375_(mouseX, mouseY, buttonId)) {
                return true;
            }
            return this.btnResetKeyBinding.m_6375_(mouseX, mouseY, buttonId);
        }

        public boolean m_6348_(double mouseX, double mouseY, int buttonId) {
            KeyEntryMouseReleasedEvent event = new KeyEntryMouseReleasedEvent(this, mouseX, mouseY, buttonId);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isHandled()) {
                return true;
            }
            return this.btnChangeKeyBinding.m_6348_(mouseX, mouseY, buttonId);
        }

        public KeyMapping getKeybinding() {
            return this.keybinding;
        }

        public String getKeyDesc() {
            return this.keyDesc;
        }

        public Button getBtnResetKeyBinding() {
            return this.btnResetKeyBinding;
        }

        public Button getBtnChangeKeyBinding() {
            return this.btnChangeKeyBinding;
        }
    }
}

