/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco;

import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class GEConfig {
    public static final Common COMMON = GEConfig.register(ModConfig.Type.COMMON, Common::new);

    static void init() {
    }

    private static <T> T register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, T> factory) {
        Pair configPair = new ForgeConfigSpec.Builder().configure(factory);
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)configPair.getRight());
        return (T)configPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enableWanderersTrades;
        public final ForgeConfigSpec.BooleanValue enableVillagersTrades;
        public final ForgeConfigSpec.BooleanValue shouldSubBiomesSpawn;
        public final ForgeConfigSpec.BooleanValue shouldIslandBiomesSpawn;
        public final ForgeConfigSpec.BooleanValue addVanillaBiomesFeatures;
        public final ForgeConfigSpec.BooleanValue shouldBeachAndRiverBiomesSpawn;
        public final ForgeConfigSpec.BooleanValue shouldDangerousBlocksSpawn;
        public final ForgeConfigSpec.ConfigValue<Integer> alderForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> alpsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> appalachianMountainsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> ashForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> aspenForestWeight;
        public final ForgeConfigSpec.ConfigValue<Double> goldenAspenForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> autumnalValleyWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> balsaForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> bambooForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> baobabSavannaWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> basswoodForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> bayouWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> beechWoodsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> bogWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> borealForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> brushlandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> butternutWoodsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> bushlandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> canyonWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> cedarForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> chaparralWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> cherryBlossomForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> chestnutForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> coldDesertWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> coniferousForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> cragWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> cypressGroveWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> darkSwamplandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> denseForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> douglasForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> dogwoodForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> drylandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> dunesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> dyingForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> dyingSwampWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> ebonyForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> elmForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> eucalyptusForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> evergreenForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> fenWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> firForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> floweringFieldsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> fungalWoodlandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> ginkgoWoodsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> grasslandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> greatLakesWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> groveWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> hazelWoodsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> heathlandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> hemlockForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> hickoryWoodlandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> highlandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> hollyForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> hornbeamForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> icyForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> jacarandaGroveWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> japaneseMapleForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> juniperGrove;
        public final ForgeConfigSpec.ConfigValue<Integer> kapokJungleWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> coldLakeWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lakeWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lukewarmLakeWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> larchTaigaWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lavenderFieldsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lindenForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lushBadlandsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lushDesertWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lushSavannaWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lushSwampWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> magnoliaGroveWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mahoganyForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mangroveWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mapleForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mapleTaigaWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> marshWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> marulaSavannaWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> meadowWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mireWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mixedForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> moorWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mountainWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> muskegWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> needleForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> oakWoodlandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> outbackWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> orchardWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> overgrownCliffsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> pineTaigaWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> planeForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> poplarGroveWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> prairieWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> quagmireWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rainbowEucalyptusForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rainforestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> redDesertWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> redwoodForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> robiniaWoodlandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> rosewoodForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> sacredSprings;
        public final ForgeConfigSpec.ConfigValue<Integer> seasonalForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> scrublandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> sequoiaVallyWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> shieldWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> shrublandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> snowyBirchForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> snowyEvergreenForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> snowyConiferousForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> snowyDyingForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> snowyForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> steppeWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> thicketWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> temperateRainforestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> tropicalRainforestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> tundraWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> walnutForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> wetlandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> wisteriaForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> xericShrublandWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> yewWoodsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> zelkovaForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mysticalValleyWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> sinisterForestWeight;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General Configuration for Generic Ecosphere");
            this.enableWanderersTrades = builder.comment("If false, Wandering Traders will not sell any Generic Ecosphere items. If changed, a MC restart is required").define("wanderingTraderExtraTrades", true);
            this.enableVillagersTrades = builder.comment("If false, Villagers will not sell any Generic Ecosphere items. If changed, a MC restart is required").define("villagerExtraTrades", true);
            this.shouldSubBiomesSpawn = builder.comment("If false, all sub-biomes will not generate; does not affect vanilla biomes. If changed, a MC restart is required").define("subBiomes", true);
            this.shouldIslandBiomesSpawn = builder.comment("If false, island biomes will not generate. If changed, a MC restart is required").define("islandBiomes", true);
            this.shouldBeachAndRiverBiomesSpawn = builder.comment("If false, beach and river variants will not generate, which does not affect vanilla biome variants. If changed, a MC restart is required").define("riversAndBeaches", true);
            this.addVanillaBiomesFeatures = builder.comment("If false, vanilla biomes will not have extra features added to them. If changed, a MC restart is required").define("enhanceVanillaBiomes", true);
            this.shouldDangerousBlocksSpawn = builder.comment("If false, dangerous blocks such as thorny bushes will not generate in the world. If changed, a MC restart is required").define("dangerousBlocks", true);
            builder.comment("Biome Weights, zero means the biome will not appear; note that disabling certain biomes will cause some their sub-biomes to not appear. If changes are made, a MC restart is required");
            this.alderForestWeight = builder.define("Alder Forest Weight", (Object)6);
            this.alpsWeight = builder.define("Alps Weight", (Object)5);
            this.appalachianMountainsWeight = builder.define("Appalachian Mountains Weight", (Object)5);
            this.ashForestWeight = builder.define("Ash Forest Weight", (Object)5);
            this.aspenForestWeight = builder.define("Aspen Forest Weight", (Object)5);
            this.goldenAspenForestWeight = builder.define("Golden Aspen Forest Weight", (Object)0.25);
            this.autumnalValleyWeight = builder.define("Autumnal Valley Weight", (Object)3);
            this.balsaForestWeight = builder.define("Balsa Forest Weight", (Object)3);
            this.bambooForestWeight = builder.define("Bamboo Forest Weight", (Object)1);
            this.baobabSavannaWeight = builder.define("Baobab Savanna Weight", (Object)1);
            this.basswoodForestWeight = builder.define("Basswood Forest Weight", (Object)4);
            this.bayouWeight = builder.define("Bayou Weight", (Object)4);
            this.beechWoodsWeight = builder.define("Beech Woods Weight", (Object)5);
            this.bogWeight = builder.define("Bog Weight", (Object)3);
            this.borealForestWeight = builder.define("Boreal Forest Weight", (Object)5);
            this.brushlandWeight = builder.define("Brushland Weight", (Object)2);
            this.butternutWoodsWeight = builder.define("Butternut Woods Weight", (Object)4);
            this.bushlandWeight = builder.define("Bushland Weight", (Object)10);
            this.canyonWeight = builder.define("Canyon Weight", (Object)2);
            this.cedarForestWeight = builder.define("Cedar Forest Weight", (Object)5);
            this.chaparralWeight = builder.define("Chaparral Weight", (Object)5);
            this.cherryBlossomForestWeight = builder.define("Cherry Blossom Forest Weight", (Object)1);
            this.chestnutForestWeight = builder.define("Chestnut Forest Weight", (Object)2);
            this.coldDesertWeight = builder.define("Cold Desert Weight", (Object)1);
            this.coniferousForestWeight = builder.define("Coniferous Forest Weight", (Object)7);
            this.cragWeight = builder.define("Crag Weight", (Object)1);
            this.cypressGroveWeight = builder.define("Cypress Grove Weight", (Object)5);
            this.darkSwamplandWeight = builder.define("Dark Swampland Weight", (Object)1);
            this.denseForestWeight = builder.define("Dense Forest Weight", (Object)1);
            this.douglasForestWeight = builder.define("Douglas Forest Weight", (Object)5);
            this.dogwoodForestWeight = builder.define("Dogwood Forest Weight", (Object)3);
            this.drylandWeight = builder.define("Dryland Weight", (Object)1);
            this.dunesWeight = builder.define("Dunes Weight", (Object)1);
            this.dyingForestWeight = builder.define("Dying Forest Weight", (Object)2);
            this.dyingSwampWeight = builder.define("Dying Swamp Weight", (Object)1);
            this.ebonyForestWeight = builder.define("Ebony Forest Weight", (Object)1);
            this.elmForestWeight = builder.define("Elm Forest Weight", (Object)5);
            this.eucalyptusForestWeight = builder.define("Eucalyptus Forest Weight", (Object)1);
            this.evergreenForestWeight = builder.define("Evergreen Forest Weight", (Object)5);
            this.fenWeight = builder.define("Fen Weight", (Object)2);
            this.firForestWeight = builder.define("Fir Forest Weight", (Object)5);
            this.floweringFieldsWeight = builder.define("Flowering Fields Weight", (Object)4);
            this.fungalWoodlandWeight = builder.define("Fungal Woodland Weight", (Object)1);
            this.ginkgoWoodsWeight = builder.define("Ginkgo Woods Weight", (Object)3);
            this.grasslandWeight = builder.define("Grassland Weight", (Object)19);
            this.greatLakesWeight = builder.define("Great Lakes Weight", (Object)0);
            this.groveWeight = builder.define("Grove Weight", (Object)5);
            this.hazelWoodsWeight = builder.define("Hazel Woods Weight", (Object)4);
            this.heathlandWeight = builder.define("Heathland Weight", (Object)3);
            this.hemlockForestWeight = builder.define("Hemlock Forest Weight", (Object)3);
            this.hickoryWoodlandWeight = builder.define("Hickory Woodland Weight", (Object)3);
            this.highlandWeight = builder.define("Highland Weight", (Object)4);
            this.hollyForestWeight = builder.define("Holly Forest Weight", (Object)7);
            this.hornbeamForestWeight = builder.define("Hornbeam Forest Weight", (Object)4);
            this.icyForestWeight = builder.define("Icy Forest Weight", (Object)1);
            this.jacarandaGroveWeight = builder.define("Jacaranda Grove Weight", (Object)3);
            this.japaneseMapleForestWeight = builder.define("Japanese Maple Forest Weight", (Object)2);
            this.juniperGrove = builder.define("Juniper Grove Weight", (Object)2);
            this.kapokJungleWeight = builder.define("Kapok Jungle Weight", (Object)1);
            this.coldLakeWeight = builder.define("Cold Lake Weight", (Object)1);
            this.lakeWeight = builder.define("Lake Weight", (Object)3);
            this.lukewarmLakeWeight = builder.define("Lukewarm Lake Weight", (Object)1);
            this.larchTaigaWeight = builder.define("Larch Taiga Weight", (Object)5);
            this.lavenderFieldsWeight = builder.define("Lavender Fields Weight", (Object)5);
            this.lindenForestWeight = builder.define("Linden Forest Weight", (Object)5);
            this.lushBadlandsWeight = builder.define("Lush Badlands Weight", (Object)1);
            this.lushDesertWeight = builder.define("Lush Desert Weight", (Object)1);
            this.lushSavannaWeight = builder.define("Lush Savanna Weight", (Object)2);
            this.lushSwampWeight = builder.define("Lush Swamp Weight", (Object)2);
            this.magnoliaGroveWeight = builder.define("Magnolia Grove Weight", (Object)1);
            this.mahoganyForestWeight = builder.define("Mahogany Forest Weight", (Object)1);
            this.mangroveWeight = builder.define("Mangrove Marsh Weight", (Object)1);
            this.mapleForestWeight = builder.define("Maple Forest Weight", (Object)7);
            this.mapleTaigaWeight = builder.define("Maple Taiga Weight", (Object)7);
            this.marshWeight = builder.define("Marsh Weight", (Object)5);
            this.marulaSavannaWeight = builder.define("Marula Savanna Weight", (Object)1);
            this.meadowWeight = builder.define("Meadow Weight", (Object)10);
            this.mireWeight = builder.define("Mire Weight", (Object)2);
            this.mixedForestWeight = builder.define("Mixed Forest Weight", (Object)5);
            this.moorWeight = builder.define("Moor Weight", (Object)2);
            this.mountainWeight = builder.define("Mountain Weight", (Object)4);
            this.muskegWeight = builder.define("Muskeg Weight", (Object)2);
            this.needleForestWeight = builder.define("Needle Forest Weight", (Object)1);
            this.oakWoodlandWeight = builder.define("Oak Woodland Weight", (Object)9);
            this.outbackWeight = builder.define("Outback Weight", (Object)2);
            this.orchardWeight = builder.define("Orchard Weight", (Object)5);
            this.overgrownCliffsWeight = builder.define("Overgrown Cliffs Weight", (Object)1);
            this.pineTaigaWeight = builder.define("Pine Taiga Weight", (Object)5);
            this.planeForestWeight = builder.define("Plane Forest Weight", (Object)5);
            this.poplarGroveWeight = builder.define("Poplar Grove Weight", (Object)5);
            this.prairieWeight = builder.define("Prairie Weight", (Object)8);
            this.quagmireWeight = builder.define("Quagmire Weight", (Object)1);
            this.rainbowEucalyptusForestWeight = builder.define("Rainbow Eucalyptus Forest Weight", (Object)1);
            this.rainforestWeight = builder.define("Rainforest Weight", (Object)1);
            this.redDesertWeight = builder.define("Red Desert Weight", (Object)2);
            this.redwoodForestWeight = builder.define("Redwood Forest Weight", (Object)1);
            this.robiniaWoodlandWeight = builder.define("Robinia Woodland Weight", (Object)4);
            this.rosewoodForestWeight = builder.define("Rosewood Weight", (Object)1);
            this.sacredSprings = builder.define("Rosewood Weight", (Object)1);
            this.seasonalForestWeight = builder.define("Seasonal Forest Weight", (Object)5);
            this.scrublandWeight = builder.define("Scrubland Weight", (Object)9);
            this.sequoiaVallyWeight = builder.define("Sequoia Valley Weight", (Object)1);
            this.shieldWeight = builder.define("Shield Weight", (Object)3);
            this.shrublandWeight = builder.define("Shrubland Weight", (Object)12);
            this.snowyBirchForestWeight = builder.define("Snowy Birch Forest Weight", (Object)3);
            this.snowyEvergreenForestWeight = builder.define("Snowy Evergreen Forest Weight", (Object)3);
            this.snowyConiferousForestWeight = builder.define("Snowy Coniferous Forest Weight", (Object)3);
            this.snowyDyingForestWeight = builder.define("Snowy Dying Forest Weight", (Object)1);
            this.snowyForestWeight = builder.define("Snowy Forest Weight", (Object)3);
            this.steppeWeight = builder.define("Steppe Weight", (Object)3);
            this.thicketWeight = builder.define("Thicket Weight", (Object)4);
            this.temperateRainforestWeight = builder.define("Temperate Rainforest Weight", (Object)2);
            this.tropicalRainforestWeight = builder.define("Tropical Rainforest Weight", (Object)1);
            this.tundraWeight = builder.define("Tundra Weight", (Object)5);
            this.walnutForestWeight = builder.define("Walnut Forest Weight", (Object)3);
            this.wisteriaForestWeight = builder.define("Wisteria Forest Weight", (Object)1);
            this.wetlandWeight = builder.define("Wetland Weight", (Object)3);
            this.xericShrublandWeight = builder.define("Xeric Shrubland Weight", (Object)4);
            this.yewWoodsWeight = builder.define("Yew Woods Weight", (Object)5);
            this.zelkovaForestWeight = builder.define("Zelkova Forest Weight", (Object)3);
            this.mysticalValleyWeight = builder.define("Mystical Valley Weight", (Object)1);
            this.sinisterForestWeight = builder.define("Sinister Forest Weight", (Object)1);
        }
    }
}

