/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco;

import com.hydroartdragon3.genericeco.GEConfig;
import com.hydroartdragon3.genericeco.client.renderer.GEEntityClientEvents;
import com.hydroartdragon3.genericeco.client.renderer.GERenderTypeHandler;
import com.hydroartdragon3.genericeco.client.renderer.entity.GEBoatRenderer;
import com.hydroartdragon3.genericeco.client.renderer.tile.GEChestRenderer;
import com.hydroartdragon3.genericeco.common.blockEntity.GEWoodType;
import com.hydroartdragon3.genericeco.common.world.tree.ModTreePlacers;
import com.hydroartdragon3.genericeco.init.ModEnchantments;
import com.hydroartdragon3.genericeco.init.ModEntities;
import com.hydroartdragon3.genericeco.init.ModSounds;
import com.hydroartdragon3.genericeco.init.ModVanillaCompat;
import java.util.Locale;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="genericeco")
public class GenericEcosphere {
    public static final String MOD_ID = "genericeco";

    public GenericEcosphere() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(GEEntityClientEvents::registerEntityModels);
        GEConfig.init();
        ModEntities.ENTITIES.register(bus);
        ModEntities.TILE_ENTITIES.register(bus);
        ModSounds.SOUNDS.register(bus);
        ModEnchantments.ENCHANTMENT.register(bus);
        ModTreePlacers.TREE_DECORATORS.register(bus);
        ModTreePlacers.FOLIAGE_PLACERS.register(bus);
        ModTreePlacers.register();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModVanillaCompat::setup);
        GEWoodType.registerGEWoodTypes();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        GERenderTypeHandler.init();
        ModVanillaCompat.registerBlockColors();
        event.enqueueWork(GEWoodType::setupGEWoodTypeAtlas);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModEntities.SIGN.get()), SignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModEntities.CHEST.get()), GEChestRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModEntities.TRAPPED_CHEST.get()), GEChestRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BOAT.get()), GEBoatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MUD_BALL.get()), ThrownItemRenderer::new);
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(MOD_ID, name.toLowerCase(Locale.ROOT));
    }
}

