/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.client.renderer.entity;

import com.hydroartdragon3.genericeco.client.renderer.GEEntityClientEvents;
import com.hydroartdragon3.genericeco.client.renderer.models.GEBoatModel;
import com.hydroartdragon3.genericeco.common.entity.GEBoatEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GEBoatRenderer
extends EntityRenderer<GEBoatEntity> {
    private final GEBoatModel modelBoat;

    public GEBoatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
        this.modelBoat = new GEBoatModel(context.m_174023_(GEEntityClientEvents.BOAT));
    }

    public void render(GEBoatEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float f2;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.375, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float f = (float)entityIn.m_38385_() - partialTicks;
        float f1 = entityIn.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entityIn.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = entityIn.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStackIn.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entityIn.m_38352_(partialTicks), true));
        }
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        this.modelBoat.setupAnim(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = bufferIn.m_6299_(this.modelBoat.m_103119_(this.getTextureLocation(entityIn)));
        this.modelBoat.m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entityIn.m_5842_()) {
            VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110478_());
            this.modelBoat.waterPatch().m_104301_(matrixStackIn, buffer, packedLightIn, OverlayTexture.f_118083_);
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(GEBoatEntity entity) {
        if (entity.getWoodType() == null) {
            return new ResourceLocation("genericeco", "textures/entity/boat/oak.png");
        }
        return new ResourceLocation("genericeco", "textures/entity/boat/" + entity.getWoodType() + ".png");
    }
}

