/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.client.renderer.models;

import com.google.common.collect.ImmutableList;
import com.hydroartdragon3.genericeco.common.entity.GEBoatEntity;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GEBoatModel
extends ListModel<GEBoatEntity> {
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ModelPart waterPatch;
    private final ImmutableList<ModelPart> parts;

    public GEBoatModel(ModelPart parts) {
        this.leftPaddle = parts.m_171324_("left_paddle");
        this.rightPaddle = parts.m_171324_("right_paddle");
        this.waterPatch = parts.m_171324_("water_patch");
        this.parts = ImmutableList.of((Object)parts.m_171324_("bottom"), (Object)parts.m_171324_("back"), (Object)parts.m_171324_("front"), (Object)parts.m_171324_("right"), (Object)parts.m_171324_("left"), (Object)this.leftPaddle, (Object)this.rightPaddle);
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-13.0f, -7.0f, -1.0f, 18.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-15.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)4.712389f, (float)0.0f));
        partdefinition.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-8.0f, -7.0f, -1.0f, 16.0f, 6.0f, 2.0f), PartPose.m_171423_((float)15.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        partdefinition.m_171599_("right", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        partdefinition.m_171599_("left", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171481_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)9.0f));
        partdefinition.m_171599_("left_paddle", CubeListBuilder.m_171558_().m_171514_(62, 0).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        partdefinition.m_171599_("right_paddle", CubeListBuilder.m_171558_().m_171514_(62, 20).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        partdefinition.m_171599_("water_patch", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(GEBoatEntity entity, float p_102270_, float p_102271_, float p_102272_, float p_102273_, float p_102274_) {
        GEBoatModel.animatePaddle(entity, 0, this.leftPaddle, p_102270_);
        GEBoatModel.animatePaddle(entity, 1, this.rightPaddle, p_102270_);
    }

    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    public ModelPart waterPatch() {
        return this.waterPatch;
    }

    private static void animatePaddle(GEBoatEntity entity, int p_170466_, ModelPart p_170467_, float p_170468_) {
        float f = entity.m_38315_(p_170466_, p_170468_);
        p_170467_.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)(-f)) + 1.0f) / 2.0f));
        p_170467_.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(-f + 1.0f)) + 1.0f) / 2.0f));
        if (p_170466_ == 1) {
            p_170467_.f_104204_ = (float)Math.PI - p_170467_.f_104204_;
        }
    }
}

