/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.client.renderer.tile;

import com.hydroartdragon3.genericeco.api.interfaces.GEChest;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GEChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static Block itemBlock = null;
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    private boolean isChristmas;

    public GEChestRenderer(BlockEntityRendererProvider.Context context) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
        ModelPart modelpart = context.m_173582_(ModelLayers.f_171275_);
        this.bottom = modelpart.m_171324_(BOTTOM);
        this.lid = modelpart.m_171324_(LID);
        this.lock = modelpart.m_171324_(LOCK);
        ModelPart modelLeft = context.m_173582_(ModelLayers.f_171133_);
        this.doubleLeftBottom = modelLeft.m_171324_(BOTTOM);
        this.doubleLeftLid = modelLeft.m_171324_(LID);
        this.doubleLeftLock = modelLeft.m_171324_(LOCK);
        ModelPart modelRight = context.m_173582_(ModelLayers.f_171134_);
        this.doubleRightBottom = modelRight.m_171324_(BOTTOM);
        this.doubleRightLid = modelRight.m_171324_(LID);
        this.doubleRightLock = modelRight.m_171324_(LOCK);
    }

    public void m_6922_(T blockEntity, float ticks, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        Level level = blockEntity.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? blockEntity.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockstate.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = blockstate.m_60734_();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            pose.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            pose.m_85837_(0.5, 0.5, 0.5);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(-f));
            pose.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult combineResult = flag ? abstractchestblock.m_5641_(blockstate, level, blockEntity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)combineResult.m_5649_(ChestBlock.m_51517_((LidBlockEntity)((LidBlockEntity)blockEntity)))).get(ticks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)combineResult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(light);
            VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getChestTexture(blockEntity, chesttype)));
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.render(pose, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, overlay);
                } else {
                    this.render(pose, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, overlay);
                }
            } else {
                this.render(pose, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, overlay);
            }
            pose.m_85849_();
        }
    }

    private void render(PoseStack p_112370_, VertexConsumer p_112371_, ModelPart p_112372_, ModelPart p_112373_, ModelPart p_112374_, float p_112375_, int p_112376_, int p_112377_) {
        p_112373_.f_104203_ = p_112372_.f_104203_ = -(p_112375_ * 1.5707964f);
        p_112372_.m_104301_(p_112370_, p_112371_, p_112376_, p_112377_);
        p_112373_.m_104301_(p_112370_, p_112371_, p_112376_, p_112377_);
        p_112374_.m_104301_(p_112370_, p_112371_, p_112376_, p_112377_);
    }

    protected ResourceLocation getChestTexture(T tileEntity, ChestType chestType) {
        String mod_id = "genericeco";
        Block inventoryBlock = itemBlock;
        if (inventoryBlock == null) {
            inventoryBlock = tileEntity.m_58900_().m_60734_();
        }
        GEChest block = (GEChest)inventoryBlock;
        Object type = block.getWood() + (block.isTrapped() ? "_trapped" : "_normal");
        if (this.isChristmas) {
            type = "christmas";
            mod_id = "minecraft";
        }
        return switch (chestType) {
            case ChestType.SINGLE -> new ResourceLocation(mod_id, "textures/entity/chest/" + (String)type + ".png");
            case ChestType.LEFT -> new ResourceLocation(mod_id, "textures/entity/chest/" + (String)type + "_left.png");
            case ChestType.RIGHT -> new ResourceLocation(mod_id, "textures/entity/chest/" + (String)type + "_right.png");
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

