/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.common.block;

import com.hydroartdragon3.genericeco.client.renderer.GERenderTypeHandler;
import com.hydroartdragon3.genericeco.core.misc.GEProperties;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class GEWaterloggableSapling
extends BushBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty STAGE = BlockStateProperties.f_61387_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private final AbstractTreeGrower tree;

    public GEWaterloggableSapling(AbstractTreeGrower treeIn) {
        super(GEProperties.SAPLING);
        this.tree = treeIn;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        GERenderTypeHandler.setRenderType((Block)this, GERenderTypeHandler.RenderTypeSkeleton.CUTOUT);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7455_(BlockState blockState, ServerLevel world, BlockPos pos, Random random) {
        if (world.m_46803_(pos.m_7494_()) >= 9 && random.nextInt(7) == 0) {
            if (!world.isAreaLoaded(pos, 1)) {
                return;
            }
            this.advanceTree(world, pos, blockState, random);
        }
    }

    public void advanceTree(ServerLevel world, BlockPos pos, BlockState state, Random rand) {
        if ((Integer)state.m_61143_((Property)STAGE) == 0) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)STAGE), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((LevelAccessor)world, (Random)rand, (BlockPos)pos)) {
                return;
            }
            this.tree.m_6334_(world, world.m_7726_().m_8481_(), pos, state, rand);
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)worldIn.f_46441_.nextFloat() < 0.45;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        this.advanceTree(worldIn, pos, state, rand);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_6219_().m_5945_(currentPos, (Object)Blocks.f_49990_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState FluidState2 = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = super.m_5573_(context);
        if (state != null) {
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAGE, WATERLOGGED});
    }
}

