/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.common.block;

import com.hydroartdragon3.genericeco.client.renderer.GERenderTypeHandler;
import com.hydroartdragon3.genericeco.core.misc.GEProperties;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolType;

public class WoodPostBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_X = WoodPostBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_Y = WoodPostBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_Z = WoodPostBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    private static final BooleanProperty[] CHAINED = new BooleanProperty[]{BooleanProperty.m_61465_((String)"chain_down"), BooleanProperty.m_61465_((String)"chain_up"), BooleanProperty.m_61465_((String)"chain_north"), BooleanProperty.m_61465_((String)"chain_south"), BooleanProperty.m_61465_((String)"chain_west"), BooleanProperty.m_61465_((String)"chain_east")};
    private final Block block;

    public WoodPostBlock(Block block) {
        super(GEProperties.WOOD);
        this.block = block;
        BlockState defaultState = (BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_60734_().m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Y);
        for (BooleanProperty property : CHAINED) {
            defaultState = (BlockState)defaultState.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(defaultState);
        GERenderTypeHandler.setRenderType(this, GERenderTypeHandler.RenderTypeSkeleton.CUTOUT);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case X: {
                return SHAPE_X;
            }
            case Y: {
                return SHAPE_Y;
            }
        }
        return SHAPE_Z;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getRelevantState(context.m_43725_(), context.m_8083_(), context.m_43719_().m_122434_());
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockState newState = this.getRelevantState(worldIn, pos, (Direction.Axis)state.m_61143_(AXIS));
        if (!newState.equals(state)) {
            worldIn.m_46597_(pos, newState);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, AXIS});
        for (BooleanProperty property : CHAINED) {
            builder.m_61104_(new Property[]{property});
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, Level world, BlockPos pos, Player player, ItemStack stack, ToolType toolType) {
        if (toolType == ToolType.AXE) {
            return this.block != null ? WoodPostBlock.transferAllBlockStates(state, this.block.m_49966_()) : null;
        }
        return super.getToolModifiedState(state, world, pos, player, stack, toolType);
    }

    private BlockState getRelevantState(Level world, BlockPos pos, Direction.Axis axis) {
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_(AXIS, (Comparable)axis);
        for (Direction direction : Direction.values()) {
            BlockState sideState;
            if (direction.m_122434_() == axis || (!((sideState = world.m_8055_(pos.m_142300_(direction))).m_60734_() instanceof ChainBlock) || sideState.m_61143_((Property)BlockStateProperties.f_61365_) != direction.m_122434_()) && (direction != Direction.DOWN || !(sideState.m_60734_() instanceof LanternBlock) || !((Boolean)sideState.m_61143_((Property)LanternBlock.f_153459_)).booleanValue())) continue;
            BooleanProperty property = CHAINED[direction.ordinal()];
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static BlockState transferAllBlockStates(BlockState initial, BlockState after) {
        BlockState block = after;
        for (Property property : initial.m_60734_().m_49965_().m_61092_()) {
            if (!after.m_61138_(property)) continue;
            initial.m_61143_(property);
            block = (BlockState)block.m_61124_(property, initial.m_61143_(property));
        }
        return block;
    }
}

