/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.common.item;

import com.hydroartdragon3.genericeco.common.entity.GEBoatEntity;
import com.hydroartdragon3.genericeco.core.misc.GEProperties;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GEBoatItem
extends BoatItem {
    private final String woodType;

    public GEBoatItem(String woodType) {
        super(null, GEProperties.BOAT);
        this.woodType = woodType;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new GEDispenserBoatBehavior(woodType));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        BlockHitResult raytraceresult = GEBoatItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (raytraceresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 vector3d = playerIn.m_20252_(1.0f);
        List list = worldIn.m_6249_((Entity)playerIn, playerIn.m_142469_().m_82369_(vector3d.m_82490_(5.0)).m_82400_(1.0), EntitySelector.f_20408_.and(Entity::m_5829_));
        if (!list.isEmpty()) {
            Vec3 vector3d1 = playerIn.m_20299_(1.0f);
            for (Entity entity : list) {
                AABB axisalignedbb = entity.m_142469_().m_82400_((double)entity.m_6143_());
                if (!axisalignedbb.m_82390_(vector3d1)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
            GEBoatEntity boatEntity = new GEBoatEntity(worldIn, raytraceresult.m_82450_().f_82479_, raytraceresult.m_82450_().f_82480_, raytraceresult.m_82450_().f_82481_);
            boatEntity.setWoodType(this.woodType);
            boatEntity.m_146922_(playerIn.m_146908_());
            if (!worldIn.m_45756_((Entity)boatEntity, boatEntity.m_142469_().m_82400_(-0.1))) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!worldIn.f_46443_) {
                worldIn.m_7967_((Entity)boatEntity);
                if (!playerIn.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    static class GEDispenserBoatBehavior
    extends DefaultDispenseItemBehavior {
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
        private final String woodType;

        public GEDispenserBoatBehavior(String woodType) {
            this.woodType = woodType;
        }

        public ItemStack m_7498_(BlockSource iBlockSource, ItemStack stack) {
            double adjustY;
            Direction direction = (Direction)iBlockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel world = iBlockSource.m_7727_();
            double x = iBlockSource.m_7096_() + (double)((float)direction.m_122429_() * 1.125f);
            double y = iBlockSource.m_7098_() + (double)((float)direction.m_122430_() * 1.125f);
            double z = iBlockSource.m_7094_() + (double)((float)direction.m_122431_() * 1.125f);
            BlockPos pos = iBlockSource.m_7961_().m_142300_(direction);
            if (world.m_6425_(pos).m_76153_((Tag)FluidTags.f_13131_)) {
                adjustY = 1.0;
            } else {
                if (!world.m_8055_(pos).m_60795_() || !world.m_6425_(pos.m_7495_()).m_76153_((Tag)FluidTags.f_13131_)) {
                    return this.defaultDispenseItemBehavior.m_6115_(iBlockSource, stack);
                }
                adjustY = 0.0;
            }
            GEBoatEntity boat = new GEBoatEntity((Level)world, x, y + adjustY, z);
            boat.setWoodType(this.woodType);
            boat.m_146922_(direction.m_122435_());
            world.m_7967_((Entity)boat);
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource iBlockSource) {
            iBlockSource.m_7727_().m_46796_(1000, iBlockSource.m_7961_(), 0);
        }
    }
}

