/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.common.world.surfacebuilders;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.DoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilderBaseConfiguration;

public class IslandSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderBaseConfiguration> {
    private static final BlockState STONE = Blocks.f_50069_.m_49966_();
    protected final BlockState WATER = Blocks.f_49990_.m_49966_();
    protected int seaLevel;
    private final DoubleFunction<BlockState> sand;

    public IslandSurfaceBuilder(Codec<SurfaceBuilderBaseConfiguration> codec, int seaLevel, DoubleFunction<BlockState> sand) {
        super(codec);
        this.seaLevel = seaLevel;
        this.sand = sand;
    }

    public void apply(Random random, ChunkAccess chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, int p_164223_, long seed, SurfaceBuilderBaseConfiguration config) {
        int xLocal = x & 0xF;
        int zLocal = z & 0xF;
        BlockState sandToPlace = this.sand.apply(noise);
        int thickness = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int run = 0;
        boolean beach = false;
        boolean underwater = false;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(xLocal, 0, zLocal);
        for (int y = startHeight; y >= 0; --y) {
            pos.m_122178_(xLocal, y, zLocal);
            BlockState chunkBlock = chunk.m_8055_((BlockPos)pos);
            if (chunkBlock == STONE && y < 255) {
                BlockState toSet = STONE;
                if (chunk.m_8055_(pos.m_7494_()).m_60795_()) {
                    beach = y < seaLevel + 3;
                    toSet = beach ? sandToPlace : config.m_6743_();
                } else if (chunk.m_8055_(pos.m_7494_()) == this.WATER || run < thickness && underwater) {
                    underwater = true;
                    if (y > seaLevel - 15) {
                        beach = true;
                        toSet = sandToPlace;
                    } else {
                        toSet = config.m_6744_();
                    }
                } else if (y > seaLevel - 15) {
                    if (beach) {
                        toSet = sandToPlace;
                    } else if (run < thickness) {
                        toSet = config.m_6744_();
                    }
                }
                chunk.m_6978_((BlockPos)pos, toSet, false);
                ++run;
                continue;
            }
            run = 0;
            beach = false;
            underwater = false;
        }
    }
}

