/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.common.world.surfacebuilders.base;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilderBaseConfiguration;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilderConfiguration;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class LushBadlandsBaseSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderBaseConfiguration> {
    private static final BlockState WHITE_TERRACOTTA = Blocks.f_50287_.m_49966_();
    private static final BlockState ORANGE_TERRACOTTA = Blocks.f_50295_.m_49966_();
    private static final BlockState TERRACOTTA = Blocks.f_50290_.m_49966_();
    private static final BlockState YELLOW_TERRACOTTA = Blocks.f_50292_.m_49966_();
    private static final BlockState BROWN_TERRACOTTA = Blocks.f_50298_.m_49966_();
    private static final BlockState RED_TERRACOTTA = Blocks.f_50296_.m_49966_();
    private static final BlockState LIGHT_GRAY_TERRACOTTA = Blocks.f_50295_.m_49966_();
    protected BlockState[] clayBands;
    protected long seed;
    protected PerlinSimplexNoise pillarNoise;
    protected PerlinSimplexNoise pillarRoofNoise;
    protected PerlinSimplexNoise clayBandsOffsetNoise;

    public LushBadlandsBaseSurfaceBuilder(Codec<SurfaceBuilderBaseConfiguration> codec) {
        super(codec);
    }

    public void apply(Random random, ChunkAccess chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, int p_164223_, long seed, SurfaceBuilderBaseConfiguration config) {
        int i = x & 0xF;
        int j = z & 0xF;
        BlockState blockstate = WHITE_TERRACOTTA;
        SurfaceBuilderConfiguration surfaceConfig = biome.m_47536_().m_47824_();
        BlockState underMaterial = surfaceConfig.m_6744_();
        BlockState topMaterial = surfaceConfig.m_6743_();
        BlockState underWaterMaterial = underMaterial;
        int k = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        boolean flag = Math.cos(noise / 3.0 * Math.PI) > 0.0;
        int l = -1;
        boolean flag1 = false;
        int i1 = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j1 = startHeight; j1 >= 0; --j1) {
            if (i1 >= 15) continue;
            mutable.m_122178_(i, j1, j);
            BlockState blockstate4 = chunk.m_8055_((BlockPos)mutable);
            if (blockstate4.m_60795_()) {
                l = -1;
                continue;
            }
            if (!blockstate4.m_60713_(defaultBlock.m_60734_())) continue;
            if (l == -1) {
                flag1 = false;
                if (k <= 0) {
                    blockstate = Blocks.f_50016_.m_49966_();
                    underWaterMaterial = defaultBlock;
                } else if (j1 >= seaLevel - 4 && j1 <= seaLevel + 1) {
                    blockstate = WHITE_TERRACOTTA;
                    underWaterMaterial = underMaterial;
                }
                if (j1 < seaLevel && (blockstate == null || blockstate.m_60795_())) {
                    blockstate = defaultFluid;
                }
                l = k + Math.max(0, j1 - seaLevel);
                if (j1 >= seaLevel - 1) {
                    if (j1 > seaLevel + 3 + k) {
                        BlockState blockstate5 = j1 >= 64 && j1 <= 127 ? (flag ? TERRACOTTA : this.getBand(x, j1, z)) : ORANGE_TERRACOTTA;
                        chunk.m_6978_((BlockPos)mutable, blockstate5, false);
                    } else {
                        chunk.m_6978_((BlockPos)mutable, topMaterial, false);
                        flag1 = true;
                    }
                } else {
                    chunk.m_6978_((BlockPos)mutable, underWaterMaterial, false);
                    Block block = underWaterMaterial.m_60734_();
                    if (block == Blocks.f_50287_ || block == Blocks.f_50288_ || block == Blocks.f_50289_ || block == Blocks.f_50290_ || block == Blocks.f_50291_ || block == Blocks.f_50292_ || block == Blocks.f_50293_ || block == Blocks.f_50294_ || block == Blocks.f_50295_ || block == Blocks.f_50296_ || block == Blocks.f_50297_ || block == Blocks.f_50298_ || block == Blocks.f_50299_ || block == Blocks.f_50300_ || block == Blocks.f_50301_ || block == Blocks.f_50302_) {
                        chunk.m_6978_((BlockPos)mutable, ORANGE_TERRACOTTA, false);
                    }
                }
            } else if (l > 0) {
                --l;
                if (flag1) {
                    chunk.m_6978_((BlockPos)mutable, ORANGE_TERRACOTTA, false);
                } else {
                    chunk.m_6978_((BlockPos)mutable, this.getBand(x, j1, z), false);
                }
            }
            ++i1;
        }
    }

    public void m_6190_(long p_205548_1_) {
        if (this.seed != p_205548_1_ || this.clayBands == null) {
            this.generateBands(p_205548_1_);
        }
        if (this.seed != p_205548_1_ || this.pillarNoise == null || this.pillarRoofNoise == null) {
            WorldgenRandom worldgenRandom = new WorldgenRandom(p_205548_1_);
            this.pillarNoise = new PerlinSimplexNoise((RandomSource)worldgenRandom, IntStream.rangeClosed(-3, 0));
            this.pillarRoofNoise = new PerlinSimplexNoise((RandomSource)worldgenRandom, (List)ImmutableList.of((Object)0));
        }
        this.seed = p_205548_1_;
    }

    protected void generateBands(long p_215430_1_) {
        this.clayBands = new BlockState[64];
        Arrays.fill(this.clayBands, TERRACOTTA);
        WorldgenRandom worldgenRandom = new WorldgenRandom(p_215430_1_);
        this.clayBandsOffsetNoise = new PerlinSimplexNoise((RandomSource)worldgenRandom, (List)ImmutableList.of((Object)0));
        for (int l1 = 0; l1 < 64; ++l1) {
            if ((l1 += worldgenRandom.nextInt(5) + 1) >= 64) continue;
            this.clayBands[l1] = ORANGE_TERRACOTTA;
        }
        int i2 = worldgenRandom.nextInt(4) + 2;
        for (int i = 0; i < i2; ++i) {
            int j = worldgenRandom.nextInt(3) + 1;
            int k = worldgenRandom.nextInt(64);
            for (int l = 0; k + l < 64 && l < j; ++l) {
                this.clayBands[k + l] = YELLOW_TERRACOTTA;
            }
        }
        int j2 = worldgenRandom.nextInt(4) + 2;
        for (int k2 = 0; k2 < j2; ++k2) {
            int i3 = worldgenRandom.nextInt(3) + 2;
            int l3 = worldgenRandom.nextInt(64);
            for (int i1 = 0; l3 + i1 < 64 && i1 < i3; ++i1) {
                this.clayBands[l3 + i1] = BROWN_TERRACOTTA;
            }
        }
        int l2 = worldgenRandom.nextInt(4) + 2;
        for (int j3 = 0; j3 < l2; ++j3) {
            int i4 = worldgenRandom.nextInt(3) + 1;
            int k4 = worldgenRandom.nextInt(64);
            for (int j1 = 0; k4 + j1 < 64 && j1 < i4; ++j1) {
                this.clayBands[k4 + j1] = RED_TERRACOTTA;
            }
        }
        int k3 = worldgenRandom.nextInt(3) + 3;
        int j4 = 0;
        for (int l4 = 0; l4 < k3; ++l4) {
            boolean i5 = true;
            j4 += worldgenRandom.nextInt(16) + 4;
            for (int k1 = 0; j4 + k1 < 64 && k1 < 1; ++k1) {
                this.clayBands[j4 + k1] = WHITE_TERRACOTTA;
                if (j4 + k1 > 1 && worldgenRandom.nextBoolean()) {
                    this.clayBands[j4 + k1 - 1] = LIGHT_GRAY_TERRACOTTA;
                }
                if (j4 + k1 >= 63 || !worldgenRandom.nextBoolean()) continue;
                this.clayBands[j4 + k1 + 1] = LIGHT_GRAY_TERRACOTTA;
            }
        }
    }

    protected BlockState getBand(int p_215431_1_, int p_215431_2_, int p_215431_3_) {
        int i = (int)Math.round(this.clayBandsOffsetNoise.m_75449_((double)p_215431_1_ / 512.0, (double)p_215431_3_ / 512.0, false) * 2.0);
        return this.clayBands[(p_215431_2_ + i + 64) % 64];
    }
}

