/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.core.misc;

import com.hydroartdragon3.genericeco.GEConfig;
import com.hydroartdragon3.genericeco.api.GEBiomes;
import com.hydroartdragon3.genericeco.common.world.ModConfiguredFeatures;
import com.hydroartdragon3.genericeco.common.world.ModVanillaBiomeFeatures;
import com.hydroartdragon3.genericeco.init.ModSurfaceBuilders;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="genericeco")
public class GEBiomeLoadingEvent {
    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation biome = event.getName();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (event.getCategory() == Biome.BiomeCategory.FOREST) {
            generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.FOREST_SPROUTS_2);
        }
        if (((Boolean)GEConfig.COMMON.addVanillaBiomesFeatures.get()).booleanValue()) {
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48215_, Biomes.f_48216_)) {
                ModVanillaBiomeFeatures.addMushroomFieldsExtraDecoration((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48208_, Biomes.f_48212_)) {
                ModVanillaBiomeFeatures.addRiverExtraDecoration((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48217_, Biomes.f_48148_)) {
                ModVanillaBiomeFeatures.addBeachExtraDecoration((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, GEBiomes.gravel_beach, GEBiomes.snowy_gravel_beach)) {
                generation.m_47851_(ModSurfaceBuilders.CONFIGURED_COLD_LAKE);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48207_, Biomes.f_48181_, GEBiomes.lush_swamp, GEBiomes.lush_swamp_hills)) {
                ModVanillaBiomeFeatures.addSwampExtraDecoration((BiomeGenerationSettings.Builder)generation);
                ModVanillaBiomeFeatures.addSwampExtraTrees((BiomeGenerationSettings.Builder)generation);
                ModVanillaBiomeFeatures.swampSpawns((MobSpawnSettings.Builder)spawns);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, GEBiomes.swamp_marshes, GEBiomes.lush_swamp_marshes)) {
                ModVanillaBiomeFeatures.addSwampExtraDecoration((BiomeGenerationSettings.Builder)generation);
                ModVanillaBiomeFeatures.swampSpawns((MobSpawnSettings.Builder)spawns);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_48192_, Biomes.f_48193_, GEBiomes.lush_savanna, GEBiomes.lush_savanna_plateau, GEBiomes.baobab_savanna, GEBiomes.baobab_plateau, GEBiomes.marula_savanna, GEBiomes.marula_plateau)) {
                ModVanillaBiomeFeatures.addSavannaExtraDecoration((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_48192_, Biomes.f_48193_, GEBiomes.lush_savanna, GEBiomes.lush_savanna_plateau)) {
                ModVanillaBiomeFeatures.addSavannaExtraTrees((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48149_, Biomes.f_48150_, Biomes.f_48185_, Biomes.f_48186_, GEBiomes.snowy_birch_forest, GEBiomes.snowy_birch_forest_hills)) {
                ModVanillaBiomeFeatures.addBirchForestExtraVegetation((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48205_, Biomes.f_48219_, GEBiomes.snowy_forest, GEBiomes.snowy_wooded_hills, GEBiomes.mixed_forest, GEBiomes.mixed_wooded_hills)) {
                ModVanillaBiomeFeatures.addForestExtraVegetation((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48222_, Biomes.f_48224_, Biomes.f_48223_, Biomes.f_48198_, Biomes.f_48197_, Biomes.f_48183_, Biomes.f_48184_)) {
                ModVanillaBiomeFeatures.addJungleExtraDecoration((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48151_, Biomes.f_48187_)) {
                ModVanillaBiomeFeatures.addDarkForestExtraDecoration((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48204_, Biomes.f_48156_, Biomes.f_48178_, Biomes.f_48191_, Biomes.f_48221_)) {
                ModVanillaBiomeFeatures.addExtremeHillsExtraDecoration((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48202_)) {
                generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.PLAINS_FLOWERS_PATCH);
                ModVanillaBiomeFeatures.addPlainsExtraTrees((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48206_, Biomes.f_48220_, Biomes.f_48180_, Biomes.f_48152_, Biomes.f_48153_, Biomes.f_48153_, Biomes.f_48188_)) {
                ModVanillaBiomeFeatures.addTaigaExtraDecoration((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48159_, Biomes.f_48161_, Biomes.f_48160_, Biomes.f_48194_, Biomes.f_48196_, Biomes.f_48195_)) {
                ModVanillaBiomeFeatures.addSavannaExtraDecoration((BiomeGenerationSettings.Builder)generation);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48203_, Biomes.f_48218_, Biomes.f_48177_, GEBiomes.red_desert, GEBiomes.red_desert_hills, GEBiomes.red_desert_lakes)) {
                ModVanillaBiomeFeatures.addDesertExtraVegetation((BiomeGenerationSettings.Builder)generation);
            }
        }
        if (((Boolean)GEConfig.COMMON.shouldDangerousBlocksSpawn.get()).booleanValue()) {
            if (GEBiomeLoadingEvent.matchesKeys(biome, GEBiomes.autumnal_thornlands)) {
                generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.THORNY_BUSH_15);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, GEBiomes.dryland, GEBiomes.dry_wildlands, GEBiomes.xeric_shrubland, GEBiomes.xeric_thicket, GEBiomes.autumnal_valley, GEBiomes.thicket, GEBiomes.thicket_hills, GEBiomes.brushland, GEBiomes.dense_brushland, GEBiomes.chaparral, GEBiomes.chaparral_mountains, GEBiomes.outback, GEBiomes.outback_bushland, GEBiomes.scrubland, GEBiomes.dense_scrubland)) {
                generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.THORNY_BUSH_5);
            }
            if (event.getCategory() == Biome.BiomeCategory.FOREST || event.getCategory() == Biome.BiomeCategory.TAIGA) {
                generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.POISON_IVY_5);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, GEBiomes.quagmire, GEBiomes.mire, GEBiomes.wooded_mire, GEBiomes.sinister_morass)) {
                generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.QUAGMIRE_PATCH_EXTRA);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, GEBiomes.dark_swampland, GEBiomes.dark_swampland_marshes, GEBiomes.dark_swampland_hills, GEBiomes.lush_swamp, GEBiomes.lush_swamp_hills, GEBiomes.lush_swamp_marshes, Biomes.f_48207_, Biomes.f_48181_, GEBiomes.swamp_marshes, GEBiomes.wetland, GEBiomes.wetland_forest, GEBiomes.bayou_glade, GEBiomes.fen, GEBiomes.wooded_fen, GEBiomes.mangrove, GEBiomes.muskeg, GEBiomes.snowy_muskeg, GEBiomes.bog, GEBiomes.berry_bog, GEBiomes.mushroom_bog)) {
                generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.QUAGMIRE_PATCH_NORMAL);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48177_, GEBiomes.mangrove, GEBiomes.wooded_estuary)) {
                generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.QUICKSAND_PATCH_EXTRA);
            }
            if (GEBiomeLoadingEvent.matchesKeys(biome, Biomes.f_48217_, Biomes.f_48203_, GEBiomes.brushland)) {
                generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.QUICKSAND_PATCH_NORMAL);
            }
        }
    }

    public static boolean matchesKeys(ResourceLocation loc, ResourceKey<?> ... keys) {
        for (ResourceKey<?> key : keys) {
            if (!key.m_135782_().equals((Object)loc)) continue;
            return true;
        }
        return false;
    }
}

