/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.core.mixin;

import com.hydroartdragon3.genericeco.core.util.GEBiomeReference;
import com.hydroartdragon3.genericeco.core.util.GEBiomeVariants;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.biome.Biomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraft.world.level.newbiome.layer.BiomeEdgeLayer;
import net.minecraft.world.level.newbiome.layer.Layers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeEdgeLayer.class})
public class EdgeBiomeLayerMixin {
    private static final int WARM_OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48166_)));
    private static final int LUKEWARM_OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48167_)));
    private static final int OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48174_)));
    private static final int COLD_OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48168_)));
    private static final int FROZEN_OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48211_)));
    private static final int DEEP_WARM_OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48169_)));
    private static final int DEEP_LUKEWARM_OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48170_)));
    private static final int DEEP_OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48225_)));
    private static final int DEEP_COLD_OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48171_)));
    private static final int DEEP_FROZEN_OCEAN = BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_123013_(net.minecraft.world.level.biome.Biomes.f_48172_)));

    @Inject(at={@At(value="HEAD")}, method={"apply(Lnet/minecraft/world/level/newbiome/context/Context;IIIII)I"}, cancellable=true)
    private void applyEdge(Context random, int north, int west, int south, int east, int center, CallbackInfoReturnable<Integer> cir) {
        ResourceKey centerBiome = Biomes.m_127325_((int)center);
        ResourceKey<Biome> edgeKey = GEBiomeVariants.pickReplacement(random, (ResourceKey<Biome>)centerBiome, GEBiomeVariants.VariantType.EDGE);
        if (edgeKey != null && EdgeBiomeLayerMixin.isSurrounded(north, south, east, west, center) && EdgeBiomeLayerMixin.isDifferentBiome(north, south, east, west, center)) {
            cir.setReturnValue((Object)GEBiomeReference.getBiomeID(edgeKey));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"apply(Lnet/minecraft/world/level/newbiome/context/Context;IIIII)I"}, cancellable=true)
    private void applyWideEdge(Context random, int north, int west, int south, int east, int center, CallbackInfoReturnable<Integer> info) {
        ResourceKey centerBiome = Biomes.m_127325_((int)center);
        ResourceKey<Biome> edgeKey = GEBiomeVariants.pickReplacement(random, (ResourceKey<Biome>)centerBiome, GEBiomeVariants.VariantType.WIDE_EDGE);
        if (edgeKey != null && EdgeBiomeLayerMixin.neighborsOcean(north, west, south, east)) {
            int id = GEBiomeReference.getBiomeID(edgeKey);
            info.setReturnValue((Object)id);
        } else if (edgeKey != null && EdgeBiomeLayerMixin.isDifferentBiome(north, south, east, west, center)) {
            info.setReturnValue((Object)GEBiomeReference.getBiomeID(edgeKey));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"apply(Lnet/minecraft/world/level/newbiome/context/Context;IIIII)I"}, cancellable=true)
    private void applyCenter(Context context, int north, int west, int south, int east, int center, CallbackInfoReturnable<Integer> info) {
        ResourceKey key = Biomes.m_127325_((int)center);
        ResourceKey<Biome> centerKey = GEBiomeVariants.pickReplacement(context, (ResourceKey<Biome>)key, GEBiomeVariants.VariantType.CENTER);
        if (centerKey != null && EdgeBiomeLayerMixin.isSurrounded(north, south, east, west, center)) {
            info.setReturnValue((Object)GEBiomeReference.getBiomeID(centerKey));
        }
    }

    private static boolean isOceanBiome(int biome) {
        return biome == WARM_OCEAN || biome == LUKEWARM_OCEAN || biome == OCEAN || biome == COLD_OCEAN || biome == FROZEN_OCEAN || biome == DEEP_WARM_OCEAN || biome == DEEP_LUKEWARM_OCEAN || biome == DEEP_OCEAN || biome == DEEP_COLD_OCEAN || biome == DEEP_FROZEN_OCEAN;
    }

    private static boolean neighborsOcean(int north, int east, int south, int west) {
        return EdgeBiomeLayerMixin.isOceanBiome(north) || EdgeBiomeLayerMixin.isOceanBiome(east) || EdgeBiomeLayerMixin.isOceanBiome(south) || EdgeBiomeLayerMixin.isOceanBiome(west);
    }

    private static boolean isDifferentBiome(int north, int east, int south, int west, int center) {
        return EdgeBiomeLayerMixin.areNotSimilar(center, north) || EdgeBiomeLayerMixin.areNotSimilar(center, east) || EdgeBiomeLayerMixin.areNotSimilar(center, south) || EdgeBiomeLayerMixin.areNotSimilar(center, west);
    }

    private static boolean areNotSimilar(int mainBiome, int secondBiome) {
        if (mainBiome == secondBiome) {
            return false;
        }
        Int2IntMap parentChildMap = Layers.f_76719_;
        return parentChildMap.get(mainBiome) != secondBiome && parentChildMap.get(secondBiome) != mainBiome && parentChildMap.containsKey(mainBiome);
    }

    private static boolean isSurrounded(int northBiome, int westBiome, int southBiome, int eastBiome, int biome) {
        return northBiome == biome && westBiome == biome && southBiome == biome && eastBiome == biome;
    }
}

