/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.core.mixin;

import com.hydroartdragon3.genericeco.core.util.GEBiomeReference;
import com.hydroartdragon3.genericeco.core.util.GEBiomeVariants;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.minecraft.data.worldgen.biome.Biomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraft.world.level.newbiome.layer.RegionHillsLayer;
import net.minecraft.world.level.newbiome.layer.ShoreLayer;
import net.minecraftforge.common.BiomeDictionary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShoreLayer.class})
public class ShoreLayerMixin {
    @Inject(at={@At(value="HEAD")}, method={"apply(Lnet/minecraft/world/level/newbiome/context/Context;IIIII)I"}, cancellable=true)
    private void apply(Context context, int north, int west, int south, int east, int center, CallbackInfoReturnable<Integer> info) {
        ResourceKey key = Biomes.m_127325_((int)center);
        ResourceKey<Biome> shoreKey = GEBiomeVariants.pickReplacement(context, (ResourceKey<Biome>)key, GEBiomeVariants.VariantType.SHORE);
        if (shoreKey != null && ShoreLayerMixin.neighboursOcean(north, east, south, west)) {
            int id = GEBiomeReference.getBiomeID(shoreKey);
            if (id != -1) {
                info.setReturnValue((Object)id);
            }
        } else {
            int id;
            ResourceKey<Biome> edgeKey = GEBiomeVariants.pickReplacement(context, (ResourceKey<Biome>)key, GEBiomeVariants.VariantType.EDGE);
            if (edgeKey != null && ShoreLayerMixin.isEdge(north, east, south, west, center) && (id = GEBiomeReference.getBiomeID(edgeKey)) != -1) {
                info.setReturnValue((Object)id);
            }
        }
    }

    private static boolean neighboursOcean(int north, int east, int south, int west) {
        return ShoreLayerMixin.isOceanBiome(north) || ShoreLayerMixin.isOceanBiome(east) || ShoreLayerMixin.isOceanBiome(south) || ShoreLayerMixin.isOceanBiome(west);
    }

    private static boolean isOceanBiome(int id) {
        ResourceKey key = Biomes.m_127325_((int)id);
        return BiomeDictionary.getTypes((ResourceKey)key).contains(BiomeDictionary.Type.OCEAN);
    }

    private static boolean isEdge(int north, int east, int south, int west, int center) {
        return ShoreLayerMixin.areDissimilar(center, north) || ShoreLayerMixin.areDissimilar(center, east) || ShoreLayerMixin.areDissimilar(center, south) || ShoreLayerMixin.areDissimilar(center, west);
    }

    private static boolean areDissimilar(int mainBiomeId, int secondaryBiomeId) {
        if (mainBiomeId == secondaryBiomeId) {
            return false;
        }
        Int2IntMap parentChildMap = RegionHillsLayer.f_76831_;
        return parentChildMap.get(mainBiomeId) != secondaryBiomeId && parentChildMap.get(secondaryBiomeId) != mainBiomeId;
    }
}

