/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.core.util;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.newbiome.context.Context;

public class GEBiomeVariants {
    public static Random random = new Random();
    private static final Map<ResourceKey<Biome>, Entry> hillReplacements = new HashMap<ResourceKey<Biome>, Entry>();
    private static final Map<ResourceKey<Biome>, Entry> riverReplacements = new HashMap<ResourceKey<Biome>, Entry>();
    private static final Map<ResourceKey<Biome>, Entry> edgeReplacements = new HashMap<ResourceKey<Biome>, Entry>();
    private static final Map<ResourceKey<Biome>, Entry> wideEdgeReplacements = new HashMap<ResourceKey<Biome>, Entry>();
    private static final Map<ResourceKey<Biome>, Entry> centerReplacements = new HashMap<ResourceKey<Biome>, Entry>();
    private static final Map<ResourceKey<Biome>, Entry> shoreReplacements = new HashMap<ResourceKey<Biome>, Entry>();
    private static final Map<List<ResourceKey<Biome>>, Entry> edgeParents = new HashMap<List<ResourceKey<Biome>>, Entry>();
    private static final Map<ResourceKey<Biome>, WeightedEntryList> biomeReplacements = new HashMap<ResourceKey<Biome>, WeightedEntryList>();
    private static final EnumMap<VariantType, Map<ResourceKey<Biome>, Entry>> map = new EnumMap(VariantType.class);

    public static void addReplacement(ResourceKey<Biome> parent, ResourceKey<Biome> replacement, double chance, VariantType type) {
        if (type != VariantType.BIOME) {
            Map<ResourceKey<Biome>, Entry> current = map.get((Object)type);
            current.put(parent, Entry.of(replacement));
        } else {
            WeightedEntryList entries = biomeReplacements.computeIfAbsent(parent, k -> new WeightedEntryList());
            if (entries.entries.isEmpty()) {
                entries.add(parent, 1.0 - chance);
            }
            entries.add(replacement, chance);
        }
    }

    @Nullable
    public static ResourceKey<Biome> pickReplacement(Context random, ResourceKey<Biome> replacing, VariantType type) {
        if (type != VariantType.BIOME) {
            return map.get((Object)type).computeIfAbsent(replacing, k -> Entry.EMPTY).getReplacement();
        }
        WeightedEntryList entries = biomeReplacements.get(replacing);
        if (entries == null) {
            return null;
        }
        return entries.getReplacement(random);
    }

    static {
        map.put(VariantType.HILLS, hillReplacements);
        map.put(VariantType.RIVER, riverReplacements);
        map.put(VariantType.EDGE, edgeReplacements);
        map.put(VariantType.WIDE_EDGE, wideEdgeReplacements);
        map.put(VariantType.CENTER, centerReplacements);
        map.put(VariantType.SHORE, shoreReplacements);
    }

    public static enum VariantType {
        HILLS,
        BIOME,
        RIVER,
        EDGE,
        WIDE_EDGE,
        CENTER,
        SHORE;

    }

    private static class Entry
    implements IEntry {
        public static final Entry EMPTY = new Entry(null);
        private final ResourceKey<Biome> replacement;

        public Entry(ResourceKey<Biome> replacement) {
            this.replacement = replacement;
        }

        @Override
        public ResourceKey<Biome> getReplacement() {
            return this.replacement;
        }

        public static Entry of(ResourceKey<Biome> replacement) {
            return new Entry(replacement);
        }
    }

    private static class WeightedEntryList
    implements IEntry {
        private final List<WeightedEntry> entries = new ArrayList<WeightedEntry>();
        private double total = 0.0;

        public void add(ResourceKey<Biome> replacement, double weight) {
            this.total += weight;
            this.entries.add(new WeightedEntry(replacement, weight, this.total));
        }

        public double getTotal() {
            return this.total;
        }

        @Override
        public ResourceKey<Biome> getReplacement() {
            return null;
        }

        @Override
        public ResourceKey<Biome> getReplacement(Context random) {
            if (this.entries.size() == 1) {
                return this.entries.get(0).getReplacement();
            }
            return this.search((double)random.m_5826_(Integer.MAX_VALUE) * this.getTotal() / 2.147483647E9).getReplacement();
        }

        private WeightedEntry search(double target) {
            int min = 0;
            int max = this.entries.size();
            while (min < max) {
                int mid = max + min >>> 1;
                if (target < this.entries.get(mid).getCurrentTotal()) {
                    max = mid;
                    continue;
                }
                min = mid + 1;
            }
            return this.entries.get(min);
        }
    }

    private static class WeightedEntry
    implements IEntry {
        private final ResourceKey<Biome> replacement;
        private final double chance;
        private final double currentTotal;

        public WeightedEntry(ResourceKey<Biome> replacement, double chance, double currentTotal) {
            this.replacement = replacement;
            this.chance = chance;
            this.currentTotal = currentTotal;
        }

        @Override
        public ResourceKey<Biome> getReplacement() {
            return this.replacement;
        }

        public double getChance() {
            return this.chance;
        }

        public double getCurrentTotal() {
            return this.currentTotal;
        }
    }

    private static interface IEntry {
        public ResourceKey<Biome> getReplacement();

        default public ResourceKey<Biome> getReplacement(Context random) {
            return this.getReplacement();
        }
    }
}

