/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.core.util;

import com.google.common.collect.Lists;
import com.hydroartdragon3.genericeco.core.util.GEBiomeVariants;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.newbiome.context.Context;

public final class GESubBiomeUtil {
    private static final Map<ResourceKey<Biome>, WeightedNoiseList<ResourceKey<Biome>>> HILL_BIOME_MAP = new HashMap<ResourceKey<Biome>, WeightedNoiseList<ResourceKey<Biome>>>();
    public static final Int2ObjectMap<Biome> BIOME_TO_EDGE_LIST = new Int2ObjectArrayMap();

    public static void addEdgeBiome(ResourceKey<Biome> parent, ResourceKey<Biome> edge) {
        GEBiomeVariants.addReplacement(parent, edge, 1.0, GEBiomeVariants.VariantType.EDGE);
    }

    public static void addWideEdgeBiome(ResourceKey<Biome> parent, ResourceKey<Biome> edge) {
        GEBiomeVariants.addReplacement(parent, edge, 1.0, GEBiomeVariants.VariantType.WIDE_EDGE);
    }

    public static void addReplacingBiome(ResourceKey<Biome> replacing, ResourceKey<Biome> biome, double chance) {
        GEBiomeVariants.addReplacement(replacing, biome, chance, GEBiomeVariants.VariantType.BIOME);
    }

    public static void addShoreBiome(ResourceKey<Biome> parent, ResourceKey<Biome> shore) {
        GEBiomeVariants.addReplacement(parent, shore, 1.0, GEBiomeVariants.VariantType.SHORE);
    }

    public static void addRiverBiome(ResourceKey<Biome> parent, ResourceKey<Biome> river) {
        GEBiomeVariants.addReplacement(parent, river, 1.0, GEBiomeVariants.VariantType.RIVER);
    }

    public static void addCenterBiome(ResourceKey<Biome> parent, ResourceKey<Biome> biome) {
        GEBiomeVariants.addReplacement(parent, biome, 1.0, GEBiomeVariants.VariantType.CENTER);
    }

    @SafeVarargs
    public static synchronized void addHillBiome(ResourceKey<Biome> biome, Pair<ResourceKey<Biome>, Integer> ... hills) {
        WeightedNoiseList list = HILL_BIOME_MAP.computeIfAbsent(biome, key -> new WeightedNoiseList());
        for (Pair<ResourceKey<Biome>, Integer> hill : hills) {
            list.add((ResourceKey)hill.getFirst(), (Integer)hill.getSecond());
        }
    }

    @Nullable
    public static ResourceKey<Biome> getHillBiome(ResourceKey<Biome> biome, Context random) {
        WeightedNoiseList<ResourceKey<Biome>> list = HILL_BIOME_MAP.get(biome);
        return list != null ? list.get(random) : null;
    }

    public static final class WeightedNoiseList<T> {
        private final List<Pair<T, Integer>> entries = Lists.newArrayList();
        private int totalWeight;

        public void add(@Nonnull T value, int weight) {
            this.totalWeight += weight;
            this.entries.add(Pair.of(value, (Object)weight));
        }

        @Nonnull
        public T get(Context random) {
            Object value;
            Pair<T, Integer> entry;
            Iterator<Pair<T, Integer>> iterator = this.entries.iterator();
            int randomTotal = random.m_5826_(this.totalWeight);
            do {
                entry = iterator.next();
                value = entry.getFirst();
            } while ((randomTotal -= ((Integer)entry.getSecond()).intValue()) >= 0);
            return (T)value;
        }

        @Nonnull
        public List<Pair<T, Integer>> getEntries() {
            return this.entries;
        }
    }
}

