/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.core.util;

import java.util.List;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;

public class GETradeUtil {
    public static final int NOVICE = 1;
    public static final int APPRENTICE = 2;
    public static final int JOURNEYMAN = 3;
    public static final int EXPERT = 4;
    public static final int MASTER = 5;

    public static void addVillagerTrades(VillagerTradesEvent event, int level, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            ((List)event.getTrades().get(level)).add(trade);
        }
    }

    public static void addVillagerTrades(VillagerTradesEvent event, VillagerProfession profession, int level, VillagerTrades.ItemListing ... trades) {
        if (event.getType() == profession) {
            GETradeUtil.addVillagerTrades(event, level, trades);
        }
    }

    public static void addWandererTradeCommon(WandererTradesEvent event, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            event.getGenericTrades().add(trade);
        }
    }

    public static void addWandererTradeRare(WandererTradesEvent event, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            event.getRareTrades().add(trade);
        }
    }

    public static class GEItemForEmeraldTrade
    extends BasicTrade {
        public GEItemForEmeraldTrade(ItemStack input, ItemStack input2, ItemStack output, int maxTrades, int xp, float priceMultiplier) {
            super(input, input2, output, maxTrades, xp, priceMultiplier);
        }

        public GEItemForEmeraldTrade(Item input, int itemCount, int outputCount, int maxTrades, int xp, float priceMultiplier) {
            this(new ItemStack((ItemLike)input, itemCount), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_, outputCount), maxTrades, xp, priceMultiplier);
        }

        public GEItemForEmeraldTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp) {
            this(input, inputCount, emeraldCount, maxTrades, xp, 0.15f);
        }
    }

    public static class GEEmeraldForItemTrade
    extends BasicTrade {
        public GEEmeraldForItemTrade(ItemStack input, ItemStack input2, ItemStack output, int maxTrades, int xp, float priceMultiplier) {
            super(input, input2, output, maxTrades, xp, priceMultiplier);
        }

        public GEEmeraldForItemTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp, float priceMultiplier) {
            this(new ItemStack((ItemLike)Items.f_42616_, emeraldCount), ItemStack.f_41583_, new ItemStack((ItemLike)output, outputCount), maxTrades, xp, priceMultiplier);
        }

        public GEEmeraldForItemTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp) {
            this(emeraldCount, output, outputCount, maxTrades, xp, 0.15f);
        }
    }
}

