/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.core.util.registry;

import com.hydroartdragon3.genericeco.api.GEBlocks;
import com.hydroartdragon3.genericeco.common.block.GEBasicPlant;
import com.hydroartdragon3.genericeco.common.block.GEDeathlyBloomBlock;
import com.hydroartdragon3.genericeco.common.block.GEFlowerLikeBlock;
import com.hydroartdragon3.genericeco.common.block.GESandSapling;
import com.hydroartdragon3.genericeco.common.block.GETallFlowerBlock;
import com.hydroartdragon3.genericeco.common.block.GEWaterDoubleFlowerBlock;
import com.hydroartdragon3.genericeco.common.block.GEWaterloggableSapling;
import com.hydroartdragon3.genericeco.common.block.HedgeBlock;
import com.hydroartdragon3.genericeco.common.block.LeafCarpetBlock;
import com.hydroartdragon3.genericeco.common.block.VerticalSlabBlock;
import com.hydroartdragon3.genericeco.common.block.WoodPostBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEBookshelfBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEChestBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEFenceBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEFenceGateBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEFlowerPotBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GELadderBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GELeavesBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GELogBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEPlanksBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GESaplingBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GESignBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEStrippedLogBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEStrippedWoodBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GETrappedChestBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEWallSignBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEWoodBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEWoodButtonBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEWoodenDoorBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEWoodenPressurePlateBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEWoodenSlabBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEWoodenStairsBlock;
import com.hydroartdragon3.genericeco.common.block.wood.GEWoodenTrapDoorBlock;
import com.hydroartdragon3.genericeco.common.item.GEChestItem;
import com.hydroartdragon3.genericeco.common.item.GETrappedChestItem;
import com.hydroartdragon3.genericeco.core.misc.GECreativeTab;
import com.hydroartdragon3.genericeco.core.misc.GEProperties;
import com.hydroartdragon3.genericeco.init.ModVanillaCompat;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GEBlockRegistryUtil {
    public static Block[] collectBlocks(Class<?> blockClass) {
        return (Block[])ForgeRegistries.BLOCKS.getValues().stream().filter(blockClass::isInstance).toArray(Block[]::new);
    }

    public static Block createBlock(Block block, String name) {
        BlockItem itemBlock = new BlockItem(block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name);
        itemBlock.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        return block;
    }

    public static Block createBlockNoItem(Block block, String name) {
        block.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        return block;
    }

    public static Block createBlockNoGroup(Block block, String name) {
        BlockItem itemBlock = new BlockItem(block, new Item.Properties().m_41491_(null));
        block.setRegistryName(name);
        itemBlock.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        return block;
    }

    public static Block createOrganicBlock(Block block, String name) {
        BlockItem itemBlock = new BlockItem(block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name);
        itemBlock.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerCompostable(0.3f, (ItemLike)itemBlock);
        return block;
    }

    public static Block createPottedFlower(String name) {
        GEFlowerLikeBlock block = new GEFlowerLikeBlock();
        BlockItem blockItem = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name);
        blockItem.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
        ModVanillaCompat.registerCompostable(0.65f, (ItemLike)blockItem);
        GEFlowerPotBlock pottedFlower = new GEFlowerPotBlock((Block)block);
        GEBlockRegistryUtil.createBlockNoItem((Block)pottedFlower, "potted_" + name);
        return block;
    }

    public static Block createFlowerBlock(String name) {
        GEBasicPlant block = new GEBasicPlant();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name);
        itemBlock.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerCompostable(0.65f, (ItemLike)itemBlock);
        return block;
    }

    public static Block createTallFlowerBlock(String name) {
        GETallFlowerBlock block = new GETallFlowerBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name);
        itemBlock.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerCompostable(0.65f, (ItemLike)itemBlock);
        return block;
    }

    public static Block createTallWaterFlowerBlock(String name) {
        GEWaterDoubleFlowerBlock block = new GEWaterDoubleFlowerBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name);
        itemBlock.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerCompostable(0.65f, (ItemLike)itemBlock);
        return block;
    }

    public static Block createDeathlyBloomFlower(String name) {
        GEDeathlyBloomBlock block = new GEDeathlyBloomBlock(MobEffects.f_19615_);
        BlockItem blockItem = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name);
        blockItem.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
        ModVanillaCompat.registerCompostable(0.65f, (ItemLike)blockItem);
        GEFlowerPotBlock pottedFlower = new GEFlowerPotBlock((Block)block);
        GEBlockRegistryUtil.createBlockNoItem((Block)pottedFlower, "potted_" + name);
        return block;
    }

    public static Block createLeaves(String name) {
        GELeavesBlock block = new GELeavesBlock();
        BlockItem blockItem = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_leaves");
        blockItem.setRegistryName(name + "_leaves");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
        ModVanillaCompat.registerCompostable(0.3f, (ItemLike)blockItem);
        ModVanillaCompat.registerFlammable((Block)block, 30, 60);
        return block;
    }

    public static Block createSapling(AbstractTreeGrower tree, String name) {
        GESaplingBlock block = new GESaplingBlock(tree);
        BlockItem blockItem = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_sapling");
        blockItem.setRegistryName(name + "_sapling");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
        ModVanillaCompat.registerCompostable(0.3f, (ItemLike)blockItem);
        GEFlowerPotBlock pottedSapling = new GEFlowerPotBlock((Block)block);
        GEBlockRegistryUtil.createBlockNoItem((Block)pottedSapling, "potted_" + name + "_sapling");
        return block;
    }

    public static Block createSandSapling(AbstractTreeGrower tree, String name) {
        GESandSapling block = new GESandSapling(tree);
        BlockItem blockItem = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_sapling");
        blockItem.setRegistryName(name + "_sapling");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
        ModVanillaCompat.registerCompostable(0.3f, (ItemLike)blockItem);
        GEFlowerPotBlock pottedSapling = new GEFlowerPotBlock((Block)block);
        GEBlockRegistryUtil.createBlockNoItem((Block)pottedSapling, "potted_" + name + "_sapling");
        return block;
    }

    public static Block createWaterSapling(AbstractTreeGrower tree, String name) {
        GEWaterloggableSapling block = new GEWaterloggableSapling(tree);
        BlockItem blockItem = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_sapling");
        blockItem.setRegistryName(name + "_sapling");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
        ModVanillaCompat.registerCompostable(0.3f, (ItemLike)blockItem);
        GEFlowerPotBlock pottedSapling = new GEFlowerPotBlock((Block)block);
        GEBlockRegistryUtil.createBlockNoItem((Block)pottedSapling, "potted_" + name + "_sapling");
        return block;
    }

    public static Block createLog(MaterialColor topColor, MaterialColor sideColor, String name) {
        GELogBlock block = new GELogBlock(topColor, sideColor);
        BlockItem blockItem = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_log");
        blockItem.setRegistryName(name + "_log");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
        ModVanillaCompat.registerFlammable((Block)block, 5, 5);
        return block;
    }

    public static Block createFullLog(String name) {
        GEWoodBlock block = new GEWoodBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_wood");
        itemBlock.setRegistryName(name + "_wood");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable((Block)block, 5, 5);
        return block;
    }

    public static Block createStrippedLog(MaterialColor topColor, MaterialColor sideColor, String name) {
        GEStrippedLogBlock block = new GEStrippedLogBlock(topColor, sideColor);
        BlockItem blockItem = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName("stripped_" + name + "_log");
        blockItem.setRegistryName("stripped_" + name + "_log");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
        ModVanillaCompat.registerFlammable((Block)block, 5, 5);
        return block;
    }

    public static Block createStrippedFullLog(String name) {
        GEStrippedWoodBlock block = new GEStrippedWoodBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName("stripped_" + name + "_wood");
        itemBlock.setRegistryName("stripped_" + name + "_wood");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable((Block)block, 5, 5);
        return block;
    }

    public static Block createPlanks(String name) {
        GEPlanksBlock block = new GEPlanksBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_planks");
        itemBlock.setRegistryName(name + "_planks");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable(block, 5, 20);
        return block;
    }

    public static Block createWoodSlab(String name) {
        GEWoodenSlabBlock block = new GEWoodenSlabBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_slab");
        itemBlock.setRegistryName(name + "_slab");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable((Block)block, 5, 20);
        return block;
    }

    public static Block createWoodStairs(String name) {
        GEWoodenStairsBlock block = new GEWoodenStairsBlock(GEBlocks.alder_planks.m_49966_());
        BlockItem blockItem = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_stairs");
        blockItem.setRegistryName(name + "_stairs");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
        return block;
    }

    public static Block createWoodDoor(String name) {
        GEWoodenDoorBlock block = new GEWoodenDoorBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_door");
        itemBlock.setRegistryName(name + "_door");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        return block;
    }

    public static Block createWoodTrapdoor(String name) {
        GEWoodenTrapDoorBlock block = new GEWoodenTrapDoorBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_trapdoor");
        itemBlock.setRegistryName(name + "_trapdoor");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        return block;
    }

    public static Block createWoodFence(String name) {
        GEFenceBlock block = new GEFenceBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_fence");
        itemBlock.setRegistryName(name + "_fence");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable((Block)block, 5, 20);
        return block;
    }

    public static Block createWoodFenceGate(String name) {
        GEFenceGateBlock block = new GEFenceGateBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_fence_gate");
        itemBlock.setRegistryName(name + "_fence_gate");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable((Block)block, 5, 20);
        return block;
    }

    public static Block createWoodButton(String name) {
        GEWoodButtonBlock block = new GEWoodButtonBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_button");
        itemBlock.setRegistryName(name + "_button");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        return block;
    }

    public static Block createWoodPressPlate(String name) {
        GEWoodenPressurePlateBlock block = new GEWoodenPressurePlateBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_pressure_plate");
        itemBlock.setRegistryName(name + "_pressure_plate");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        return block;
    }

    public static Block createSign(WoodType woodType, String name) {
        GESignBlock standingSign = new GESignBlock(woodType);
        standingSign.setRegistryName(name + "_sign");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)standingSign);
        return standingSign;
    }

    public static Block createWallSign(WoodType woodType, String name) {
        GEWallSignBlock wallSign = new GEWallSignBlock(woodType);
        wallSign.setRegistryName(name + "_wall_sign");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)wallSign);
        return wallSign;
    }

    public static Block createChest(String name) {
        GEChestBlock block = new GEChestBlock(name);
        GEChestItem chestItem = new GEChestItem((Block)block);
        block.setRegistryName(name + "_chest");
        chestItem.setRegistryName(name + "_chest");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)chestItem);
        return block;
    }

    public static Block createTrappedChest(String name) {
        GETrappedChestBlock block = new GETrappedChestBlock(name);
        GETrappedChestItem trappedChestItem = new GETrappedChestItem((Block)block);
        block.setRegistryName(name + "_trapped_chest");
        trappedChestItem.setRegistryName(name + "_trapped_chest");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)trappedChestItem);
        return block;
    }

    public static Block createBookshelf(String name) {
        GEBookshelfBlock block = new GEBookshelfBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_bookshelf");
        itemBlock.setRegistryName(name + "_bookshelf");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable(block, 30, 20);
        return block;
    }

    public static Block createWoodLadder(String name) {
        GELadderBlock block = new GELadderBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_ladder");
        itemBlock.setRegistryName(name + "_ladder");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        return block;
    }

    public static Block createVerticalPlanks(String name) {
        GEPlanksBlock block = new GEPlanksBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName("vertical_" + name + "_planks");
        itemBlock.setRegistryName("vertical_" + name + "_planks");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable(block, 5, 20);
        return block;
    }

    public static Block createWoodVerticalSlab(String name) {
        VerticalSlabBlock block = new VerticalSlabBlock(GEProperties.WOOD);
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_vertical_slab");
        itemBlock.setRegistryName(name + "_vertical_slab");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable(block, 5, 20);
        return block;
    }

    public static Block createQuarkPost(Block strippedPost, String name) {
        WoodPostBlock block = new WoodPostBlock(strippedPost);
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_post");
        itemBlock.setRegistryName(name + "_post");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable(block, 5, 20);
        return block;
    }

    public static Block createQuarkStrippedPost(Block post, String name) {
        WoodPostBlock block = new WoodPostBlock(post);
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName("stripped_" + name + "_post");
        itemBlock.setRegistryName("stripped_" + name + "_post");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable(block, 5, 20);
        return block;
    }

    public static Block createLeafCarpet(String name) {
        LeafCarpetBlock block = new LeafCarpetBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_leaf_carpet");
        itemBlock.setRegistryName(name + "_leaf_carpet");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable(block, 30, 60);
        return block;
    }

    public static Block createQuarkHedge(String name) {
        HedgeBlock block = new HedgeBlock();
        BlockItem itemBlock = new BlockItem((Block)block, new Item.Properties().m_41491_((CreativeModeTab)GECreativeTab.instance));
        block.setRegistryName(name + "_hedge");
        itemBlock.setRegistryName(name + "_hedge");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ModVanillaCompat.registerFlammable((Block)block, 5, 20);
        return block;
    }
}

