/*
 * Decompiled with CFR 0.152.
 */
package com.hydroartdragon3.genericeco.core.util.registry;

import com.hydroartdragon3.genericeco.common.item.GEBasicDrinkItem;
import com.hydroartdragon3.genericeco.common.item.GEBoatItem;
import com.hydroartdragon3.genericeco.common.item.GEFuelItem;
import com.hydroartdragon3.genericeco.core.misc.GEProperties;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GEItemRegistryUtil {
    public static Item createItem(Item item, String name) {
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return item;
    }

    public static Item createFoodItem(FoodProperties food, String name) {
        Item item = new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41489_(food));
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return item;
    }

    public static Item createDrinkItem(FoodProperties food, int duration, int stackSize, String name) {
        GEBasicDrinkItem item = new GEBasicDrinkItem(new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41487_(stackSize).m_41489_(food), duration);
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return item;
    }

    public static Item createBowlItem(FoodProperties food, String name) {
        BowlFoodItem item = new BowlFoodItem(new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41487_(1).m_41489_(food));
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return item;
    }

    public static Item createFuelItem(Item.Properties properties, int burnTime, String name) {
        GEFuelItem item = new GEFuelItem(properties, burnTime);
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return item;
    }

    public static Item createSign(Block standingSign, Block wallSign, String name) {
        SignItem signItem = new SignItem(GEProperties.SIGN_ITEM, standingSign, wallSign);
        signItem.setRegistryName(name + "_sign");
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)signItem);
        return signItem;
    }

    public static Item createBoat(String name) {
        GEBoatItem item = new GEBoatItem(name);
        item.setRegistryName(name + "_boat");
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return item;
    }
}

