/*
 * Decompiled with CFR 0.152.
 */
package furgl.infinitory.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.class_3518;
import net.minecraft.class_3532;

public class Config {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().serializeNulls().create();
    private static final String FILE = "./config/infinitory.cfg";
    private static File file;
    public static int maxStackSize;
    public static int maxExtraSlots;
    public static int dropsOnDeath;

    public static void init() {
        try {
            file = new File(FILE);
            if (!file.exists()) {
                file.createNewFile();
                Config.writeToFile(true);
            }
            Config.readFromFile();
            Config.writeToFile(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readFromFile() {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            JsonObject parser = class_3518.method_15255((Reader)reader);
            JsonElement element = parser.get("Max Item Stack Size");
            maxStackSize = element == null ? Integer.MAX_VALUE : class_3532.method_15340((int)element.getAsInt(), (int)64, (int)Integer.MAX_VALUE);
            element = parser.get("Max Extra Inventory Slots");
            maxExtraSlots = element == null ? Integer.MAX_VALUE : class_3532.method_15340((int)element.getAsInt(), (int)0, (int)Integer.MAX_VALUE);
            element = parser.get("Items to Drop on Death (when keepInventory = false) (0 = Everything, 1 = Up to a stack of each item, 2 = Up to a stack of each item in your hotbar, offhand, and armor slots)");
            dropsOnDeath = element == null ? 1 : class_3532.method_15340((int)element.getAsInt(), (int)0, (int)2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile(boolean writeDefaults) {
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonObject obj = new JsonObject();
            obj.addProperty("Max Item Stack Size", (Number)(writeDefaults ? Integer.MAX_VALUE : maxStackSize));
            obj.addProperty("Max Extra Inventory Slots", (Number)(writeDefaults ? Integer.MAX_VALUE : maxExtraSlots));
            obj.addProperty("Items to Drop on Death (when keepInventory = false) (0 = Everything, 1 = Up to a stack of each item, 2 = Up to a stack of each item in your hotbar, offhand, and armor slots)", (Number)(writeDefaults ? 1 : dropsOnDeath));
            writer.write(GSON.toJson((JsonElement)obj));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

