/*
 * Decompiled with CFR 0.152.
 */
package furgl.infinitory.mixin.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import furgl.infinitory.config.Config;
import furgl.infinitory.impl.inventory.IPlayerInventory;
import furgl.infinitory.impl.inventory.IScreenHandler;
import furgl.infinitory.impl.inventory.InfinitorySlot;
import furgl.infinitory.impl.inventory.SortingType;
import furgl.infinitory.impl.lists.MainDefaultedList;
import furgl.infinitory.impl.network.PacketManager;
import furgl.infinitory.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1661.class})
public abstract class PlayerInventoryMixin
implements class_1263,
IPlayerInventory {
    @Unique
    private SortingType sortingType;
    @Unique
    private boolean sortAscending;
    @Unique
    private int additionalSlots;
    @Unique
    private int differenceInAdditionalSlots;
    @Unique
    private boolean needToUpdateInfinitorySize;
    @Unique
    private boolean needToUpdateClient;
    @Unique
    private boolean needToSort;
    @Shadow
    @Final
    public class_1657 field_7546;
    @Shadow
    @Final
    @Mutable
    public class_2371<class_1799> field_7547;
    @Shadow
    @Final
    public class_2371<class_1799> field_7548;
    @Shadow
    @Final
    public class_2371<class_1799> field_7544;
    @Shadow
    @Final
    @Mutable
    private List<class_2371<class_1799>> field_7543;
    private class_2371<class_1799> tempMain;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void constructor(CallbackInfo ci) {
        this.field_7547 = MainDefaultedList.ofSize(36, class_1799.field_8037, this);
        this.field_7543 = ImmutableList.of(this.field_7547, this.field_7548, this.field_7544);
        this.updateInfinitorySize();
    }

    @Unique
    private void sort() {
        if (!this.field_7546.field_6002.field_9236 && this.getSortingType() != SortingType.NONE) {
            int i;
            ArrayList list = Lists.newArrayList();
            block0: for (i = 9; i < this.field_7547.size(); ++i) {
                class_1799 addingStack = ((class_1799)this.field_7547.get(i)).method_7972();
                if (addingStack.method_7960()) continue;
                for (class_1799 stack : list) {
                    if (!this.canStackAddMore(stack, addingStack)) continue;
                    int amountToAdd = addingStack.method_7947();
                    if (amountToAdd > this.method_5444() - stack.method_7947()) {
                        amountToAdd = this.method_5444() - stack.method_7947();
                    }
                    if (amountToAdd <= 0) continue;
                    stack.method_7933(amountToAdd);
                    addingStack.method_7934(amountToAdd);
                    if (!addingStack.method_7960()) continue;
                    continue block0;
                }
                list.add(addingStack);
            }
            this.getSortingType().sort(list, this.sortAscending);
            for (i = 9; i < this.field_7547.size(); ++i) {
                class_1799 stack = class_1799.field_8037;
                if (i - 9 < list.size()) {
                    stack = (class_1799)list.get(i - 9);
                }
                ((MainDefaultedList)this.field_7547).delegate.set(i, stack.method_7972());
            }
        }
    }

    @Override
    @Unique
    public SortingType getSortingType() {
        if (this.sortingType == null) {
            this.sortingType = SortingType.NONE;
        }
        return this.sortingType;
    }

    @Override
    @Unique
    public void setSortingType(SortingType type) {
        if (type != null && type != this.sortingType) {
            this.sortingType = type;
            this.syncInfinitoryValues();
        }
    }

    @Override
    @Unique
    public boolean getSortingAscending() {
        return this.sortAscending;
    }

    @Override
    @Unique
    public void setSortAscending(boolean sortAscending) {
        if (sortAscending != this.sortAscending) {
            this.sortAscending = sortAscending;
            this.syncInfinitoryValues();
        }
    }

    @Override
    @Unique
    public void needToSort() {
        this.needToSort = true;
        this.needToUpdateInfinitorySize();
    }

    @Override
    @Unique
    public void syncInfinitoryValues() {
        if (!this.field_7546.field_6002.field_9236 && this.field_7546 instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(this.additionalSlots);
            buf.writeInt(this.getSortingType().ordinal());
            buf.writeBoolean(this.sortAscending);
            ServerPlayNetworking.send((class_3222)((class_3222)this.field_7546), (class_2960)PacketManager.UPDATE_INFINITORY_PACKET_ID, (class_2540)buf);
        }
    }

    @Inject(method={"clone(Lnet/minecraft/entity/player/PlayerInventory;)V"}, at={@At(value="INVOKE")})
    public void cloneCopyInfinitoryValues(class_1661 other, CallbackInfo ci) {
        this.setAdditionalSlots(((IPlayerInventory)other).getAdditionalSlots());
        this.setSortingType(((IPlayerInventory)other).getSortingType());
        this.setSortAscending(((IPlayerInventory)other).getSortingAscending());
    }

    @Override
    @Unique
    public void updateInfinitorySize() {
        if (!this.field_7546.field_6002.field_9236) {
            boolean isFull = true;
            boolean isFullBeforeLastItem = true;
            boolean lastRowEmpty = true;
            int lastItem = -1;
            for (int i = this.field_7547.size() - 1; i >= 9; --i) {
                boolean empty = ((class_1799)this.field_7547.get(i)).method_7960();
                if (!empty && lastItem == -1) {
                    lastItem = i;
                }
                if (empty) {
                    if (lastItem != -1) {
                        isFullBeforeLastItem = false;
                    }
                    isFull = false;
                }
                if (i < this.field_7547.size() - 9 || empty) continue;
                lastRowEmpty = false;
            }
            this.setAdditionalSlots(lastItem - 35 + ((isFull || isFullBeforeLastItem && lastRowEmpty) && (lastItem + 1) % 9 == 0 ? 9 : 0));
        }
    }

    @Unique
    private void updateExtraSlots() {
        ((IScreenHandler)this.field_7546.field_7498).updateExtraSlots();
        if (this.field_7546.field_7512 != null) {
            ((IScreenHandler)this.field_7546.field_7512).updateExtraSlots();
        }
    }

    @Override
    public void setAdditionalSlots(int additionalSlots) {
        if ((additionalSlots = class_3532.method_15340((int)additionalSlots, (int)0, (int)Config.maxExtraSlots)) % 9 != 0) {
            additionalSlots += 9 - additionalSlots % 9;
        }
        while (this.field_7547.size() < 36 + additionalSlots) {
            this.field_7547.add((Object)class_1799.field_8037);
        }
        while (this.field_7547.size() > 36 + additionalSlots) {
            this.field_7547.remove(this.field_7547.size() - 1);
        }
        if (this.additionalSlots != additionalSlots) {
            this.differenceInAdditionalSlots = this.additionalSlots - additionalSlots;
            this.additionalSlots = additionalSlots;
            this.syncInfinitoryValues();
            this.updateExtraSlots();
        }
    }

    @Inject(method={"updateItems"}, at={@At(value="TAIL")})
    public void updateItems(CallbackInfo ci) {
        if (this.needToSort) {
            this.sort();
            this.needToSort = false;
        }
        if (this.needToUpdateInfinitorySize) {
            this.updateInfinitorySize();
            this.needToUpdateInfinitorySize = false;
        } else {
            this.updateExtraSlots();
        }
        if (this.needToUpdateClient) {
            this.field_7546.field_7498.method_37420();
            if (this.field_7546.field_7512 != null) {
                this.field_7546.field_7512.method_37420();
            }
            this.needToUpdateClient = false;
        }
        this.differenceInAdditionalSlots = 0;
    }

    @Override
    @Unique
    public void needToUpdateInfinitorySize() {
        this.needToUpdateInfinitorySize = true;
    }

    @Override
    @Unique
    public void needToUpdateClient() {
        if (!this.field_7546.field_6002.field_9236) {
            this.needToUpdateClient = true;
        }
    }

    @Override
    @Unique
    public int getAdditionalSlots() {
        return this.additionalSlots;
    }

    @Override
    @Unique
    public int getDifferenceInAdditionalSlots() {
        return this.differenceInAdditionalSlots;
    }

    public int method_5444() {
        return Config.maxStackSize;
    }

    @Inject(method={"dropAll"}, at={@At(value="HEAD")}, cancellable=true)
    public void dropAll(CallbackInfo ci) {
        if (Config.dropsOnDeath == 1) {
            for (List list : this.field_7543) {
                for (class_1799 stack : list) {
                    if (stack.method_7960()) continue;
                    this.field_7546.method_7329(stack.method_7971(stack.method_7914()), true, false);
                }
            }
            ci.cancel();
        } else if (Config.dropsOnDeath == 2) {
            ArrayList list = Lists.newArrayList();
            list.addAll(this.field_7544);
            list.addAll(this.field_7548);
            list.addAll(this.field_7547.subList(0, 9));
            for (class_1799 stack : list) {
                if (stack.method_7960()) continue;
                this.field_7546.method_7329(stack.method_7971(stack.method_7914()), true, false);
            }
            ci.cancel();
        }
    }

    @Inject(method={"canStackAddMore"}, at={@At(value="RETURN")}, cancellable=true)
    public void canStackAddMore(class_1799 existingStack, class_1799 stack, CallbackInfoReturnable<Boolean> ci) {
        ci.setReturnValue((Object)this.canStackAddMore(existingStack, stack));
    }

    @Unique
    private boolean canStackAddMore(class_1799 existingStack, class_1799 stack) {
        if (!existingStack.method_7960() && class_1799.method_31577((class_1799)existingStack, (class_1799)stack)) {
            if (!stack.method_7946()) {
                for (int i = 0; i < this.method_5439(); ++i) {
                    if (this.method_5438(i) != existingStack) continue;
                    return InfinitorySlot.SlotType.getType((int)i, (int)this.getAdditionalSlots()).stackNonStackables;
                }
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"dropSelectedItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;removeStack(II)Lnet/minecraft/item/ItemStack;"))
    public class_1799 removeStack(class_1661 inventory, int slot, int amount) {
        return inventory.method_5434(slot, Math.min(amount, 64));
    }

    @Redirect(method={"offer"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getMaxCount()I"))
    public int offerGetMaxCount(class_1799 stack) {
        return Config.maxStackSize;
    }

    @Redirect(method={"addStack(ILnet/minecraft/item/ItemStack;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getMaxCount()I"))
    public int addStackGetMaxCount(class_1799 stack) {
        return Config.maxStackSize;
    }

    @Inject(method={"addStack(ILnet/minecraft/item/ItemStack;)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;increment(I)V")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    public void addStackPickingUpNonStackables(int slot, class_1799 stack, CallbackInfoReturnable<Integer> ci, class_1792 item, int i, class_1799 itemStack, int j) {
        if (!stack.method_7946() && !InfinitorySlot.SlotType.getType((int)slot, (int)this.getAdditionalSlots()).stackNonStackables && i + j > stack.method_7914() - itemStack.method_7947()) {
            i += j;
            j = stack.method_7914() - itemStack.method_7947();
            i -= j;
        }
        itemStack.method_7933(j);
        itemStack.method_7912(5);
        ci.setReturnValue((Object)i);
    }

    @Inject(method={"markDirty()V"}, at={@At(value="RETURN")})
    public void markDirtySort(CallbackInfo ci) {
        if (this.getSortingType() == SortingType.QUANTITY) {
            this.needToSort();
        }
    }

    @Inject(method={"insertStack(ILnet/minecraft/item/ItemStack;)Z"}, at={@At(value="RETURN")})
    public void insertStackSort(int slot, class_1799 stack, CallbackInfoReturnable<Integer> ci) {
        if (ci.getReturnValueZ() && this.getSortingType() == SortingType.QUANTITY) {
            this.needToSort();
        }
    }

    @Inject(method={"removeStack(II)Lnet/minecraft/item/ItemStack;"}, at={@At(value="RETURN")})
    public void removeStackUpdateSize(int slot, int amount, CallbackInfoReturnable<class_1799> ci) {
        if (this.getSortingType() == SortingType.QUANTITY) {
            this.sort();
        }
        this.updateInfinitorySize();
        this.updateExtraSlots();
    }

    @Inject(method={"readNbt"}, at={@At(value="RETURN")})
    public void readNbt(class_2499 nbtList, CallbackInfo ci) {
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            if (nbtCompound.method_10545("InfinitorySlot")) {
                int slot = nbtCompound.method_10550("InfinitorySlot");
                class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound);
                if (itemStack.method_7960()) continue;
                while (slot > this.field_7547.size() - 1 && this.field_7547.size() < Config.maxExtraSlots) {
                    this.field_7547.add((Object)class_1799.field_8037);
                }
                if (slot < 0 || slot >= this.field_7547.size()) continue;
                this.field_7547.set(slot, (Object)itemStack);
                continue;
            }
            if (!nbtCompound.method_10545("InfinitorySortingType")) continue;
            this.sortingType = Utils.getEnumFromString(SortingType.class, nbtCompound.method_10558("InfinitorySortingType")).orElse(SortingType.NONE);
            this.sortAscending = nbtCompound.method_10577("InfinitorySortingAscending");
        }
        this.needToUpdateInfinitorySize();
        this.needToUpdateClient();
    }

    @Inject(method={"writeNbt"}, at={@At(value="HEAD")})
    public void writeNbt1(class_2499 nbtList, CallbackInfoReturnable<class_2487> ci) {
        this.tempMain = this.field_7547;
        if (this.field_7547.size() > 36) {
            this.field_7547 = ((MainDefaultedList)this.field_7547).subList(0, 36);
        }
    }

    @Inject(method={"writeNbt"}, at={@At(value="RETURN")})
    public void writeNbt2(class_2499 nbtList, CallbackInfoReturnable<class_2487> ci) {
        this.field_7547 = this.tempMain;
        for (int i = 36; i < this.field_7547.size(); ++i) {
            if (((class_1799)this.field_7547.get(i)).method_7960()) continue;
            class_2487 nbt = new class_2487();
            nbt.method_10567("Slot", (byte)-6);
            nbt.method_10569("InfinitorySlot", i);
            ((class_1799)this.field_7547.get(i)).method_7953(nbt);
            nbtList.add((Object)nbt);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10582("InfinitorySortingType", this.getSortingType().name());
        nbt.method_10556("InfinitorySortingAscending", this.getSortingAscending());
        nbtList.add((Object)nbt);
    }
}

