/*
 * Decompiled with CFR 0.152.
 */
package furgl.infinitory.mixin.render;

import com.mojang.blaze3d.systems.RenderSystem;
import furgl.infinitory.config.Config;
import furgl.infinitory.impl.inventory.IPlayerInventory;
import furgl.infinitory.impl.inventory.IScreenHandler;
import furgl.infinitory.impl.inventory.InfinitorySlot;
import furgl.infinitory.impl.network.PacketManager;
import furgl.infinitory.impl.render.IHandledScreen;
import furgl.infinitory.impl.render.InfinitoryTexturedButtonWidget;
import furgl.infinitory.utils.Utils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class HandledScreenMixin<T extends class_1703>
extends class_437
implements IHandledScreen {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    @Final
    protected T field_2797;
    @Unique
    private static final class_2960 VANILLA_BACKGROUND = new class_2960("textures/gui/container/creative_inventory/tab_items.png");
    @Unique
    private static final class_2960 VANILLA_SCROLLBAR = new class_2960("textures/gui/container/creative_inventory/tabs.png");
    @Unique
    private static final class_2960 TEXTURES = new class_2960("infinitory", "textures/gui/container/inventory/inventory.png");
    @Unique
    private boolean scrolling;
    @Unique
    private class_1661 playerInventory;
    @Unique
    private int prevMainSlotsSize;
    @Unique
    private class_344 buttonSortingType;
    @Unique
    private class_344 buttonSortingDirection;

    protected HandledScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void constructor(T handler, class_1661 inventory, class_2561 title, CallbackInfo ci) {
        this.playerInventory = inventory;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        IPlayerInventory inv = (IPlayerInventory)this.playerInventory;
        this.buttonSortingType = new InfinitoryTexturedButtonWidget(0, 0, 16, 16, 1, inv.getSortingType().ordinal() * 17 + 1, 100, TEXTURES, 256, 256, button -> {
            ClientPlayNetworking.send((class_2960)PacketManager.SORTING_TYPE_PACKET_ID, (class_2540)PacketByteBufs.empty());
            inv.setSortingType(inv.getSortingType().getNextType());
            ((InfinitoryTexturedButtonWidget)button).v = inv.getSortingType().ordinal() * 17 + 1;
        }, (button, matrices, mouseX, mouseY) -> this.method_25424(matrices, (class_2561)new class_2588("button.sortingType").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)new class_2588("button.sortingType." + inv.getSortingType().name().toLowerCase()).method_27692(class_124.field_1068)), mouseX, mouseY), class_2561.method_30163((String)""));
        this.method_37063((class_364)this.buttonSortingType);
        this.buttonSortingDirection = new InfinitoryTexturedButtonWidget(0, 0, 16, 16, 18, inv.getSortingAscending() ? 18 : 1, 100, TEXTURES, 256, 256, button -> {
            ClientPlayNetworking.send((class_2960)PacketManager.SORTING_ASCENDING_PACKET_ID, (class_2540)PacketByteBufs.empty());
            inv.setSortAscending(!((IPlayerInventory)this.playerInventory).getSortingAscending());
            ((InfinitoryTexturedButtonWidget)button).v = inv.getSortingAscending() ? 18 : 1;
        }, (button, matrices, mouseX, mouseY) -> this.method_25424(matrices, (class_2561)new class_2588("button.sortingDirection").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)new class_2588("button.sortingDirection." + (inv.getSortingAscending() ? "ascending" : "descending")).method_27692(class_124.field_1068)), mouseX, mouseY), class_2561.method_30163((String)""));
        this.method_37063((class_364)this.buttonSortingDirection);
        this.resetButtons();
    }

    @Override
    @Unique
    public void resetScrollPosition() {
        this.scrolling = false;
        Utils.setScrollPosition(this.playerInventory.field_7546, 0.0f);
        this.scrollItems(0.0f);
    }

    @Unique
    private int getScrollbarX() {
        if (this.field_2797 instanceof IScreenHandler) {
            return ((IScreenHandler)this.field_2797).getScrollbarX();
        }
        return -999;
    }

    @Unique
    private int getScrollbarMinY() {
        if (this.field_2797 instanceof IScreenHandler) {
            return ((IScreenHandler)this.field_2797).getScrollbarMinY();
        }
        return -999;
    }

    @Unique
    private int getScrollbarMaxY() {
        if (this.field_2797 instanceof IScreenHandler) {
            return ((IScreenHandler)this.field_2797).getScrollbarMaxY();
        }
        return -999;
    }

    @Inject(method={"drawSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawSlot(class_4587 matrices, class_1735 slot, CallbackInfo ci) {
        if (slot instanceof InfinitorySlot && !((InfinitorySlot)slot).isVisible()) {
            ci.cancel();
        }
    }

    @Override
    @Unique
    public void onMouseScroll(double mouseX, double mouseY, double amount) {
        int increment = (this.playerInventory.field_7547.size() - 36) / 9;
        float scrollPosition = this.shouldShowScrollbar() ? (float)((double)Utils.getScrollPosition(this.playerInventory.field_7546) - amount / (double)increment) : 0.0f;
        scrollPosition = class_3532.method_15363((float)scrollPosition, (float)0.0f, (float)1.0f);
        Utils.setScrollPosition(this.playerInventory.field_7546, scrollPosition);
        this.scrollItems(scrollPosition);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="RETURN")}, cancellable=true)
    public void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> ci) {
        if (this.isClickInScrollbar(mouseX, mouseY)) {
            this.scrolling = true;
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="RETURN")})
    public void mouseReleased(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> ci) {
        if (button == 0) {
            this.scrolling = false;
        }
    }

    @Unique
    private boolean isClickInScrollbar(double mouseX, double mouseY) {
        int minX = this.field_2776 + this.getScrollbarX() - 4;
        int maxX = minX + 13;
        int minY = this.field_2800 + this.getScrollbarMinY();
        int maxY = this.field_2800 + this.getScrollbarMaxY();
        return mouseX >= (double)minX && mouseY >= (double)minY && mouseX <= (double)maxX && mouseY <= (double)maxY;
    }

    @Inject(method={"mouseDragged"}, at={@At(value="RETURN")}, cancellable=true)
    public void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> ci) {
        if (this.scrolling) {
            int minY = this.field_2800 + this.getScrollbarMinY();
            int maxY = this.field_2800 + this.getScrollbarMaxY();
            float scrollPosition = ((float)mouseY - (float)minY - 7.5f) / ((float)(maxY - minY) - 15.0f);
            scrollPosition = class_3532.method_15363((float)scrollPosition, (float)0.0f, (float)1.0f);
            Utils.setScrollPosition(this.playerInventory.field_7546, scrollPosition);
            if (this.field_2797 instanceof IScreenHandler) {
                this.scrollItems(scrollPosition);
            }
            ci.setReturnValue((Object)true);
        }
    }

    @Unique
    public void scrollItems(float position) {
        if (this.playerInventory instanceof IPlayerInventory) {
            int size = this.playerInventory.field_7547.size();
            int increment = (this.playerInventory.field_7547.size() - 1) / 9 - 3;
            int rowsOffset = -class_3532.method_15340((int)((int)((double)(position * (float)increment) + 0.5)), (int)0, (int)(size / 9));
            for (InfinitorySlot slot : ((IScreenHandler)this.field_2797).getInfinitorySlots()) {
                slot.setRowsOffset(rowsOffset);
            }
        }
    }

    @Unique
    public boolean shouldShowSortingButtons() {
        boolean creativeScreen = this instanceof class_481;
        boolean creativeInventory = creativeScreen && ((class_481)this).method_2469() == class_1761.field_7918.method_7741();
        return !creativeScreen || creativeInventory;
    }

    @Unique
    public boolean shouldShowScrollbar() {
        return this.playerInventory.field_7547.size() > 36 && this.shouldShowSortingButtons();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE")})
    private void renderInvoke(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.resetButtons();
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderTail(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.shouldShowScrollbar()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34542);
            int x = this.field_2776 + this.getScrollbarX();
            int minY = this.field_2800 + this.getScrollbarMinY();
            int maxY = this.field_2800 + this.getScrollbarMaxY();
            boolean creativeScreen = this instanceof class_481;
            RenderSystem.setShaderTexture((int)0, (class_2960)VANILLA_BACKGROUND);
            if (creativeScreen) {
                this.method_25302(matrices, x - 5, minY - 1, 174, 17, 14, 50);
                this.method_25302(matrices, x - 5, minY + 10, 174, 86, 14, 43);
            } else {
                this.method_25302(matrices, x - 5, minY - 7, 174, 0, 21, 10);
                this.method_25302(matrices, x - 5, minY + 10, 174, 86, 21, 50);
                this.method_25302(matrices, x - 5, minY - 2, 174, 16, 21, 15);
                this.method_25302(matrices, x - 5, minY - 7, 192, 3, 2, 1);
                this.method_25302(matrices, x - 5, minY + 59, 192, 3, 2, 1);
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)VANILLA_SCROLLBAR);
            this.method_25302(matrices, x - 4, minY + (int)((float)(maxY - minY - 17) * Utils.getScrollPosition(this.playerInventory.field_7546)), 232, 0, 12, 15);
        }
    }

    @Redirect(method={"drawSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getMaxCount()I"))
    public int getMaxCountDrawSlot(class_1799 stack) {
        if (this.field_2797 instanceof class_1723 || this.field_2797 instanceof class_481.class_483) {
            return Config.maxStackSize;
        }
        return stack.method_7914();
    }

    @Redirect(method={"calculateOffset"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getMaxCount()I"))
    public int getMaxCountCalculateOffset(class_1799 stack) {
        if (this.field_2797 instanceof class_1723 || this.field_2797 instanceof class_481.class_483) {
            return Config.maxStackSize;
        }
        return stack.method_7914();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (this.prevMainSlotsSize != this.playerInventory.field_7547.size()) {
            this.onMouseScroll(0.0, 0.0, this.prevMainSlotsSize > this.playerInventory.field_7547.size() ? -1.0 : 1.0);
            this.prevMainSlotsSize = this.playerInventory.field_7547.size();
        }
    }

    private void resetButtons() {
        boolean shouldShowButtons;
        int x = this.field_2776 + this.getScrollbarX() + (this instanceof class_481 || this.shouldShowScrollbar() ? 20 : 0);
        int midY = this.field_2800 + this.getScrollbarMinY() + (this.getScrollbarMaxY() - this.getScrollbarMinY()) / 2 - this.buttonSortingType.method_25364() / 2;
        this.buttonSortingType.method_1893(x, midY - 10);
        this.buttonSortingDirection.method_1893(x, midY + 10);
        this.buttonSortingType.field_22764 = shouldShowButtons = this.shouldShowSortingButtons() && this.getScrollbarX() > 0;
        this.buttonSortingDirection.field_22764 = shouldShowButtons;
    }
}

