/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client;

import com.mojang.blaze3d.platform.InputConstants;
import mezz.itemzoom.client.KeyBindings;
import mezz.itemzoom.client.config.Config;

public class InputHandler {
    private final Config config;
    private final KeyBindings keyBindings;
    private boolean enableKeyHeld = false;

    public InputHandler(Config config, KeyBindings keyBindings) {
        this.config = config;
        this.keyBindings = keyBindings;
    }

    public boolean handleInput(InputConstants.Key input) {
        if (this.keyBindings.toggle.isActiveAndMatches(input)) {
            this.config.toggleEnabled();
            return true;
        }
        if (this.keyBindings.zoomIn.isActiveAndMatches(input)) {
            this.config.increaseZoom();
            return true;
        }
        if (this.keyBindings.zoomOut.isActiveAndMatches(input)) {
            this.config.decreaseZoom();
            return true;
        }
        if (this.keyBindings.hold.isActiveAndMatches(input)) {
            this.enableKeyHeld = true;
            return true;
        }
        return false;
    }

    public boolean handleInputReleased(InputConstants.Key input) {
        if (this.keyBindings.hold.isActiveAndMatches(input)) {
            this.enableKeyHeld = false;
            return true;
        }
        return false;
    }

    public boolean isEnableKeyHeld() {
        return this.enableKeyHeld;
    }
}

