/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mezz.itemzoom.client.compat.JeiCompat;
import mezz.itemzoom.client.config.Config;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.client.RenderProperties;

@OnlyIn(value=Dist.CLIENT)
public class RenderHandler {
    public static boolean rendering = false;
    private static boolean renderedThisFrame = false;
    private final Config config;
    private final Supplier<Boolean> isEnableKeyHeld;
    private final KeyMapping keyMapping;

    public RenderHandler(Config config, Supplier<Boolean> isEnableKeyHeld, KeyMapping keyMapping) {
        this.config = config;
        this.isEnableKeyHeld = isEnableKeyHeld;
        this.keyMapping = keyMapping;
    }

    public void onScreenDrawn() {
        rendering = renderedThisFrame;
        renderedThisFrame = false;
    }

    public void onItemStackTooltip(@Nullable ItemStack itemStack, int x, PoseStack poseStack) {
        AbstractContainerScreen containerScreen;
        if (!this.config.isToggledEnabled() && !this.isEnableKeyHeld.get().booleanValue()) {
            return;
        }
        if (itemStack == null || itemStack.m_41619_()) {
            return;
        }
        if (this.config.isJeiOnly() && !ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)JeiCompat.getStackUnderMouse())) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Screen currentScreen = minecraft.f_91080_;
        Screen screen = currentScreen;
        if (screen instanceof AbstractContainerScreen && x > (containerScreen = (AbstractContainerScreen)screen).getGuiLeft()) {
            this.renderZoomedStack(itemStack, containerScreen, minecraft, poseStack);
            renderedThisFrame = true;
        }
    }

    private void renderZoomedStack(ItemStack itemStack, AbstractContainerScreen<?> containerScreen, Minecraft minecraft, PoseStack poseStack) {
        int scaledHeight = minecraft.m_91268_().m_85446_();
        float scale = (float)this.config.getZoomAmount() / 100.0f * (float)containerScreen.getGuiLeft() / 17.0f;
        float xPosition = ((float)containerScreen.getGuiLeft() / scale - 16.0f) / 2.0f;
        float yPosition = ((float)scaledHeight / scale - 16.0f) / 2.0f;
        Font font = RenderHandler.getFont(minecraft, itemStack);
        PoseStack modelPoseStack = RenderSystem.m_157191_();
        modelPoseStack.m_85836_();
        modelPoseStack.m_85841_(scale, scale, 1.0f);
        modelPoseStack.m_85837_((double)xPosition, (double)yPosition, 0.0);
        minecraft.m_91291_().m_115203_(itemStack, 0, 0);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        modelPoseStack.m_85849_();
        this.renderItemOverlayIntoGUI(font, itemStack);
        RenderSystem.m_157182_();
        if (this.config.showHelpText()) {
            String modName = "Item Zoom";
            int stringWidth = font.m_92895_(modName);
            int x = (containerScreen.getGuiLeft() - stringWidth) / 2;
            int y = (scaledHeight + Math.round(19.0f * scale)) / 2;
            float z = minecraft.m_91291_().f_115093_ + 200.0f;
            poseStack = new PoseStack();
            poseStack.m_85837_(0.0, 0.0, (double)z);
            font.m_92883_(poseStack, modName, (float)x, (float)y, 0x404040);
            if (this.config.isToggledEnabled()) {
                Component displayName = this.keyMapping.m_90863_();
                String toggleText = displayName.getString();
                stringWidth = font.m_92895_(toggleText);
                x = (containerScreen.getGuiLeft() - stringWidth) / 2;
                Objects.requireNonNull(font);
                font.m_92883_(poseStack, toggleText, (float)x, (float)(y += 9), 0x404040);
            }
        }
    }

    private static Font getFont(Minecraft minecraft, ItemStack itemStack) {
        IItemRenderProperties renderProperties = RenderProperties.get((ItemStack)itemStack);
        Font fontRenderer = renderProperties.getFont(itemStack);
        if (fontRenderer == null) {
            fontRenderer = minecraft.f_91062_;
        }
        return fontRenderer;
    }

    public void renderItemOverlayIntoGUI(Font font, ItemStack stack) {
        if (!stack.m_41619_()) {
            Minecraft minecraft = Minecraft.m_91087_();
            Tesselator tesselator = Tesselator.m_85913_();
            if (this.config.showStackSize() && stack.m_41613_() != 1) {
                String s = String.valueOf(stack.m_41613_());
                float x = 17 - font.m_92895_(s);
                float y = 9.0f;
                float z = minecraft.m_91291_().f_115093_ + 200.0f;
                PoseStack poseStack = new PoseStack();
                poseStack.m_85837_(0.0, 0.0, (double)z);
                BufferBuilder bufferBuilder = tesselator.m_85915_();
                MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)bufferBuilder);
                font.m_92811_(s, x, y, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                bufferSource.m_109911_();
            }
            if (this.config.showDurabilityBar() && stack.m_41720_().showDurabilityBar(stack)) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69461_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                double durability = stack.m_41720_().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)durability * 13.0f);
                int rgb = stack.m_41720_().getRGBDurabilityForDisplay(stack);
                RenderHandler.fillRect(bufferbuilder, 2, 13, 13, 2, 0, 0, 0, 255);
                RenderHandler.fillRect(bufferbuilder, 2, 13, i, 1, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, 255);
                RenderSystem.m_69478_();
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
            if (this.config.showCooldown()) {
                float f;
                LocalPlayer localplayer = minecraft.f_91074_;
                if (localplayer == null) {
                    f = 0.0f;
                } else {
                    ItemCooldowns cooldowns = localplayer.m_36335_();
                    f = cooldowns.m_41521_(stack.m_41720_(), minecraft.m_91296_());
                }
                if (f > 0.0f) {
                    RenderSystem.m_69465_();
                    RenderSystem.m_69472_();
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    BufferBuilder bufferbuilder = tesselator.m_85915_();
                    RenderHandler.fillRect(bufferbuilder, 0, Mth.m_14143_((float)(16.0f * (1.0f - f))), 16, Mth.m_14167_((float)(16.0f * f)), 255, 255, 255, 127);
                    RenderSystem.m_69493_();
                    RenderSystem.m_69482_();
                }
            }
        }
    }

    private static void fillRect(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_5483_((double)x, (double)y, 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)x, (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)y, 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)renderer);
    }
}

