/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client.config;

import mezz.itemzoom.client.compat.JeiCompat;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    private static final int MIN_ZOOM = 10;
    private static final int MAX_ZOOM = 100;
    private static final int DEFAULT_ZOOM = 80;
    private final ForgeConfigSpec.ConfigValue<Boolean> toggledEnabled;
    private final ForgeConfigSpec.ConfigValue<Integer> zoomAmount;
    private final ForgeConfigSpec.ConfigValue<Boolean> jeiOnly;
    private final ForgeConfigSpec.ConfigValue<Boolean> showHelpText;
    private final ForgeConfigSpec.ConfigValue<Boolean> showDurabilityBar;
    private final ForgeConfigSpec.ConfigValue<Boolean> showStackSize;
    private final ForgeConfigSpec.ConfigValue<Boolean> showCooldown;
    private final ForgeConfigSpec configSpec;

    public Config() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("itemzoom");
        this.toggledEnabled = builder.comment("If set to \"false\", Item Zoom will be disabled.").translation("config.itemzoom.toggle.enabled").define("toggled.enabled", true);
        this.zoomAmount = builder.comment("Set lower amount to make the item zoom less.").translation("config.itemzoom.zoom.amount").defineInRange("zoom.amount", (Comparable)Integer.valueOf(80), (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(100), Integer.class);
        this.jeiOnly = builder.comment("Zoom items only from the JEI overlay with ingredients list.").translation("config.itemzoom.jei.only").define("jei.only", false);
        this.showHelpText = builder.comment("Display name \"Item Zoom\" and the hotkey to toggle this mod below the zoomed item.").translation("config.itemzoom.show.help.text").define("show.help.text", true);
        this.showDurabilityBar = builder.comment("Display the item's durability bar when zoomed.").translation("config.itemzoom.show.damage.bar").define("show.damage.bar", false);
        this.showStackSize = builder.comment("Display the item's stack size when zoomed.").translation("config.itemzoom.show.stack.size").define("show.stack.size", false);
        this.showCooldown = builder.comment("Display the item's cooldown animation when zoomed.").translation("config.itemzoom.show.cooldown").define("show.cooldown", false);
        this.configSpec = builder.build();
    }

    public boolean isToggledEnabled() {
        return (Boolean)this.toggledEnabled.get();
    }

    public void toggleEnabled() {
        this.toggledEnabled.set((Object)((Boolean)this.toggledEnabled.get() == false ? 1 : 0));
        this.toggledEnabled.save();
    }

    public void increaseZoom() {
        int newZoomAmount = Math.round((float)this.getZoomAmount() * 1.1f);
        this.setZoomAmount(newZoomAmount);
    }

    public void decreaseZoom() {
        int newZoomAmount = Math.round((float)this.getZoomAmount() / 1.1f);
        this.setZoomAmount(newZoomAmount);
    }

    public int getZoomAmount() {
        return (Integer)this.zoomAmount.get();
    }

    public boolean showHelpText() {
        return (Boolean)this.showHelpText.get();
    }

    public boolean showDurabilityBar() {
        return (Boolean)this.showDurabilityBar.get();
    }

    public boolean showStackSize() {
        return (Boolean)this.showStackSize.get();
    }

    public boolean showCooldown() {
        return (Boolean)this.showCooldown.get();
    }

    public void setZoomAmount(int zoomAmount) {
        if (zoomAmount > 100) {
            zoomAmount = 100;
        } else if (zoomAmount < 10) {
            zoomAmount = 10;
        }
        int oldZoomAmount = (Integer)this.zoomAmount.get();
        if (oldZoomAmount != zoomAmount) {
            this.zoomAmount.set((Object)zoomAmount);
            this.zoomAmount.save();
        }
    }

    public boolean isJeiOnly() {
        return (Boolean)this.jeiOnly.get() != false && JeiCompat.isLoaded();
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }
}

