/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;

public class DynamicResourcePack
implements class_3262 {
    private final String packName;
    private Map<DynamicResourceKey, Supplier<InputStream>> dynamicResourceMap = new HashMap<DynamicResourceKey, Supplier<InputStream>>();

    public DynamicResourcePack(String packName) {
        this.packName = packName;
    }

    public void clear() {
        this.dynamicResourceMap.clear();
    }

    public boolean removeResource(class_3264 type, class_2960 location) {
        DynamicResourceKey key = new DynamicResourceKey(type.method_14413(), location.method_12836(), location.method_12832());
        if (this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean registerResource(class_3264 type, class_2960 location, Supplier<InputStream> resourceSupplier) {
        return this.register(type.method_14413(), location.method_12836(), location.method_12832(), resourceSupplier);
    }

    public boolean registerRootResource(String path, Supplier<InputStream> resourceSupplier) {
        return this.register("root", "", path, resourceSupplier);
    }

    private boolean register(String directory, String namespace, String path, Supplier<InputStream> resourceSupplier) {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (!this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.put(key, resourceSupplier);
            return true;
        }
        return false;
    }

    public InputStream method_14410(String path) throws IOException {
        return this.getResource("root", "", path);
    }

    public InputStream method_14405(class_3264 type, class_2960 location) throws IOException {
        return this.getResource(type.method_14413(), location.method_12836(), location.method_12832());
    }

    private InputStream getResource(String directory, String namespace, String path) throws IOException {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (this.dynamicResourceMap.containsKey(key)) {
            return this.dynamicResourceMap.get(key).get();
        }
        throw new FileNotFoundException("Can't find dynamic resource " + path + ". Please ensure it has been registered.");
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        return this.dynamicResourceMap.entrySet().stream().filter(entry -> ((DynamicResourceKey)entry.getKey()).namespace.contentEquals(namespace)).filter(entry -> ((DynamicResourceKey)entry.getKey()).path.startsWith(path)).filter(entry -> ((DynamicResourceKey)entry.getKey()).type.contentEquals(type.method_14413())).filter(entry -> filter.test(((DynamicResourceKey)entry.getKey()).path)).map(entry -> new class_2960(namespace, ((DynamicResourceKey)entry.getKey()).path)).collect(Collectors.toList());
    }

    public boolean method_14411(class_3264 type, class_2960 location) {
        return this.dynamicResourceMap.containsKey(new DynamicResourceKey(type.method_14413(), location.method_12836(), location.method_12832()));
    }

    public Set<String> method_14406(class_3264 type) {
        HashSet<String> namespaces = new HashSet<String>();
        for (DynamicResourceKey key : this.dynamicResourceMap.keySet()) {
            if (!type.method_14413().contentEquals(key.type)) continue;
            namespaces.add(key.namespace);
        }
        return namespaces;
    }

    public <T> T method_14407(class_3270<T> p_10291_) throws IOException {
        return null;
    }

    public String method_14409() {
        return this.packName;
    }

    public void close() {
    }

    private record DynamicResourceKey(String type, String namespace, String path) {
    }
}

