/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.RenderTickEvents;
import com.anthonyhilyard.iceberg.events.RenderTooltipEvents;
import com.anthonyhilyard.legendarytooltips.FrameResourceParser;
import com.anthonyhilyard.legendarytooltips.LegacyConfigConverter;
import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import com.anthonyhilyard.prism.item.ItemColors;
import com.anthonyhilyard.prism.text.DynamicColor;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraftforge.api.ModLoadingContext;
import net.minecraftforge.api.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class LegendaryTooltips
implements ClientModInitializer {
    public static final int STANDARD = -1;
    public static final int NO_BORDER = -2;
    public static final int NUM_FRAMES = 16;
    private static class_1799 lastTooltipItem = null;

    public void onInitializeClient() {
        ModLoadingContext.registerConfig((String)"legendarytooltips", (ModConfig.Type)ModConfig.Type.COMMON, (IConfigSpec)LegendaryTooltipsConfig.SPEC);
        LegacyConfigConverter.convert();
        RenderTooltipEvents.GATHER.register(LegendaryTooltips::onGatherComponentsEvent);
        RenderTooltipEvents.COLOREXT.register(LegendaryTooltips::onTooltipColorEvent);
        RenderTooltipEvents.POSTEXT.register(LegendaryTooltips::onPostTooltipEvent);
        RenderTickEvents.START.register(LegendaryTooltips::onRenderTick);
        ModConfigEvent.RELOADING.register(LegendaryTooltipsConfig::onReload);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)FrameResourceParser.INSTANCE);
    }

    private static LegendaryTooltipsConfig.FrameDefinition getDefinitionColors(class_1799 item, int defaultStartBorder, int defaultEndBorder, int defaultStartBackground, int defaultEndBackground) {
        LegendaryTooltipsConfig.FrameDefinition result = LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(item);
        switch (result.index()) {
            case -2: {
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, () -> defaultEndBorder, () -> defaultStartBackground, () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
                break;
            }
            case -1: {
                if (!((Boolean)LegendaryTooltipsConfig.INSTANCE.bordersMatchRarity.get()).booleanValue()) break;
                DynamicColor rarityColor = DynamicColor.fromRgb((int)ItemColors.getColorForItem((class_1799)item, (class_5251)class_5251.method_27718((class_124)class_124.field_1068)).method_27716());
                int hue = rarityColor.hue();
                boolean addHue = false;
                if (hue >= 62 && hue <= 240) {
                    addHue = true;
                }
                int startHue = addHue ? hue - 4 : hue + 4;
                int endHue = addHue ? hue + 18 : hue - 18;
                int startBGHue = addHue ? hue - 3 : hue + 3;
                int endBGHue = addHue ? hue + 13 : hue - 13;
                startHue = (startHue + 360) % 360;
                endHue = (endHue + 360) % 360;
                startBGHue = (startBGHue + 360) % 360;
                endBGHue = (endBGHue + 360) % 360;
                DynamicColor startColor = DynamicColor.fromAHSV((int)255, (int)startHue, (int)rarityColor.saturation(), (int)rarityColor.value());
                DynamicColor endColor = DynamicColor.fromAHSV((int)255, (int)endHue, (int)rarityColor.saturation(), (int)((int)((float)rarityColor.value() * 0.95f)));
                DynamicColor startBGColor = DynamicColor.fromAHSV((int)228, (int)startBGHue, (int)((int)((float)rarityColor.saturation() * 0.9f)), (int)14);
                DynamicColor endBGColor = DynamicColor.fromAHSV((int)253, (int)endBGHue, (int)((int)((float)rarityColor.saturation() * 0.8f)), (int)18);
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> startColor.method_27716(), () -> endColor.method_27716(), () -> startBGColor.method_27716(), () -> endBGColor.method_27716(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
            }
        }
        if (result.startBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, result.endBorder(), result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), () -> defaultEndBorder, result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.startBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), () -> defaultStartBackground, result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), result.startBackground(), () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        return result;
    }

    public static void onRenderTick(float partialTick) {
        class_1799 item;
        class_310 client = class_310.method_1551();
        TooltipDecor.updateTimer();
        if (client.field_1755 != null && client.field_1755 instanceof class_465 && ((class_465)client.field_1755).field_2787 != null && ((class_465)client.field_1755).field_2787.method_7681() && lastTooltipItem != (item = ((class_465)client.field_1755).field_2787.method_7677())) {
            TooltipDecor.resetTimer();
            lastTooltipItem = item;
        }
    }

    public static RenderTooltipEvents.GatherResult onGatherComponentsEvent(class_1799 itemStack, int screenWidth, int screenHeight, List<Either<class_5348, class_5632>> tooltipElements, int maxWidth, int index) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack).index() != -2) {
            TooltipDecor.setCachedLines(tooltipElements, index);
        }
        return new RenderTooltipEvents.GatherResult(class_1269.field_5811, maxWidth, tooltipElements);
    }

    public static RenderTooltipEvents.ColorExtResult onTooltipColorEvent(class_1799 stack, List<class_5684> components, class_4587 poseStack, int x, int y, class_327 font, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd, boolean comparison, int index) {
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltips.getDefinitionColors(stack, borderStart, borderEnd, backgroundStart, backgroundEnd);
        TooltipDecor.setCurrentTooltipBorderStart(frameDefinition.startBorder().get());
        TooltipDecor.setCurrentTooltipBorderEnd(frameDefinition.endBorder().get());
        RenderTooltipEvents.ColorExtResult result = comparison ? new RenderTooltipEvents.ColorExtResult(frameDefinition.startBackground().get().intValue(), frameDefinition.endBackground().get().intValue(), 0, 0) : new RenderTooltipEvents.ColorExtResult(frameDefinition.startBackground().get().intValue(), frameDefinition.endBackground().get().intValue(), frameDefinition.startBorder().get().intValue(), frameDefinition.endBorder().get().intValue());
        return result;
    }

    public static void onPostTooltipEvent(class_1799 itemStack, List<class_5684> components, class_4587 poseStack, int x, int y, class_327 font, int width, int height, boolean comparison, int index) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack).index() == -2) {
            return;
        }
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.tooltipShadow.get()).booleanValue()) {
            if (comparison) {
                TooltipDecor.drawShadow(poseStack, x, y - 11, width, height + 11);
            } else {
                TooltipDecor.drawShadow(poseStack, x, y, width, height);
            }
        }
        if (comparison) {
            TooltipDecor.drawBorder(poseStack, x, y - 11, width, height + 11, itemStack, font, LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack), comparison, index);
        } else {
            TooltipDecor.drawBorder(poseStack, x, y, width, height, itemStack, font, LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(itemStack), comparison, index);
        }
    }
}

