/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.config;

import com.mlib.config.IConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigGroup
implements IConfig {
    protected List<IConfig> configTypeList = new ArrayList<IConfig>();
    private final String groupName;
    private final String comment;

    public ConfigGroup(String groupName, String comment) {
        this.groupName = groupName;
        this.comment = comment;
    }

    @Override
    public void build(ForgeConfigSpec.Builder builder) {
        if (!this.comment.equals("")) {
            builder.comment(this.comment);
        }
        builder.push(this.groupName);
        for (IConfig config : this.configTypeList) {
            config.build(builder);
        }
        builder.pop();
    }

    public <GroupType extends IConfig> GroupType addGroup(GroupType group) {
        this.configTypeList.add(group);
        return group;
    }

    public void addGroups(ConfigGroup ... groups) {
        this.configTypeList.addAll(Arrays.asList(groups));
    }

    public <ConfigType extends IConfig> ConfigType addConfig(ConfigType config) {
        this.configTypeList.add(config);
        return config;
    }

    public void addConfigs(IConfig ... configs) {
        this.configTypeList.addAll(Arrays.asList(configs));
    }
}

