/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.events;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;

@Mod.EventBusSubscriber
public class ExplosionSizeEvent
extends Event
implements IModBusEvent {
    public final World world;
    public final Explosion explosion;
    public float size;
    public boolean causesFire;

    public ExplosionSizeEvent(World world, Explosion explosion) {
        this.world = world;
        this.explosion = explosion;
        this.size = this.explosion.field_77280_f;
        this.causesFire = this.explosion.field_77286_a;
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Start explosionEvent) {
        World world = explosionEvent.getWorld();
        Explosion explosion = explosionEvent.getExplosion();
        ExplosionSizeEvent event = new ExplosionSizeEvent(world, explosion);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if ((double)(event.size / explosion.field_77280_f) > 1.25 && world instanceof ServerWorld) {
            ExplosionSizeEvent.sendToPlayers((ServerWorld)world, explosion, explosion.getPosition(), event.size);
        }
        explosion.field_77280_f = event.size;
        explosion.field_77286_a = event.causesFire;
    }

    private static void sendToPlayers(ServerWorld world, Explosion explosion, Vector3d position, float size) {
        double x = position.field_72450_a;
        double y = position.field_72448_b;
        double z = position.field_72449_c;
        for (ServerPlayerEntity player : world.func_217369_A()) {
            if (!(player.func_70092_e(x, y, z) < 4096.0)) continue;
            player.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(x, y, z, size, explosion.func_180343_e(), (Vector3d)explosion.func_77277_b().get(player)));
        }
    }
}

