/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.items;

import com.mlib.MajruszLibrary;
import com.mlib.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ItemHelper {
    private static final double MINECRAFT_WEAPON_ENCHANT_CHANCE = 0.25;
    private static final double MINECRAFT_ARMOR_PIECE_ENCHANT_CHANCE = 0.5;

    public static int getEnchantmentLevel(double clampedRegionalDifficulty) {
        return (int)(5.0 + 18.0 * clampedRegionalDifficulty);
    }

    public static ItemStack damageItem(ItemStack itemStack, double factor) {
        if ((double)itemStack.func_77958_k() * factor < 1.0) {
            return ItemStack.field_190927_a;
        }
        itemStack.func_196085_b(MajruszLibrary.RANDOM.nextInt((int)((double)itemStack.func_77958_k() * factor)));
        return itemStack;
    }

    public static ItemStack enchantItem(ItemStack itemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed) {
        int enchantmentLevel = ItemHelper.getEnchantmentLevel(clampedRegionalDifficulty);
        return EnchantmentHelper.func_77504_a((java.util.Random)MajruszLibrary.RANDOM, (ItemStack)itemStack, (int)enchantmentLevel, (boolean)isTreasureAllowed);
    }

    public static ItemStack tryEnchantItem(ItemStack itemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed, double chance) {
        return Random.tryChance(chance) ? ItemHelper.enchantItem(itemStack, clampedRegionalDifficulty, isTreasureAllowed) : itemStack;
    }

    public static ItemStack tryEnchantWeapon(ItemStack weaponItemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed) {
        return ItemHelper.tryEnchantItem(weaponItemStack, clampedRegionalDifficulty, isTreasureAllowed, 0.25);
    }

    public static ItemStack tryEnchantArmor(ItemStack armorItemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed) {
        return ItemHelper.tryEnchantItem(armorItemStack, clampedRegionalDifficulty, isTreasureAllowed, 0.5);
    }

    public static ItemStack damageAndEnchantItem(ItemStack itemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed, double damageFactor) {
        return ItemHelper.damageItem(ItemHelper.enchantItem(itemStack, clampedRegionalDifficulty, isTreasureAllowed), damageFactor);
    }

    public static void addEnchantmentTypeToItemGroup(EnchantmentType type, ItemGroup itemGroup) {
        EnchantmentType[] group = itemGroup.func_111225_m();
        if (group.length == 0) {
            itemGroup.func_111229_a(new EnchantmentType[]{type});
            return;
        }
        EnchantmentType[] temporary = new EnchantmentType[group.length + 1];
        System.arraycopy(group, 0, temporary, 0, group.length);
        temporary[group.length - 1] = type;
        itemGroup.func_111229_a(temporary);
    }

    public static void addEnchantmentTypesToItemGroup(ItemGroup itemGroup, EnchantmentType ... types) {
        EnchantmentType[] group = itemGroup.func_111225_m();
        if (group.length == 0) {
            itemGroup.func_111229_a(types);
        } else {
            EnchantmentType[] temporary = new EnchantmentType[group.length + types.length];
            System.arraycopy(group, 0, temporary, 0, group.length);
            int i = 1;
            EnchantmentType[] enchantmentTypeArray = types;
            int n = enchantmentTypeArray.length;
            for (int j = 0; j < n; ++j) {
                EnchantmentType enchantmentType;
                temporary[group.length - i] = enchantmentType = enchantmentTypeArray[j];
                ++i;
            }
            itemGroup.func_111229_a(temporary);
        }
    }

    public static void giveItemStackToPlayer(ItemStack itemStack, PlayerEntity player, ServerWorld world) {
        if (!player.field_71071_by.func_70441_a(itemStack)) {
            double x = player.func_226277_ct_();
            double y = player.func_226278_cu_() + 1.0;
            double z = player.func_226281_cx_();
            world.func_217376_c((Entity)new ItemEntity((World)world, x, y, z, itemStack));
        }
    }
}

